/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.applet.Applet;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import net.runelite.api.Constants;
import net.runelite.client.RuneLiteModule;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.rs.ClientLoader;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.SplashScreen;
import org.necrotic.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class RuneLite {
    private static final Logger log = LoggerFactory.getLogger(RuneLite.class);
    public static final File RUNELITE_DIR = new File(System.getProperty("user.home"), ".rol");
    public static final File CACHE_DIR = new File(RUNELITE_DIR, "cache");
    public static final File PLUGINS_DIR = new File(RUNELITE_DIR, "plugins");
    public static final File PROFILES_DIR = new File(RUNELITE_DIR, "profiles");
    public static final File SCREENSHOT_DIR = new File(RUNELITE_DIR, "screenshots");
    public static final File LOGS_DIR = new File(RUNELITE_DIR, "logs");
    public static final File DEFAULT_SESSION_FILE = new File(RUNELITE_DIR, "session");
    public static final File DEFAULT_CONFIG_FILE = new File(RUNELITE_DIR, "settings.properties");
    private static Injector injector;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private EventBus eventBus;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientUI clientUI;
    @Inject
    @Nullable
    private Client client;
    @Inject
    @Nullable
    private Applet applet;

    public static void main(String[] args) {
        Locale.setDefault(Locale.ENGLISH);
        boolean developerMode = false;
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
            log.error("Uncaught exception:", throwable);
            if (throwable instanceof AbstractMethodError) {
                log.error("Classes are out of date; Build with maven again.");
            }
        });
        PROFILES_DIR.mkdirs();
        try {
            ClientLoader clientLoader = new ClientLoader();
            SplashScreen.init();
            SplashScreen.stage(0.0, "Retrieving client", "");
            injector = Guice.createInjector(new RuneLiteModule(clientLoader, developerMode, DEFAULT_CONFIG_FILE));
            injector.getInstance(RuneLite.class).start();
        }
        catch (Exception e) {
            log.error("Failure during startup", e);
            System.exit(1);
            SplashScreen.stop();
        }
    }

    public void start() throws Exception {
        injector.injectMembers(this.client);
        this.configManager.load();
        if (this.applet != null) {
            this.applet.setSize(Constants.GAME_FIXED_SIZE);
            String oldHome = System.setProperty("user.home", "/" + RUNELITE_DIR.getAbsolutePath());
            try {
                this.applet.init();
            }
            finally {
                System.setProperty("user.home", oldHome);
            }
            this.applet.start();
        }
        SplashScreen.stage(0.57, null, "Loading configuration");
        this.pluginManager.setOutdated(false);
        this.pluginManager.loadCorePlugins();
        this.pluginManager.loadDefaultPluginConfiguration(null);
        SplashScreen.stage(0.7, null, "Finalizing configuration");
        this.clientUI.init();
        this.eventBus.register(this.clientUI);
        this.eventBus.register(this.pluginManager);
        this.eventBus.register(this.configManager);
        this.pluginManager.startPlugins();
        SplashScreen.stage(0.75, null, "Starting core interface");
        SplashScreen.stop();
        this.clientUI.show();
    }

    private void setSystemOut() {
        System.setOut(new PrintStream(new OutputStream(){

            @Override
            public void write(int arg0) {
            }
        }));
    }

    public static Injector getInjector() {
        return injector;
    }
}

