/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import com.google.common.reflect.ClassPath;
import com.google.inject.CreationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.client.RuneLite;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.events.PluginChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginInstantiationException;
import net.runelite.client.task.Schedule;
import net.runelite.client.task.ScheduledMethod;
import net.runelite.client.task.Scheduler;
import net.runelite.client.ui.SplashScreen;
import net.runelite.client.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PluginManager {
    private static final Logger log = LoggerFactory.getLogger(PluginManager.class);
    private static final String PLUGIN_PACKAGE = "net.runelite.client.plugins";
    private final boolean developerMode;
    private final EventBus eventBus;
    private final Scheduler scheduler;
    private final ConfigManager configManager;
    private final ScheduledExecutorService executor;
    private final List<Plugin> plugins = new CopyOnWriteArrayList<Plugin>();
    private final List<Plugin> activePlugins = new CopyOnWriteArrayList<Plugin>();
    boolean isOutdated;

    @Inject
    @VisibleForTesting
    PluginManager(@Named(value="developerMode") boolean developerMode, EventBus eventBus, Scheduler scheduler, ConfigManager configManager, ScheduledExecutorService executor) {
        this.developerMode = developerMode;
        this.eventBus = eventBus;
        this.scheduler = scheduler;
        this.configManager = configManager;
        this.executor = executor;
    }

    private void refreshPlugins() {
        this.loadDefaultPluginConfiguration(null);
        SwingUtilities.invokeLater(() -> {
            for (Plugin plugin : this.getPlugins()) {
                try {
                    if (this.isPluginEnabled(plugin) == this.activePlugins.contains(plugin)) continue;
                    if (this.activePlugins.contains(plugin)) {
                        this.stopPlugin(plugin);
                        continue;
                    }
                    this.startPlugin(plugin);
                }
                catch (PluginInstantiationException e) {
                    log.warn("Error during starting/stopping plugin {}", (Object)plugin.getClass().getSimpleName(), (Object)e);
                }
            }
        });
    }

    public Config getPluginConfigProxy(Plugin plugin) {
        try {
            Injector injector = plugin.getInjector();
            for (Key<?> key : injector.getAllBindings().keySet()) {
                Class<?> type = key.getTypeLiteral().getRawType();
                if (!Config.class.isAssignableFrom(type)) continue;
                return (Config)injector.getInstance(key);
            }
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            log.warn("Unable to get plugin config", e);
        }
        return null;
    }

    public List<Config> getPluginConfigProxies(Collection<Plugin> plugins) {
        ArrayList<Injector> injectors = new ArrayList<Injector>();
        if (plugins == null) {
            injectors.add(RuneLite.getInjector());
            plugins = this.getPlugins();
        }
        plugins.forEach(pl -> injectors.add(pl.getInjector()));
        ArrayList<Config> list = new ArrayList<Config>();
        for (Injector injector : injectors) {
            for (Key<?> key : injector.getAllBindings().keySet()) {
                Class<?> type = key.getTypeLiteral().getRawType();
                if (!Config.class.isAssignableFrom(type)) continue;
                Config config = (Config)injector.getInstance(key);
                list.add(config);
            }
        }
        return list;
    }

    public void loadDefaultPluginConfiguration(Collection<Plugin> plugins) {
        try {
            for (Config config : this.getPluginConfigProxies(plugins)) {
                this.configManager.setDefaultConfiguration(config, false);
            }
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable ex) {
            log.warn("Unable to reset plugin configuration", ex);
        }
    }

    public void startPlugins() {
        ArrayList<Plugin> scannedPlugins = new ArrayList<Plugin>(this.plugins);
        int loaded = 0;
        for (Plugin plugin : scannedPlugins) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    try {
                        this.startPlugin(plugin);
                    }
                    catch (PluginInstantiationException ex) {
                        log.warn("Unable to start plugin {}", (Object)plugin.getClass().getSimpleName(), (Object)ex);
                        this.plugins.remove(plugin);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            ++loaded;
        }
        SplashScreen.stage(0.8, 1.0, null, "Starting plugins", loaded, scannedPlugins.size(), false);
    }

    public void loadCorePlugins() throws IOException, PluginInstantiationException {
        SplashScreen.stage(0.59, null, "Loading Plugins");
        ClassPath classPath = ClassPath.from(this.getClass().getClassLoader());
        List<Class<?>> plugins = classPath.getTopLevelClassesRecursive(PLUGIN_PACKAGE).stream().map(ClassPath.ClassInfo::load).collect(Collectors.toList());
        this.loadPlugins(plugins, (loaded, total) -> SplashScreen.stage(0.6, 0.7, null, "Loading Plugins", loaded, total, false));
    }

    public List<Plugin> loadPlugins(List<Class<?>> plugins, BiConsumer<Integer, Integer> onPluginLoaded) throws PluginInstantiationException {
        MutableGraph graph = GraphBuilder.directed().build();
        for (Class<?> clazz : plugins) {
            PluginDescriptor pluginDescriptor = clazz.getAnnotation(PluginDescriptor.class);
            if (pluginDescriptor == null) {
                if (clazz.getSuperclass() != Plugin.class) continue;
                log.warn("Class {} is a plugin, but has no plugin descriptor", (Object)clazz);
                continue;
            }
            if (clazz.getSuperclass() != Plugin.class) {
                log.warn("Class {} has plugin descriptor, but is not a plugin", (Object)clazz);
                continue;
            }
            if (!pluginDescriptor.loadWhenOutdated() && this.isOutdated || pluginDescriptor.developerPlugin() && !this.developerMode) continue;
            Class<?> pluginClass = clazz;
            graph.addNode(pluginClass);
        }
        for (Class<Object> pluginClazz : graph.nodes()) {
            PluginDependency[] pluginDependencies = (PluginDependency[])pluginClazz.getAnnotationsByType(PluginDependency.class);
            for (PluginDependency pluginDependency : pluginDependencies) {
                graph.putEdge(pluginClazz, pluginDependency.value());
            }
        }
        if (Graphs.hasCycle(graph)) {
            throw new PluginInstantiationException("Plugin dependency graph contains a cycle!");
        }
        List sortedPlugins = this.topologicalSort(graph);
        sortedPlugins = Lists.reverse(sortedPlugins);
        int loaded = 0;
        ArrayList<Plugin> newPlugins = new ArrayList<Plugin>();
        for (Class pluginClazz : sortedPlugins) {
            try {
                Plugin plugin = this.instantiate(this.plugins, pluginClazz);
                newPlugins.add(plugin);
                this.plugins.add(plugin);
            }
            catch (PluginInstantiationException ex) {
                log.warn("Error instantiating plugin!", ex);
            }
            ++loaded;
            if (onPluginLoaded == null) continue;
            onPluginLoaded.accept(loaded, sortedPlugins.size());
        }
        return newPlugins;
    }

    public boolean startPlugin(Plugin plugin) throws PluginInstantiationException {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.activePlugins.contains(plugin) || !this.isPluginEnabled(plugin)) {
            return false;
        }
        this.activePlugins.add(plugin);
        try {
            plugin.startUp();
            log.debug("Plugin {} is now running", (Object)plugin.getClass().getSimpleName());
            this.eventBus.register(plugin);
            this.schedule(plugin);
            this.eventBus.post(new PluginChanged(plugin, true));
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new PluginInstantiationException(ex);
        }
        return true;
    }

    public boolean stopPlugin(Plugin plugin) throws PluginInstantiationException {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.activePlugins.remove(plugin)) {
            return false;
        }
        this.unschedule(plugin);
        this.eventBus.unregister(plugin);
        try {
            plugin.shutDown();
            log.debug("Plugin {} is now stopped", (Object)plugin.getClass().getSimpleName());
            this.eventBus.post(new PluginChanged(plugin, false));
        }
        catch (Exception ex) {
            throw new PluginInstantiationException(ex);
        }
        return true;
    }

    public void setPluginEnabled(Plugin plugin, boolean enabled) {
        String keyName = plugin.getClass().getSimpleName().toLowerCase();
        this.configManager.setConfiguration("runelite", keyName, String.valueOf(enabled));
    }

    public boolean isPluginEnabled(Plugin plugin) {
        String keyName = plugin.getClass().getSimpleName().toLowerCase();
        String value = this.configManager.getConfiguration("runelite", keyName);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        PluginDescriptor pluginDescriptor = plugin.getClass().getAnnotation(PluginDescriptor.class);
        return pluginDescriptor == null || pluginDescriptor.enabledByDefault();
    }

    private Plugin instantiate(List<Plugin> scannedPlugins, Class<Plugin> clazz) throws PluginInstantiationException {
        Plugin plugin;
        PluginDependency[] pluginDependencies = (PluginDependency[])clazz.getAnnotationsByType(PluginDependency.class);
        ArrayList<Plugin> deps = new ArrayList<Plugin>();
        for (PluginDependency pluginDependency : pluginDependencies) {
            Optional<Plugin> dependency = scannedPlugins.stream().filter(p -> p.getClass() == pluginDependency.value()).findFirst();
            if (!dependency.isPresent()) {
                throw new PluginInstantiationException("Unmet dependency for " + clazz.getSimpleName() + ": " + pluginDependency.value().getSimpleName());
            }
            deps.add(dependency.get());
        }
        try {
            plugin = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new PluginInstantiationException(ex);
        }
        try {
            Module pluginModule = binder -> {
                binder.bind(clazz).toInstance(plugin);
                binder.install(plugin);
                for (Plugin p : deps) {
                    Module p2 = binder2 -> {
                        binder2.bind(p.getClass()).toInstance(p);
                        binder2.install(p);
                    };
                    binder.install(p2);
                }
            };
            Injector pluginInjector = RuneLite.getInjector().createChildInjector(pluginModule);
            pluginInjector.injectMembers(plugin);
            plugin.injector = pluginInjector;
        }
        catch (CreationException ex) {
            throw new PluginInstantiationException(ex);
        }
        log.debug("Loaded plugin {}", (Object)clazz.getSimpleName());
        return plugin;
    }

    public void add(Plugin plugin) {
        this.plugins.add(plugin);
    }

    public void remove(Plugin plugin) {
        this.plugins.remove(plugin);
    }

    public Collection<Plugin> getPlugins() {
        return this.plugins;
    }

    private void schedule(Plugin plugin) {
        for (Method method : plugin.getClass().getMethods()) {
            Schedule schedule = method.getAnnotation(Schedule.class);
            if (schedule == null) continue;
            Runnable runnable = null;
            try {
                Class<?> clazz = method.getDeclaringClass();
                MethodHandles.Lookup caller = ReflectUtil.privateLookupIn(clazz);
                MethodType subscription = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
                MethodHandle target = caller.findVirtual(clazz, method.getName(), subscription);
                CallSite site = LambdaMetafactory.metafactory(caller, "run", MethodType.methodType(Runnable.class, clazz), subscription, target, subscription);
                MethodHandle factory = site.getTarget();
                runnable = factory.bindTo(plugin).invokeExact();
            }
            catch (Throwable e) {
                log.warn("Unable to create lambda for method {}", (Object)method, (Object)e);
            }
            ScheduledMethod scheduledMethod = new ScheduledMethod(schedule, method, plugin, runnable);
            log.debug("Scheduled task {}", (Object)scheduledMethod);
            this.scheduler.addScheduledMethod(scheduledMethod);
        }
    }

    private void unschedule(Plugin plugin) {
        ArrayList<ScheduledMethod> methods = new ArrayList<ScheduledMethod>(this.scheduler.getScheduledMethods());
        for (ScheduledMethod method : methods) {
            if (method.getObject() != plugin) continue;
            log.debug("Removing scheduled task {}", (Object)method);
            this.scheduler.removeScheduledMethod(method);
        }
    }

    private <T> List<T> topologicalSort(Graph<T> graph) {
        MutableGraph graphCopy = Graphs.copyOf(graph);
        ArrayList l = new ArrayList();
        Set s2 = graphCopy.nodes().stream().filter(node -> graphCopy.inDegree(node) == 0).collect(Collectors.toSet());
        while (!s2.isEmpty()) {
            Iterator it = s2.iterator();
            Object n = it.next();
            it.remove();
            l.add(n);
            for (Object m3 : graphCopy.successors(n)) {
                graphCopy.removeEdge(n, m3);
                if (graphCopy.inDegree(m3) != 0) continue;
                s2.add(m3);
            }
        }
        if (!graphCopy.edges().isEmpty()) {
            throw new RuntimeException("Graph has at least one cycle");
        }
        return l;
    }

    public void setOutdated(boolean isOutdated) {
        this.isOutdated = isOutdated;
    }
}

