/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.config;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.plugins.config.ConfigPanel;
import net.runelite.client.plugins.config.PluginConfigurationDescriptor;
import net.runelite.client.plugins.config.PluginListPanel;
import net.runelite.client.plugins.config.PluginToggleButton;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

class PluginListItem
extends JPanel {
    private static final ImageIcon CONFIG_ICON;
    private static final ImageIcon CONFIG_ICON_HOVER;
    private static final ImageIcon ON_STAR;
    private static final ImageIcon OFF_STAR;
    private final PluginListPanel pluginListPanel;
    private final PluginConfigurationDescriptor pluginConfig;
    private final List<String> keywords = new ArrayList<String>();
    private final JToggleButton pinButton;
    private final JToggleButton onOffToggle;

    PluginListItem(PluginListPanel pluginListPanel, PluginConfigurationDescriptor pluginConfig) {
        this.pluginListPanel = pluginListPanel;
        this.pluginConfig = pluginConfig;
        Collections.addAll(this.keywords, pluginConfig.getName().toLowerCase().split(" "));
        Collections.addAll(this.keywords, pluginConfig.getDescription().toLowerCase().split(" "));
        Collections.addAll(this.keywords, pluginConfig.getTags());
        this.setLayout(new BorderLayout(3, 0));
        this.setPreferredSize(new Dimension(225, 20));
        JLabel nameLabel = new JLabel(pluginConfig.getName());
        nameLabel.setForeground(Color.WHITE);
        if (!pluginConfig.getDescription().isEmpty()) {
            nameLabel.setToolTipText("<html>" + pluginConfig.getName() + ":<br>" + pluginConfig.getDescription() + "</html>");
        }
        this.pinButton = new JToggleButton(OFF_STAR);
        this.pinButton.setSelectedIcon(ON_STAR);
        SwingUtil.removeButtonDecorations(this.pinButton);
        SwingUtil.addModalTooltip(this.pinButton, "Unpin plugin", "Pin plugin");
        this.pinButton.setPreferredSize(new Dimension(21, 0));
        this.add((Component)this.pinButton, "Before");
        this.pinButton.addActionListener(e -> {
            pluginListPanel.savePinnedPlugins();
            pluginListPanel.refresh();
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        this.add((Component)buttonPanel, "After");
        JMenuItem configMenuItem = null;
        if (pluginConfig.hasConfigurables()) {
            JButton configButton = new JButton(CONFIG_ICON);
            configButton.setRolloverIcon(CONFIG_ICON_HOVER);
            SwingUtil.removeButtonDecorations(configButton);
            configButton.setPreferredSize(new Dimension(25, 0));
            configButton.setVisible(false);
            buttonPanel.add(configButton);
            configButton.addActionListener(e -> {
                configButton.setIcon(CONFIG_ICON);
                this.openGroupConfigPanel();
            });
            configButton.setVisible(true);
            configButton.setToolTipText("Edit plugin configuration");
            configMenuItem = new JMenuItem("Configure");
            configMenuItem.addActionListener(e -> this.openGroupConfigPanel());
        }
        this.add((Component)nameLabel, "Center");
        this.onOffToggle = new PluginToggleButton();
        buttonPanel.add(this.onOffToggle);
        if (pluginConfig.getPlugin() != null) {
            this.onOffToggle.addItemListener(i -> {
                if (this.onOffToggle.isSelected()) {
                    pluginListPanel.startPlugin(pluginConfig.getPlugin());
                } else {
                    pluginListPanel.stopPlugin(pluginConfig.getPlugin());
                }
            });
        } else {
            this.onOffToggle.setVisible(false);
        }
    }

    boolean isPinned() {
        return this.pinButton.isSelected();
    }

    void setPinned(boolean pinned) {
        this.pinButton.setSelected(pinned);
    }

    void setPluginEnabled(boolean enabled) {
        this.onOffToggle.setSelected(enabled);
    }

    private void openGroupConfigPanel() {
        this.pluginListPanel.openConfigurationPanel(this.pluginConfig);
    }

    static void addLabelPopupMenu(final JLabel label, JMenuItem ... menuItems) {
        final JPopupMenu menu = new JPopupMenu();
        Color labelForeground = label.getForeground();
        menu.setBorder(new EmptyBorder(5, 5, 5, 5));
        for (JMenuItem menuItem : menuItems) {
            if (menuItem == null) continue;
            menuItem.addActionListener(e -> label.setForeground(labelForeground));
            menu.add(menuItem);
        }
        label.addMouseListener(new MouseAdapter(){
            private Color lastForeground;

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Component source = (Component)mouseEvent.getSource();
                Point location = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(location, source);
                menu.show(source, location.x, location.y);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.lastForeground = label.getForeground();
                label.setForeground(ColorScheme.BRAND_ORANGE);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                label.setForeground(this.lastForeground);
            }
        });
    }

    public PluginConfigurationDescriptor getPluginConfig() {
        return this.pluginConfig;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    static {
        BufferedImage configIcon = ImageUtil.getResourceStreamFromClass(ConfigPanel.class, "config_edit_icon.png");
        BufferedImage onStar = ImageUtil.getResourceStreamFromClass(ConfigPanel.class, "star_on.png");
        CONFIG_ICON = new ImageIcon(configIcon);
        ON_STAR = new ImageIcon(onStar);
        CONFIG_ICON_HOVER = new ImageIcon(ImageUtil.luminanceOffset(configIcon, -100));
        BufferedImage offStar = ImageUtil.luminanceScale(ImageUtil.grayscaleImage(onStar), 0.77f);
        OFF_STAR = new ImageIcon(offStar);
    }
}

