/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.discord;

import com.google.inject.Inject;
import java.awt.image.BufferedImage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Icons", description="Shows the icons in the title bar", tags={"action", "activity", "external", "integration", "status"})
public class DiscordPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DiscordPlugin.class);
    @Inject
    private ClientToolbar clientToolbar;
    private NavigationButton discordButton;
    private NavigationButton storeButton;
    private NavigationButton GuidesButton;

    @Override
    protected void startUp() throws Exception {
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(this.getClass(), "discord.png");
        this.discordButton = NavigationButton.builder().tab(false).tooltip("Join Discord").icon(icon).onClick(() -> LinkBrowser.browse("https://discord.gg/jMcAesvW46")).build();
        this.clientToolbar.addNavigation(this.discordButton);
        BufferedImage icon2 = ImageUtil.getResourceStreamFromClass(this.getClass(), "store.png");
        this.storeButton = NavigationButton.builder().tab(false).tooltip("Donate Now").icon(icon2).onClick(() -> LinkBrowser.browse("https://ozaraps.com/donate")).build();
        this.clientToolbar.addNavigation(this.storeButton);
        BufferedImage icon3 = ImageUtil.getResourceStreamFromClass(this.getClass(), "guide.png");
        this.GuidesButton = NavigationButton.builder().tab(false).tooltip("Guides").icon(icon3).onClick(() -> LinkBrowser.browse("https://discord.com/channels/1171917551744327791/1183459728370708480")).build();
        this.clientToolbar.addNavigation(this.GuidesButton);
    }

    @Override
    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.discordButton);
        this.clientToolbar.removeNavigation(this.storeButton);
        this.clientToolbar.removeNavigation(this.GuidesButton);
    }
}

