/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.legacy;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.legacy.LegacyConfig;
import org.necrotic.Configuration;
import org.necrotic.client.Client;
import org.necrotic.client.constants.GameFrameConstants;

@PluginDescriptor(name="Client Settings", loadWhenOutdated=true)
public class LegacyPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private LegacyConfig config;

    @Override
    protected void startUp() throws Exception {
        this.syncConfigs();
    }

    @Override
    protected void shutDown() throws Exception {
        super.shutDown();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if ("legacy".contentEquals(configChanged.getGroup())) {
            this.syncConfigs();
        }
    }

    @Provides
    LegacyConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(LegacyConfig.class);
    }

    private void syncConfigs() {
        Configuration.NEW_FUNCTION_KEYS = this.config.useNewFunctionKeys();
        Configuration.NEW_HEALTH_BARS = this.config.useNewHealthBars();
        Configuration.NEW_HITMARKS = this.config.useNewHitsplats();
        Configuration.CONSTITUTION_ENABLED = this.config.useNewDamage();
        Configuration.NEW_CURSORS = this.config.useNewCursors();
        Configuration.DISPLAY_USERNAMES_ABOVE_HEAD = this.config.displayNameAboveHead();
        Configuration.DISPLAY_HP_ABOVE_HEAD = this.config.displayHitpointsAboveHead();
        Configuration.HIGHLIGHT_USERNAME = this.config.highlightNameInChat();
        GameFrameConstants.gameframeType = this.config.useCustomFrame() ? GameFrameConstants.GameFrameType.CUSTOM_1 : (this.config.useNewGameframe() ? GameFrameConstants.GameFrameType.FRAME_554 : GameFrameConstants.GameFrameType.FRAME_525);
        Configuration.FOG_ENABLED = this.config.enableFog();
        Configuration.GROUND_TEXT = this.config.displayNameAboveGroundItems();
    }
}

