/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtil {
    private static final Logger log = LoggerFactory.getLogger(ImageUtil.class);

    public static BufferedImage bufferedImageFromImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        return ImageUtil.toARGB(image);
    }

    public static BufferedImage toARGB(Image image) {
        if (image instanceof BufferedImage && ((BufferedImage)image).getType() == 2) {
            return (BufferedImage)image;
        }
        BufferedImage out = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2d = out.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        g2d.dispose();
        return out;
    }

    public static BufferedImage luminanceOffset(Image rawImg, int offset) {
        BufferedImage image = ImageUtil.toARGB(rawImg);
        float offsetFloat = offset;
        int numComponents = image.getColorModel().getNumComponents();
        float[] scales = new float[numComponents];
        float[] offsets = new float[numComponents];
        Arrays.fill(scales, 1.0f);
        for (int i = 0; i < numComponents; ++i) {
            offsets[i] = offsetFloat;
        }
        offsets[numComponents - 1] = 0.0f;
        return ImageUtil.offset(image, scales, offsets);
    }

    public static BufferedImage luminanceScale(Image rawImg, float percentage) {
        BufferedImage image = ImageUtil.toARGB(rawImg);
        int numComponents = image.getColorModel().getNumComponents();
        float[] scales = new float[numComponents];
        float[] offsets = new float[numComponents];
        Arrays.fill(offsets, 0.0f);
        for (int i = 0; i < numComponents; ++i) {
            scales[i] = percentage;
        }
        scales[numComponents - 1] = 1.0f;
        return ImageUtil.offset(image, scales, offsets);
    }

    public static BufferedImage alphaOffset(Image rawImg, int offset) {
        BufferedImage image = ImageUtil.toARGB(rawImg);
        float offsetFloat = offset;
        int numComponents = image.getColorModel().getNumComponents();
        float[] scales = new float[numComponents];
        float[] offsets = new float[numComponents];
        Arrays.fill(scales, 1.0f);
        Arrays.fill(offsets, 0.0f);
        offsets[numComponents - 1] = offsetFloat;
        return ImageUtil.offset(image, scales, offsets);
    }

    public static BufferedImage alphaOffset(Image rawImg, float percentage) {
        BufferedImage image = ImageUtil.toARGB(rawImg);
        int numComponents = image.getColorModel().getNumComponents();
        float[] scales = new float[numComponents];
        float[] offsets = new float[numComponents];
        Arrays.fill(scales, 1.0f);
        Arrays.fill(offsets, 0.0f);
        scales[numComponents - 1] = percentage;
        return ImageUtil.offset(image, scales, offsets);
    }

    public static BufferedImage grayscaleImage(BufferedImage image) {
        Image grayImage = GrayFilter.createDisabledImage(image);
        return ImageUtil.bufferedImageFromImage(grayImage);
    }

    public static BufferedImage resizeImage(BufferedImage image, int newWidth, int newHeight) {
        Image resized = image.getScaledInstance(newWidth, newHeight, 4);
        return ImageUtil.bufferedImageFromImage(resized);
    }

    public static BufferedImage resizeCanvas(BufferedImage image, int newWidth, int newHeight) {
        BufferedImage dimg = new BufferedImage(newWidth, newHeight, 2);
        int centeredX = newWidth / 2 - image.getWidth() / 2;
        int centeredY = newHeight / 2 - image.getHeight() / 2;
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage((Image)image, centeredX, centeredY, null);
        g2d.dispose();
        return dimg;
    }

    public static BufferedImage rotateImage(BufferedImage image, double theta) {
        AffineTransform transform = new AffineTransform();
        transform.rotate(theta, (double)image.getWidth() / 2.0, (double)image.getHeight() / 2.0);
        AffineTransformOp transformOp = new AffineTransformOp(transform, 2);
        return transformOp.filter(image, null);
    }

    public static BufferedImage flipImage(BufferedImage image, boolean horizontal, boolean vertical) {
        int x = 0;
        int y = 0;
        int w = image.getWidth();
        int h2 = image.getHeight();
        BufferedImage out = new BufferedImage(w, h2, 2);
        Graphics2D g2d = out.createGraphics();
        if (horizontal) {
            x = w;
            w *= -1;
        }
        if (vertical) {
            y = h2;
            h2 *= -1;
        }
        g2d.drawImage(image, x, y, w, h2, null);
        g2d.dispose();
        return out;
    }

    public static BufferedImage outlineImage(BufferedImage image, Color color) {
        return ImageUtil.outlineImage(image, color, ColorUtil::isNotFullyTransparent, false);
    }

    public static BufferedImage outlineImage(BufferedImage image, Color color, Predicate<Color> fillCondition) {
        return ImageUtil.outlineImage(image, color, fillCondition, false);
    }

    public static BufferedImage outlineImage(BufferedImage image, Color color, Boolean outlineCorners) {
        return ImageUtil.outlineImage(image, color, ColorUtil::isNotFullyTransparent, outlineCorners);
    }

    public static BufferedImage outlineImage(BufferedImage image, Color color, Predicate<Color> fillCondition, Boolean outlineCorners) {
        BufferedImage filledImage = ImageUtil.fillImage(image, color, fillCondition);
        BufferedImage outlinedImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2d = outlinedImage.createGraphics();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                if (x == 0 && y == 0 || !outlineCorners.booleanValue() && Math.abs(x) + Math.abs(y) != 1) continue;
                g2d.drawImage((Image)filledImage, x, y, null);
            }
        }
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return outlinedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getResourceStreamFromClass(Class c, String path) {
        try {
            Class<ImageIO> clazz = ImageIO.class;
            synchronized (ImageIO.class) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ImageIO.read(c.getResourceAsStream(path));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(path, e);
        }
        catch (IOException e) {
            throw new RuntimeException(path, e);
        }
    }

    public static BufferedImage fillImage(BufferedImage image, Color color) {
        return ImageUtil.fillImage(image, color, ColorUtil::isNotFullyTransparent);
    }

    static BufferedImage fillImage(BufferedImage image, Color color, Predicate<Color> fillCondition) {
        BufferedImage filledImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        for (int x = 0; x < filledImage.getWidth(); ++x) {
            for (int y = 0; y < filledImage.getHeight(); ++y) {
                Color pixelColor = new Color(image.getRGB(x, y), true);
                if (!fillCondition.test(pixelColor)) continue;
                filledImage.setRGB(x, y, color.getRGB());
            }
        }
        return filledImage;
    }

    private static BufferedImage offset(BufferedImage image, float[] scales, float[] offsets) {
        return new RescaleOp(scales, offsets, null).filter(image, null);
    }

    static {
        ImageIO.setUseCache(false);
    }
}

