/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.necrotic.client.Client;
import org.necrotic.client.EffectTimer;
import org.necrotic.client.cache.definition.ItemDefinition;
import org.necrotic.client.graphics.DrawingArea;
import org.necrotic.client.graphics.Sprite;
import org.necrotic.client.graphics.gameframe.GameFrame;

public class EffectTimers {
    private static List<EffectTimer> timers = new ArrayList<EffectTimer>();

    public static List<EffectTimer> getTimers() {
        return timers;
    }

    public static void add(EffectTimer et) {
        for (EffectTimer timer : timers) {
            if (timer.getItemId() != et.getItemId()) continue;
            timer.setSeconds(et.getSecondsTimer().secondsRemaining());
            timer.setTime(et.getTime());
            return;
        }
        timers.add(et);
    }

    public static void draw() {
        int yDraw;
        int xDraw = GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? Client.clientWidth - 325 : Client.clientWidth - 276;
        int n = yDraw = GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? Client.clientHeight - 210 : Client.clientHeight - 170;
        if (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED && Client.instance.getWidth() >= 1000) {
            yDraw = Client.clientHeight - 48;
        } else if (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED && Client.instance.getWidth() >= 800) {
            yDraw = Client.clientHeight - 86;
        }
        Iterator<EffectTimer> it = timers.iterator();
        while (it.hasNext()) {
            EffectTimer timer = it.next();
            if (timer.getSecondsTimer().finished()) {
                it.remove();
                continue;
            }
            Sprite sprite = ItemDefinition.getSprite(timer.getItemId(), 1, 0, 1.25, true);
            String string = EffectTimers.formatMinutes(timer.getSecondsTimer().secondsRemaining());
            if (sprite == null) continue;
            if (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED) {
                DrawingArea.method338(yDraw - 21, 28, 150, 0, 63, xDraw + 5);
                DrawingArea.method335(4405810, yDraw - 20, 61, 26, 150, xDraw + 6);
                Client.instance.newSmallFont.drawBasicString(string, xDraw + 32, yDraw - 1, 0xFFFFFF, 1);
                sprite.drawSprite1(xDraw + 2, yDraw - 23);
            } else {
                DrawingArea.method338(yDraw - 21, 28, 150, 0, 63, xDraw + 5);
                DrawingArea.method335(4405810, yDraw - 20, 61, 26, 150, xDraw + 6);
                Client.instance.newSmallFont.drawBasicString(string, xDraw + 32, yDraw - 1, 0xFFFFFF, 1);
                sprite.drawSprite(xDraw + 2, yDraw - 23);
            }
            yDraw -= 30;
        }
    }

    private static String formatMinutes(int seconds) {
        int i = (int)((double)(seconds / 60));
        int j = seconds - i * 60;
        String str1 = "" + i;
        String str2 = "" + j;
        if (j < 10) {
            str2 = "0" + str2;
        }
        if (i < 10) {
            str1 = "0" + str1;
        }
        return str1 + ":" + str2;
    }
}

