/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client;

import org.necrotic.client.world.Rasterizer;

public class Fog {
    private static int begin = 2550;
    private static int end = 3400;
    private static int length = end - begin;

    public static void set(int begin, int end) {
        Fog.begin = begin;
        Fog.end = end;
        length = end - begin;
    }

    public static void draw(int rgb, int begin, int end) {
        float length = end - begin;
        for (int i = 0; i < Rasterizer.raster.length; ++i) {
            float factor = (Rasterizer.depthBuffer[i] - (float)begin) / length;
            factor = Math.min(1.0f, Math.max(factor, 0.0f));
            Rasterizer.raster[i] = Fog.blend(Rasterizer.raster[i], rgb, factor);
        }
    }

    private static int blend(int rgb1, int rgb2, float factor) {
        if (factor >= 1.0f) {
            return rgb2;
        }
        if (factor <= 0.0f) {
            return rgb1;
        }
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int r2 = rgb2 >> 16 & 0xFF;
        int g2 = rgb2 >> 8 & 0xFF;
        int b2 = rgb2 & 0xFF;
        int r3 = r2 - r1;
        int g3 = g2 - g1;
        int b3 = b2 - b1;
        int r = (int)((float)r1 + (float)r3 * factor);
        int g4 = (int)((float)g1 + (float)g3 * factor);
        int b = (int)((float)b1 + (float)b3 * factor);
        return (r << 16) + (g4 << 8) + b;
    }
}

