/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client;

import org.necrotic.client.Signlink;
import org.necrotic.client.cache.node.NodeCache;
import org.necrotic.client.cache.node.NodeSub;
import org.necrotic.client.cache.node.NodeSubList;

public final class List {
    private final NodeSub emptyNodeSub = new NodeSub();
    private final int initialCount;
    private int spaceLeft;
    private final NodeCache nodeCache;
    private final NodeSubList nodeSubList = new NodeSubList();

    public List(int size) {
        this.initialCount = size;
        this.spaceLeft = size;
        this.nodeCache = new NodeCache();
    }

    public NodeSub insertFromCache(long l) {
        NodeSub nodeSub = (NodeSub)this.nodeCache.findNodeByID(l);
        if (nodeSub != null) {
            this.nodeSubList.insertHead(nodeSub);
        }
        return nodeSub;
    }

    public void removeFromCache(NodeSub nodeSub, long l) {
        try {
            if (this.spaceLeft == 0) {
                NodeSub nodeSub_1 = this.nodeSubList.popTail();
                nodeSub_1.unlink();
                nodeSub_1.unlinkSub();
                if (nodeSub_1 == this.emptyNodeSub) {
                    NodeSub nodeSub_2 = this.nodeSubList.popTail();
                    nodeSub_2.unlink();
                    nodeSub_2.unlinkSub();
                }
            } else {
                --this.spaceLeft;
            }
            this.nodeCache.removeFromCache(nodeSub, l);
            this.nodeSubList.insertHead(nodeSub);
            return;
        }
        catch (RuntimeException runtimeexception) {
            Signlink.reportError("47547, " + nodeSub + ", " + l + ", " + 2 + ", " + runtimeexception.toString());
            throw new RuntimeException();
        }
    }

    void unlinkAll() {
        NodeSub nodeSub;
        while ((nodeSub = this.nodeSubList.popTail()) != null) {
            nodeSub.unlink();
            nodeSub.unlinkSub();
        }
        this.spaceLeft = this.initialCount;
    }

    public void clear() {
        NodeSub nodeSub;
        while ((nodeSub = this.nodeSubList.popTail()) != null) {
            nodeSub.unlink();
            nodeSub.unlinkSub();
        }
        this.spaceLeft = this.initialCount;
    }
}

