/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.necrotic.client.world.Model;

public class ModelUtil {
    public static Set<Map.Entry<Integer, AtomicInteger>> getModelColors(Model model) {
        TreeMap<Integer, AtomicInteger> weightedColors = new TreeMap<Integer, AtomicInteger>();
        for (int color : model.triangleColors) {
            weightedColors.putIfAbsent(color, new AtomicInteger(0));
            ((AtomicInteger)weightedColors.get(color)).incrementAndGet();
        }
        return weightedColors.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((AtomicInteger)entry.getValue()).get())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static List<Map.Entry<Integer, Integer>> getColors(Model model) {
        HashMap<Integer, Integer> weightedColors = new HashMap<Integer, Integer>();
        for (int color : model.triangleColors) {
            weightedColors.merge(color, 1, Integer::sum);
        }
        return weightedColors.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toList());
    }
}

