/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ReflectionTools {
    public static Class[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/').replaceAll("%20", " ").replaceAll("%e2%84%a2", "\u00ef\u00bf\u00bd");
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> directories = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            directories.add(new File(resources.nextElement().getFile().replaceAll("%20", " ").replaceAll("%e2%84%a2", "\u00ef\u00bf\u00bd")));
        }
        ArrayList classes = new ArrayList();
        for (File directory : directories) {
            classes.addAll(ReflectionTools.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static List<Class<?>> findClasses(File directory, String packageName) {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (!file.getName().endsWith(".class")) continue;
            try {
                classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return classes;
    }

    public static String getName(Object object) {
        return object.getClass().getSimpleName();
    }

    public static String getLowerCaseName(Object object) {
        return ReflectionTools.getName(object).toLowerCase();
    }
}

