/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.Settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.necrotic.Configuration;
import org.necrotic.client.Client;
import org.necrotic.client.RSInterface;
import org.necrotic.client.Signlink;
import org.necrotic.client.constants.GameFrameConstants;
import org.necrotic.client.world.SceneGraph;

public class Load {
    public static void settings(Client client) {
        Path path = Paths.get(Signlink.getSettingsDirectory(), "/settings.json");
        File file = path.toFile();
        if (!file.exists()) {
            return;
        }
        try (FileReader fileReader = new FileReader(file);){
            int i;
            String qp;
            JsonParser fileparser = new JsonParser();
            Gson builder = new GsonBuilder().create();
            JsonObject reader = (JsonObject)fileparser.parse(fileReader);
            if (reader.has("username")) {
                Client.myUsername = reader.get("username").getAsString();
            }
            if (reader.has("password")) {
                Client.instance.password = reader.get("password").getAsString();
            }
            if (reader.has("save-accounts")) {
                Configuration.SAVE_ACCOUNTS = reader.get("save-accounts").getAsBoolean();
            }
            if (reader.has("new-f-keys")) {
                Configuration.NEW_FUNCTION_KEYS = reader.get("new-f-keys").getAsBoolean();
            }
            if (reader.has("new-hp-bars")) {
                Configuration.NEW_HEALTH_BARS = reader.get("new-hp-bars").getAsBoolean();
            }
            if (reader.has("new-hitmark")) {
                Configuration.NEW_HITMARKS = reader.get("new-hitmark").getAsBoolean();
            }
            if (reader.has("constitution")) {
                Configuration.CONSTITUTION_ENABLED = reader.get("constitution").getAsBoolean();
            }
            if (reader.has("new-cursor")) {
                Configuration.NEW_CURSORS = reader.get("new-cursor").getAsBoolean();
            }
            if (reader.has("display-hp-above-head")) {
                Configuration.DISPLAY_HP_ABOVE_HEAD = reader.get("display-hp-above-head").getAsBoolean();
            }
            if (reader.has("display-username-above-head")) {
                Configuration.DISPLAY_USERNAMES_ABOVE_HEAD = reader.get("display-username-above-head").getAsBoolean();
            }
            if (reader.has("gameframe")) {
                GameFrameConstants.GameFrameType gameFrameType = GameFrameConstants.gameframeType = reader.get("gameframe").getAsBoolean() ? GameFrameConstants.GameFrameType.FRAME_554 : GameFrameConstants.GameFrameType.FRAME_554;
            }
            if (reader.has("fog-enabled")) {
                Configuration.FOG_ENABLED = reader.get("fog-enabled").getAsBoolean();
            }
            if (reader.has("highlight-username")) {
                Configuration.HIGHLIGHT_USERNAME = reader.get("highlight-username").getAsBoolean();
            }
            if (reader.has("high-detail")) {
                if (reader.get("high-detail").getAsBoolean()) {
                    Client.setHighDetail();
                } else {
                    Client.setLowDetail();
                }
            }
            if (reader.has("split-chat-color")) {
                client.splitChatColor = reader.get("split-chat-color").getAsInt();
            }
            if (reader.has("clan-chat-color")) {
                client.splitChatColor = reader.get("clan-chat-color").getAsInt();
            }
            if (reader.has("split-chat")) {
                client.variousSettings[502] = client.variousSettings[287] = reader.get("split-chat").getAsInt();
                Client.instance.updateConfig(287);
            }
            if (reader.has("ground-text")) {
                Configuration.GROUND_TEXT = reader.get("ground-text").getAsBoolean();
            }
            if (reader.has("quick-prayers")) {
                qp = reader.get("quick-prayers").getAsString();
                for (i = 0; i < qp.length(); ++i) {
                    client.quickPrayers[i] = Integer.parseInt(qp.substring(i, i + 1));
                }
            }
            if (reader.has("quick-curses")) {
                qp = reader.get("quick-curses").getAsString();
                for (i = 0; i < qp.length(); ++i) {
                    client.quickCurses[i] = Integer.parseInt(qp.substring(i, i + 1));
                }
                if (reader.has("fog-color")) {
                    Client.instance.lastFogColor = Client.instance.fogColor = reader.get("fog-color").getAsInt();
                    RSInterface.interfaceCache[93002].rgbPicker.setPickedColor(Client.instance.fogColor);
                }
                if (reader.has("draw-distance")) {
                    SceneGraph.setDrawDistance(reader.get("draw-distance").getAsInt());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

