/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client;

import org.necrotic.Configuration;
import org.necrotic.client.Client;
import org.necrotic.client.graphics.DrawingArea;

public class StatusBars {
    private static int calculateHPColor(int percentage) {
        int[] colorArray = new int[]{0xFF0000, 0xE60000, 0xCC0000, 0xB30000, 0x990000, 0x800000, 0x660000, 0x4D0000, 0x330000, 0x1A0000};
        int color = colorArray[0];
        for (int i = 0; i < colorArray.length; ++i) {
            if (percentage < 100 - i * 10) continue;
            color = colorArray[i];
            break;
        }
        return color;
    }

    private static int calculatePrayerColor(int percentage) {
        int[] colorArray = new int[]{65535, 61680, 57825, 53970, 50115, 46260, 38293, 30326, 22359, 14392};
        int color = colorArray[0];
        for (int i = 0; i < colorArray.length; ++i) {
            if (percentage < 100 - i * 10) continue;
            color = colorArray[i];
            break;
        }
        return color;
    }

    private static int getHitpointsIconSpriteId() {
        return 330;
    }

    private static int getHealthBarColor() {
        return 0x910000;
    }

    private static int getPrayerBarColor() {
        if (Client.instance.mapArea.prayer.getOrbState()) {
            return 37241;
        }
        return 37241;
    }

    private static int getBarHeight() {
        if (!Client.instance.isInResizeable()) {
            return 250;
        }
        return 271;
    }

    private static int getPercent(int current, int pixels) {
        return (int)((double)pixels * 0.01 * (double)current);
    }

    public static void drawStatusBars(int xOffset, int yOffset) {
        if (Client.instance.isInResizeable()) {
            StatusBars.renderStatusBars(xOffset + 32, yOffset + 140, "hp");
            StatusBars.renderStatusBars(xOffset + 26, yOffset + 140, "prayer");
            return;
        }
        if (Client.instance.isInFullscreen()) {
            StatusBars.renderStatusBars(xOffset + 1900, yOffset + 320, "hp");
            StatusBars.renderStatusBars(xOffset + 1800, yOffset + 320, "prayer");
            return;
        }
        StatusBars.renderStatusBars(xOffset, yOffset, "hp");
        StatusBars.renderStatusBars(xOffset, yOffset, "prayer");
    }

    private static void renderStatusBars(int xOffset, int yOffset, String type) {
        if (Configuration.DISPLAY_STATUS_BARS) {
            int currentHp = Client.instance.currentStats[3] / 10;
            if (Configuration.CONSTITUTION_ENABLED) {
                currentHp *= 10;
            }
            int currentPrayer = Client.instance.currentStats[5] / 10;
            int percent = StatusBars.getPercent(StatusBars.getPercent(type), StatusBars.getBarHeight());
            int space = StatusBars.getBarHeight() - StatusBars.getPercent(StatusBars.getPercent(type), StatusBars.getBarHeight()) - 1;
            int colour = type.equals("hp") ? StatusBars.calculateHPColor(percent) : StatusBars.calculatePrayerColor(percent);
            DrawingArea.fillRectangle(0, yOffset + 43 + StatusBars.getBarOffsetY(), 20, space, 125, (xOffset -= 4) + 14 + StatusBars.getBarOffsetX(type));
            DrawingArea.fillRectangle(colour, StatusBars.getBarHeight() - 8 - percent + 50 + yOffset + StatusBars.getBarOffsetY(), 18, percent, 180, xOffset + 15 + StatusBars.getBarOffsetX(type));
            DrawingArea.fillPixels(xOffset + 14 + StatusBars.getBarOffsetX(type), 20, StatusBars.getBarHeight(), 0, 42 + yOffset + StatusBars.getBarOffsetY());
            Client.spritesMap.get(type.equals("hp") ? StatusBars.getHitpointsIconSpriteId() : 105).drawAdvancedSprite(xOffset + 2 + (type.equals("hp") ? 14 : 13) + StatusBars.getBarOffsetX(type), 47 + yOffset + StatusBars.getBarOffsetY());
            Client.instance.newSmallFont.drawCenteredString(type.equals("hp") ? String.valueOf(currentHp) : String.valueOf(currentPrayer), xOffset + 24 + StatusBars.getBarOffsetX(type), 77 + yOffset + StatusBars.getBarOffsetY(), 0xFFFFFF, 1);
        }
    }

    private static int getPercent(String type) {
        if (type.equals("hp")) {
            int level = Client.instance.currentStats[3] / 10;
            int max = Client.instance.maxStats[3] / 10;
            double percent = (double)level / (double)max;
            return level > max ? 100 : (int)(percent * 100.0);
        }
        if (type.equals("prayer")) {
            int level = Client.instance.currentStats[5] / 10;
            int max = Client.instance.maxStats[5] / 10;
            double percent = (double)level / (double)max;
            return level > max ? 100 : (int)(percent * 100.0);
        }
        return 0;
    }

    private static int getBarOffsetX(String type) {
        if (type.equals("hp")) {
            if (Client.instance.isInResizeable()) {
                return -40;
            }
            if (Client.instance.isInFullscreen()) {
                return -20;
            }
            return 0;
        }
        if (!type.equals("prayer")) {
            return 0;
        }
        if (Client.instance.isInResizeable()) {
            return -12;
        }
        if (Client.instance.isInFullscreen()) {
            return 55;
        }
        return 210;
    }

    private static int getBarOffsetY() {
        if (Client.instance.isInResizeable()) {
            return -55;
        }
        return 0;
    }
}

