/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.cache;

import org.necrotic.client.bzip.BZIPDecompressor;
import org.necrotic.client.io.ByteBuffer;

public final class Archive {
    private final byte[] payload;
    private final int[] anIntArray730;
    private final int[] indiceTable;
    private final int dataSize;
    private final int[] hashTable;
    private final boolean isCompressed;
    private final int[] sizeTable;

    public Archive(byte[] data) {
        ByteBuffer buffer = new ByteBuffer(data);
        int decompressed = buffer.getTribyte();
        int compressed = buffer.getTribyte();
        boolean bl = this.isCompressed = decompressed != compressed;
        if (this.isCompressed) {
            byte[] tmp = new byte[decompressed];
            BZIPDecompressor.decompress(tmp, decompressed, data, compressed, 6);
            this.payload = tmp;
            buffer = new ByteBuffer(this.payload);
        } else {
            this.payload = data;
        }
        this.dataSize = buffer.getUnsignedShort();
        this.hashTable = new int[this.dataSize];
        this.sizeTable = new int[this.dataSize];
        this.anIntArray730 = new int[this.dataSize];
        this.indiceTable = new int[this.dataSize];
        int position = buffer.position + this.dataSize * 10;
        for (int i = 0; i < this.dataSize; ++i) {
            this.hashTable[i] = buffer.getIntLittleEndian();
            this.sizeTable[i] = buffer.getTribyte();
            this.anIntArray730[i] = buffer.getTribyte();
            this.indiceTable[i] = position;
            position += this.anIntArray730[i];
        }
    }

    public byte[] get(String name) {
        byte[] data = null;
        int hash = this.getHash(name);
        for (int i = 0; i < this.dataSize; ++i) {
            if (this.hashTable[i] != hash) continue;
            if (data == null) {
                data = new byte[this.sizeTable[i]];
            }
            if (!this.isCompressed) {
                BZIPDecompressor.decompress(data, this.sizeTable[i], this.payload, this.anIntArray730[i], this.indiceTable[i]);
            } else {
                System.arraycopy(this.payload, this.indiceTable[i], data, 0, this.sizeTable[i]);
            }
            return data;
        }
        return null;
    }

    private int getHash(String name) {
        int hash = 0;
        name = name.toUpperCase();
        for (int i = 0; i < name.length(); ++i) {
            hash = hash * 61 + name.charAt(i) - 32;
        }
        return hash;
    }
}

