/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.cache.definition;

import org.necrotic.client.cache.Archive;
import org.necrotic.client.io.ByteBuffer;

public class FloorDefinitions {
    public static FloorDefinitions[] underlays;
    public static FloorDefinitions[] overlays;
    public int textureId = -1;
    public boolean shadowing = true;
    public int chroma;
    public int color;
    public static int biggestTextureId;
    public int texture = -1;
    public int rgb;
    public boolean occlude;
    public int anotherRgb;
    public int hue;
    public int saturation;
    public int luminance;
    public int blendHue;
    public int blendHueMultiplier;
    public int hsl16;
    public int anotherHue;
    public int anotherSaturation;
    public int anotherLuminance;

    private FloorDefinitions() {
    }

    public static void unpackUnderlays(Archive streamLoader) {
        ByteBuffer stream = new ByteBuffer(streamLoader.get("flo.dat"));
        int cacheSize = stream.getUnsignedShort();
        if (underlays == null) {
            underlays = new FloorDefinitions[cacheSize];
        }
        for (int j = 0; j < cacheSize; ++j) {
            if (underlays[j] == null) {
                FloorDefinitions.underlays[j] = new FloorDefinitions();
            }
            underlays[j].decode(stream);
        }
    }

    public static void unpackOverlays(Archive stream) {
        java.nio.ByteBuffer oldBuffer = java.nio.ByteBuffer.wrap(stream.get("flo2.dat"));
        int oldOverlayAmount = oldBuffer.getShort();
        overlays = new FloorDefinitions[oldOverlayAmount];
        for (int i = 0; i < oldOverlayAmount; ++i) {
            if (overlays[i] == null) {
                FloorDefinitions.overlays[i] = new FloorDefinitions();
            }
            overlays[i].readOldValues(oldBuffer);
            overlays[i].generateHsl();
        }
    }

    private void readOldValues(java.nio.ByteBuffer oldBuffer) {
        byte opcode;
        while ((opcode = oldBuffer.get()) != 0) {
            int n;
            if (opcode == 1) {
                this.rgb = ((oldBuffer.get() & 0xFF) << 16) + ((oldBuffer.get() & 0xFF) << 8) + (oldBuffer.get() & 0xFF);
                continue;
            }
            if (opcode == 2) {
                this.texture = oldBuffer.get() & 0xFF;
                continue;
            }
            if (opcode == 3) {
                this.texture = oldBuffer.getShort() & 0xFFFF;
                if (this.texture != 65535) continue;
                this.texture = -1;
                continue;
            }
            if (opcode == 4) continue;
            if (opcode == 5) {
                n = 0;
                continue;
            }
            if (opcode == 6) continue;
            if (opcode == 7) {
                n = ((oldBuffer.get() & 0xFF) << 16) + ((oldBuffer.get() & 0xFF) << 8) + (oldBuffer.get() & 0xFF);
                continue;
            }
            if (opcode == 8) continue;
            if (opcode == 9) {
                n = oldBuffer.getShort() & 0xFFFF;
                continue;
            }
            if (opcode == 10) {
                n = 0;
                continue;
            }
            if (opcode == 11) {
                n = oldBuffer.get() & 0xFF;
                continue;
            }
            if (opcode == 12) {
                n = 1;
                continue;
            }
            if (opcode == 13) {
                n = ((oldBuffer.get() & 0xFF) << 16) + ((oldBuffer.get() & 0xFF) << 8) + (oldBuffer.get() & 0xFF);
                continue;
            }
            if (opcode == 14) {
                n = oldBuffer.get() & 0xFF;
                continue;
            }
            if (opcode == 15) {
                int int_15 = oldBuffer.getShort() & 0xFFFF;
                if (int_15 != 65535) continue;
                n = -1;
                continue;
            }
            if (opcode == 16) {
                n = oldBuffer.get() & 0xFF;
                continue;
            }
            System.err.println("[FloorOverlay] Missing AttributeId: " + opcode);
        }
    }

    private void decode(ByteBuffer stream) {
        int opcode;
        while ((opcode = stream.getUnsignedByte()) != 0) {
            if (opcode == 1) {
                this.rgb = stream.getTribyte();
                this.blend(this.rgb);
                continue;
            }
            if (opcode == 2) {
                this.textureId = stream.getUnsignedByte();
                continue;
            }
            if (opcode == 3) continue;
            if (opcode == 5) {
                this.shadowing = false;
                continue;
            }
            if (opcode == 6) {
                stream.getString();
                continue;
            }
            if (opcode == 7) {
                int hue = this.hue;
                int saturation = this.saturation;
                int luminance = this.luminance;
                int i1 = this.blendHue;
                int minimapRGB = stream.getTribyte();
                this.blend(minimapRGB);
                this.hue = hue;
                this.saturation = saturation;
                this.luminance = luminance;
                this.blendHue = i1;
                this.chroma = i1;
                continue;
            }
            System.out.println("Error unrecognised floor underlay config code: " + opcode);
        }
        return;
    }

    private void blend(int color) {
        double brightness;
        double r = (double)(color >> 16 & 0xFF) / 256.0;
        double g2 = (double)(color >> 8 & 0xFF) / 256.0;
        double b = (double)(color & 0xFF) / 256.0;
        double darkness = r;
        if (g2 < darkness) {
            darkness = g2;
        }
        if (b < darkness) {
            darkness = b;
        }
        if (g2 > (brightness = r)) {
            brightness = g2;
        }
        if (b > brightness) {
            brightness = b;
        }
        double hue = 0.0;
        double saturation = 0.0;
        double luminance = (darkness + brightness) / 2.0;
        if (darkness != brightness) {
            if (luminance < 0.5) {
                saturation = (brightness - darkness) / (brightness + darkness);
            }
            if (luminance >= 0.5) {
                saturation = (brightness - darkness) / (2.0 - brightness - darkness);
            }
            if (r == brightness) {
                hue = (g2 - b) / (brightness - darkness);
            } else if (g2 == brightness) {
                hue = 2.0 + (b - r) / (brightness - darkness);
            } else if (b == brightness) {
                hue = 4.0 + (r - g2) / (brightness - darkness);
            }
        }
        this.hue = (int)((hue /= 6.0) * 256.0);
        this.saturation = (int)(saturation * 256.0);
        this.luminance = (int)(luminance * 256.0);
        if (this.saturation < 0) {
            this.saturation = 0;
        } else if (this.saturation > 255) {
            this.saturation = 255;
        }
        if (this.luminance < 0) {
            this.luminance = 0;
        } else if (this.luminance > 255) {
            this.luminance = 255;
        }
        this.chroma = luminance > 0.5 ? (int)((1.0 - luminance) * saturation * 512.0) : (int)(luminance * saturation * 512.0);
        if (this.chroma < 1) {
            this.chroma = 1;
        }
        this.blendHue = (int)(hue * (double)this.chroma);
        this.color = FloorDefinitions.encode(this.hue, this.saturation, this.luminance);
    }

    public static int encode(int hue, int saturation, int lightness) {
        if (lightness > 179) {
            saturation >>= 1;
        } else if (lightness > 192) {
            saturation >>= 2;
        } else if (lightness > 217) {
            saturation >>= 3;
        } else if (lightness > 243) {
            saturation >>= 4;
        }
        return ((hue >> 2 & 0x3F) << 10) + (saturation >> 5 << 7) + (lightness >> 1);
    }

    private void generateHsl() {
        if (this.anotherRgb != -1) {
            this.rgbToHsl(this.anotherRgb);
            this.anotherHue = this.hue;
            this.anotherSaturation = this.saturation;
            this.anotherLuminance = this.luminance;
        }
        this.rgbToHsl(this.rgb);
    }

    private void rgbToHsl(int rgb) {
        double max;
        double r = (double)(rgb >> 16 & 0xFF) / 256.0;
        double g2 = (double)(rgb >> 8 & 0xFF) / 256.0;
        double b = (double)(rgb & 0xFF) / 256.0;
        double min2 = r;
        if (g2 < min2) {
            min2 = g2;
        }
        if (b < min2) {
            min2 = b;
        }
        if (g2 > (max = r)) {
            max = g2;
        }
        if (b > max) {
            max = b;
        }
        double h2 = 0.0;
        double s2 = 0.0;
        double l = (min2 + max) / 2.0;
        if (min2 != max) {
            if (l < 0.5) {
                s2 = (max - min2) / (max + min2);
            }
            if (l >= 0.5) {
                s2 = (max - min2) / (2.0 - max - min2);
            }
            if (r == max) {
                h2 = (g2 - b) / (max - min2);
            } else if (g2 == max) {
                h2 = 2.0 + (b - r) / (max - min2);
            } else if (b == max) {
                h2 = 4.0 + (r - g2) / (max - min2);
            }
        }
        this.hue = (int)((h2 /= 6.0) * 256.0);
        this.saturation = (int)(s2 * 256.0);
        this.luminance = (int)(l * 256.0);
        if (this.saturation < 0) {
            this.saturation = 0;
        } else if (this.saturation > 255) {
            this.saturation = 255;
        }
        if (this.luminance < 0) {
            this.luminance = 0;
        } else if (this.luminance > 255) {
            this.luminance = 255;
        }
        this.blendHueMultiplier = l > 0.5 ? (int)((1.0 - l) * s2 * 512.0) : (int)(l * s2 * 512.0);
        if (this.blendHueMultiplier < 1) {
            this.blendHueMultiplier = 1;
        }
        this.blendHue = (int)(h2 * (double)this.blendHueMultiplier);
        this.hsl16 = FloorDefinitions.hsl24to16(this.hue, this.saturation, this.luminance);
    }

    public static int hsl24to16(int h2, int s2, int l) {
        if (l > 179) {
            s2 /= 2;
        }
        if (l > 192) {
            s2 /= 2;
        }
        if (l > 217) {
            s2 /= 2;
        }
        if (l > 243) {
            s2 /= 2;
        }
        return (h2 / 4 << 10) + (s2 / 32 << 7) + l / 2;
    }
}

