/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.graphics;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public enum AnimatedPlayerName {
    OWNER(8, new int[]{327680, 655360, 983040, 0x140000, 0x1A0000, 0x1F0000, 0x240000, 0x290000, 0x2E0000, 0x330000, 0x380000, 0x3D0000, 0x420000, 0x470000, 0x4D0000, 0x520000, 0x570000, 0x5C0000, 0x610000, 0x660000, 0x6B0000, 0x700000, 0x750000, 0x7A0000, 0x800000, 0x850000, 0x8A0000, 0x8F0000, 0x940000, 0x990000, 0x9E0000, 0xA30000, 0xA80000, 0xAD0000, 0xB30000, 0xB80000, 0xBD0000, 0xC20000, 0xC70000, 0xCC0000, 0xD10000, 0xD60000, 0xDB0000, 0xE00000, 0xE60000, 0xEB0000, 0xF00000, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 16760320, 0xF50000, 0xF00000, 0xEB0000, 0xE60000, 0xE00000, 0xDB0000, 0xD60000, 0xD10000, 0xCC0000, 0xC70000, 0xC20000, 0xBD0000, 0xB80000, 0xB30000, 0xAD0000, 0xA80000, 0xA30000, 0x9E0000, 0x990000, 0x940000, 0x8F0000, 0x8A0000, 0x850000, 0x800000, 0x7A0000, 0x750000, 0x700000, 0x6B0000, 0x660000, 0x610000, 0x5C0000, 0x570000, 0x520000, 0x4D0000, 0x470000, 0x420000, 0x3D0000, 0x380000, 0x330000, 0x2E0000, 0x290000, 0x240000, 0x1F0000, 0x1A0000, 0x140000, 983040, 655360, 327680}),
    BRONZE(1, new int[]{66816, 133632, 200448, 267264, 334336, 401152, 467968, 534784, 601600, 668416, 735232, 802048, 868864, 935680, 1002752, 1069568, 1136384, 1203200, 4914975, 5177124, 5439273, 5701422, 5963571, 6225720, 6487869, 6750018, 7012167, 7274317, 7536466, 7798615, 8060764, 8322913, 8060764, 7798615, 7536466, 7274317, 7012167, 6750018, 6487869, 6225720, 5963571, 5701422, 5439273, 5177124, 4914975, 4652826, 4390676, 4128527, 3866378, 3604229, 3342080, 3275264, 3208448, 0x2FF000, 3074816, 3008000, 2940928, 2874112, 2807296, 2740480, 2673664, 2606848, 2540032, 2473216, 2406400, 2272512, 2205696, 2138880, 2072064, 2005248, 1938432, 1871616, 1804800, 1737984, 1671168, 1604096, 1537280, 1470464, 1403648, 1336832, 1270016, 1203200, 1136384, 1069568, 1002752, 935680, 868864, 802048, 735232, 668416, 601600, 534784, 467968, 401152, 334336, 267264, 200448, 133632, 66816}),
    SILVER(2, new int[]{1270016, 1336832, 1403648, 1470464, 1537280, 1604096, 1671168, 1737984, 1804800, 1871616, 1938432, 2005248, 2072064, 2138880, 2205696, 2272512, 2406400, 2473216, 2540032, 2606848, 2673664, 2740480, 2807296, 2874112, 2940928, 3008000, 3074816, 0x2FF000, 3208448, 3275264, 3342080, 3604229, 3866378, 4128527, 4390676, 4652826, 8322913, 6487869, 6225720, 5963571, 5701422, 5439273, 5177124, 4914975, 4652826, 4390676, 4128527, 3866378, 3604229, 3342080, 3275264, 3208448, 0x2FF000, 3074816, 3008000, 2940928, 2874112, 2807296, 2740480, 2673664, 2606848, 2540032, 2473216, 2406400, 2272512, 2205696, 2138880, 2072064, 2005248, 1938432, 1871616, 1804800, 1737984, 1671168, 1604096, 1537280, 1470464, 1403648, 1336832, 1270016, 1203200, 1136384, 1069568, 1002752, 935680, 868864, 802048, 735232, 668416, 601600, 534784, 467968, 401152, 334336, 267264, 200448, 133632, 66816}),
    GOLD(3, new int[]{1270016, 1336832, 1403648, 1470464, 1537280, 1604096, 1671168, 1737984, 1804800, 1871616, 1938432, 2005248, 2072064, 2138880, 2205696, 2272512, 2406400, 2473216, 2540032, 2606848, 2673664, 2740480, 2807296, 2874112, 2940928, 3008000, 3074816, 0x2FF000, 3208448, 3275264, 3342080, 3604229, 3866378, 4128527, 4390676, 4652826, 8322913, 6487869, 6225720, 5963571, 5701422, 5439273, 5177124, 4914975, 4652826, 4390676, 4128527, 3866378, 3604229, 3342080, 3275264, 3208448, 0x2FF000, 3074816, 3008000, 1671168, 1604096, 1537280, 1470464, 1403648, 1336832, 1270016, 1203200, 1136384, 1069568, 1002752, 935680, 868864, 802048, 735232, 668416, 601600, 534784, 467968, 401152, 334336, 267264, 200448, 133632, 66816});

    private static final int DELAY = 4;
    private final int[] colors;
    private final int rank;
    private int index;
    private int currentColor;
    private static final List<AnimatedPlayerName> ANIMATED_PLAYER_NAMES;

    private AnimatedPlayerName(int rank, int[] colors) {
        this.rank = rank;
        this.colors = colors;
    }

    public void changeColor() {
        this.currentColor = this.colors[this.index];
        ++this.index;
        if (this.index == this.colors.length) {
            this.index = 0;
        }
    }

    public static void animateAll() {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.scheduleAtFixedRate(() -> ANIMATED_PLAYER_NAMES.forEach(AnimatedPlayerName::changeColor), 0L, 4L, TimeUnit.MILLISECONDS);
    }

    public static int getCurrentColorByRank(int rank) {
        Optional<AnimatedPlayerName> possibleAn = ANIMATED_PLAYER_NAMES.stream().filter(animatedPlayerName -> animatedPlayerName.rank == rank).findAny();
        return possibleAn.map(animatedPlayerName -> animatedPlayerName.currentColor).orElse(0);
    }

    static {
        ANIMATED_PLAYER_NAMES = Arrays.asList(AnimatedPlayerName.values());
    }
}

