/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.graphics;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.util.Arrays;
import java.util.Hashtable;
import org.necrotic.Configuration;
import org.necrotic.client.MathUtils;
import org.necrotic.client.cache.node.NodeSub;
import org.necrotic.client.world.Rasterizer;

public class DrawingArea
extends NodeSub {
    public static float[] depthBuffer;
    public static int[] raster;
    public static int width;
    public static int height;
    public static int clipTop;
    public static int clipBottom;
    public static int clipLeft;
    public static int clipRight;
    public static int maxRight;
    public static int centerY;
    public static int middleY;
    private static final ColorModel COLOR_MODEL;

    public static void drawStroke(int xPos, int yPos, int width, int height, int color, int strokeWidth) {
        DrawingArea.drawVerticalStrokeLine(xPos, yPos, height, color, strokeWidth);
        DrawingArea.drawVerticalStrokeLine(xPos + width - strokeWidth, yPos, height, color, strokeWidth);
        DrawingArea.drawHorizontalStrokeLine(xPos, yPos, width, color, strokeWidth);
        DrawingArea.drawHorizontalStrokeLine(xPos, yPos + height - strokeWidth, width, color, strokeWidth);
    }

    public static void clear() {
        Arrays.fill(raster, 0);
    }

    private static void drawVerticalStrokeLine(int xPosition, int yPosition, int height, int hexColor, int strokeWidth) {
        if (xPosition < clipLeft || xPosition >= clipRight) {
            return;
        }
        if (yPosition < clipTop) {
            height -= clipTop - yPosition;
            yPosition = clipTop;
        }
        if (yPosition + height > clipBottom) {
            height = clipBottom - yPosition;
        }
        int pixelIndex = xPosition + yPosition * width;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            for (int x = 0; x < strokeWidth; ++x) {
                DrawingArea.raster[pixelIndex + x + rowIndex * DrawingArea.width] = hexColor;
            }
        }
    }

    public static void drawColorPicker(int x, int y, int w, int h2, int hueWidth, float hue) {
        if (x < clipLeft) {
            w -= clipLeft - x;
            x = clipLeft;
        }
        if (y < clipTop) {
            h2 -= clipTop - y;
            y = clipTop;
        }
        if (x + w > clipRight) {
            w = clipRight - x;
        }
        if (y + h2 > clipBottom) {
            h2 = clipBottom - y;
        }
        DrawingArea.createSB(x, y, w, h2, hue);
        DrawingArea.createHueRGB(x + w, y, hueWidth, h2);
        DrawingArea.drawStroke(x, y, w + hueWidth, h2, 0, 1);
    }

    private static void createHueRGB(int x, int y, int hueWidth, int hueHeight) {
        for (int pX = x; pX < x + hueWidth; ++pX) {
            for (int pY = y; pY < y + hueHeight; ++pY) {
                float hue = MathUtils.map(pY, y, y + hueHeight, 1.0f, 0.0f);
                DrawingArea.raster[pX + pY * DrawingArea.width] = Color.HSBtoRGB(hue, 1.0f, 1.0f);
            }
        }
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g2 = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g2 = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h2 = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h2 - (float)Math.floor(h2);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h2) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g2 = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g2 = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g2 = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g2 = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g2 = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g2 = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return (r << 16) + (g2 << 8) + b;
    }

    private static void createSB(int x, int y, int pickerWidth, int pickerHeight, float hue) {
        for (int pX = x; pX < x + pickerWidth; ++pX) {
            for (int pY = y; pY < y + pickerHeight; ++pY) {
                float saturation = MathUtils.map(pX, x, x + pickerWidth, 0.0f, 1.0f);
                float brightness = MathUtils.map(pY, y, y + pickerHeight, 1.0f, 0.0f);
                DrawingArea.raster[pX + pY * DrawingArea.width] = Color.HSBtoRGB(hue, saturation, brightness);
            }
        }
    }

    public static void drawCircle(double x, double y, double width, double height, int color, int alpha, boolean fill) {
        if (x < (double)clipLeft) {
            width -= (double)clipLeft - x;
            x = clipLeft;
        }
        if (y < (double)clipTop) {
            height -= (double)clipTop - y;
            y = clipTop;
        }
        if (x + width > (double)clipRight) {
            width = (double)clipRight - x;
        }
        if (y + height > (double)clipBottom) {
            height = (double)clipBottom - y;
        }
        Graphics2D graphics = DrawingArea.createGraphics(raster, DrawingArea.width, DrawingArea.height);
        Color CONVERTED_COLOR = new Color(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, alpha);
        graphics.setColor(CONVERTED_COLOR);
        RenderingHints render = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        render.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics.setRenderingHints(render);
        graphics.setComposite(AlphaComposite.getInstance(3, 1.0f));
        Ellipse2D.Double ellipse = new Ellipse2D.Double(x, y, width, height);
        if (fill) {
            graphics.fill(ellipse);
        }
        graphics.draw(ellipse);
    }

    private static void drawHorizontalStrokeLine(int xPos, int yPos, int w, int hexColor, int strokeWidth) {
        if (yPos < clipTop || yPos >= clipBottom) {
            return;
        }
        if (xPos < clipLeft) {
            w -= clipLeft - xPos;
            xPos = clipLeft;
        }
        if (xPos + w > clipRight) {
            w = clipRight - xPos;
        }
        int index = xPos + yPos * width;
        int leftWidth = width - w;
        for (int x = 0; x < strokeWidth; ++x) {
            for (int y = 0; y < w; ++y) {
                DrawingArea.raster[index++] = hexColor;
            }
            index += leftWidth;
        }
    }

    public static void drawAlphaFilledPixels(int xPos, int yPos, int pixelWidth, int pixelHeight, int color, int alpha) {
        if (xPos < clipLeft) {
            pixelWidth -= clipLeft - xPos;
            xPos = clipLeft;
        }
        if (yPos < clipTop) {
            pixelHeight -= clipTop - yPos;
            yPos = clipTop;
        }
        if (xPos + pixelWidth > clipRight) {
            pixelWidth = clipRight - xPos;
        }
        if (yPos + pixelHeight > clipBottom) {
            pixelHeight = clipBottom - yPos;
        }
        color = ((color & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((color & 0xFF00) * alpha >> 8 & 0xFF00);
        int k1 = 256 - alpha;
        int l1 = width - pixelWidth;
        int i2 = xPos + yPos * width;
        for (int j2 = 0; j2 < pixelHeight; ++j2) {
            for (int k2 = -pixelWidth; k2 < 0; ++k2) {
                int l2 = raster[i2];
                l2 = ((l2 & 0xFF00FF) * k1 >> 8 & 0xFF00FF) + ((l2 & 0xFF00) * k1 >> 8 & 0xFF00);
                DrawingArea.raster[i2++] = color + l2;
            }
            i2 += l1;
        }
    }

    public static void fillCircle(int x, int y, int depth, int radius, int color, int alpha) {
        int y2;
        int y1 = y - radius;
        if (y1 < 0) {
            y1 = 0;
        }
        if ((y2 = y + radius) >= height) {
            y2 = height - 1;
        }
        int a2 = 256 - alpha;
        int r1 = (color >> 16 & 0xFF) * alpha;
        int g1 = (color >> 8 & 0xFF) * alpha;
        int b1 = (color & 0xFF) * alpha;
        for (int iy = y1; iy <= y2; ++iy) {
            int pos;
            int x2;
            int dy = iy - y;
            int dist = (int)Math.sqrt(radius * radius - dy * dy);
            int x1 = x - dist;
            if (x1 < 0) {
                x1 = 0;
            }
            if ((x2 = x + dist) >= width) {
                x2 = width - 1;
            }
            if ((pos = x1 + iy * width) > Rasterizer.depthBuffer.length - 1) {
                pos = Rasterizer.depthBuffer.length - 1;
            }
            if (!(Rasterizer.depthBuffer[pos] >= (float)(depth - radius - 15))) {
                int n = pos++;
                if (!(Rasterizer.depthBuffer[n] >= (float)(depth + radius + 15))) continue;
            }
            for (int ix = x1; ix <= x2; ++ix) {
                int r2 = (raster[pos] >> 16 & 0xFF) * a2;
                int g2 = (raster[pos] >> 8 & 0xFF) * a2;
                int b2 = (raster[pos] & 0xFF) * a2;
                DrawingArea.raster[pos++] = (r1 + r2 >> 8 << 16) + (g1 + g2 >> 8 << 8) + (b1 + b2 >> 8);
            }
        }
    }

    public static void drawLine(int yPos, int color, int widthToDraw, int xPos) {
        if (yPos < clipTop || yPos >= clipBottom) {
            return;
        }
        if (xPos < clipLeft) {
            widthToDraw -= clipLeft - xPos;
            xPos = clipLeft;
        }
        if (xPos + widthToDraw > clipRight) {
            widthToDraw = clipRight - xPos;
        }
        int base = xPos + yPos * width;
        for (int ptr = 0; ptr < widthToDraw; ++ptr) {
            DrawingArea.raster[base + ptr] = color;
        }
    }

    public static void setDrawingArea(int yBottom, int xTop, int xBottom, int yTop) {
        if (xTop < 0) {
            xTop = 0;
        }
        if (yTop < 0) {
            yTop = 0;
        }
        if (xBottom > width) {
            xBottom = width;
        }
        if (yBottom > height) {
            yBottom = height;
        }
        clipLeft = xTop;
        clipTop = yTop;
        clipRight = xBottom;
        clipBottom = yBottom;
    }

    public static void transparentBox(int i, int j, int k, int l, int i1, int opac) {
        int j3 = 256 - opac;
        if (k < clipLeft) {
            i1 -= clipLeft - k;
            k = clipLeft;
        }
        if (j < clipTop) {
            i -= clipTop - j;
            j = clipTop;
        }
        if (k + i1 > clipRight) {
            i1 = clipRight - k;
        }
        if (j + i > clipBottom) {
            i = clipBottom - j;
        }
        int k1 = width - i1;
        int l1 = k + j * width;
        for (int i2 = -i; i2 < 0; ++i2) {
            for (int j2 = -i1; j2 < 0; ++j2) {
                int i3 = raster[l1];
                DrawingArea.raster[l1++] = ((l & 0xFF00FF) * opac + (i3 & 0xFF00FF) * j3 & 0xFF00FF00) + ((l & 0xFF00) * opac + (i3 & 0xFF00) * j3 & 0xFF0000) >> 8;
            }
            l1 += k1;
        }
    }

    public static void transparentBox(int i, int j, int k, int l, int i1, int j1, int opac) {
        int j3 = 256 - opac;
        if (k < clipLeft) {
            i1 -= clipLeft - k;
            k = clipLeft;
        }
        if (j < clipTop) {
            i -= clipTop - j;
            j = clipTop;
        }
        if (k + i1 > clipRight) {
            i1 = clipRight - k;
        }
        if (j + i > clipBottom) {
            i = clipBottom - j;
        }
        int k1 = width - i1;
        int l1 = k + j * width;
        for (int i2 = -i; i2 < 0; ++i2) {
            for (int j2 = -i1; j2 < 0; ++j2) {
                int i3 = raster[l1];
                DrawingArea.raster[l1++] = ((l & 0xFF00FF) * opac + (i3 & 0xFF00FF) * j3 & 0xFF00FF00) + ((l & 0xFF00) * opac + (i3 & 0xFF00) * j3 & 0xFF0000) >> 8;
            }
            l1 += k1;
        }
    }

    public static void defaultDrawingAreaSize() {
        clipLeft = 0;
        clipTop = 0;
        clipRight = width;
        clipBottom = height;
        maxRight = clipRight - 0;
        centerY = clipRight / 2;
    }

    public static void drawAlphaGradient(int x, int y, int gradientWidth, int gradientHeight, int startColor, int endColor, int alpha) {
        int k1 = 0;
        int l1 = 65536 / gradientHeight;
        if (x < clipLeft) {
            gradientWidth -= clipLeft - x;
            x = clipLeft;
        }
        if (y < clipTop) {
            k1 += (clipTop - y) * l1;
            gradientHeight -= clipTop - y;
            y = clipTop;
        }
        if (x + gradientWidth > clipRight) {
            gradientWidth = clipRight - x;
        }
        if (y + gradientHeight > clipBottom) {
            gradientHeight = clipBottom - y;
        }
        int i2 = width - gradientWidth;
        int result_alpha = 256 - alpha;
        int total_pixels = x + y * width;
        for (int k2 = -gradientHeight; k2 < 0; ++k2) {
            int gradient1 = 65536 - k1 >> 8;
            int gradient2 = k1 >> 8;
            int gradient_color = ((startColor & 0xFF00FF) * gradient1 + (endColor & 0xFF00FF) * gradient2 & 0xFF00FF00) + ((startColor & 0xFF00) * gradient1 + (endColor & 0xFF00) * gradient2 & 0xFF0000) >>> 8;
            int color = ((gradient_color & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((gradient_color & 0xFF00) * alpha >> 8 & 0xFF00);
            for (int k3 = -gradientWidth; k3 < 0; ++k3) {
                int pixel_pixels = raster[total_pixels];
                pixel_pixels = ((pixel_pixels & 0xFF00FF) * result_alpha >> 8 & 0xFF00FF) + ((pixel_pixels & 0xFF00) * result_alpha >> 8 & 0xFF00);
                DrawingArea.raster[total_pixels++] = color + pixel_pixels;
            }
            total_pixels += i2;
            k1 += l1;
        }
    }

    public static void drawFilledPixels(int x, int y, int pixelWidth, int pixelHeight, int color) {
        if (x < clipLeft) {
            pixelWidth -= clipLeft - x;
            x = clipLeft;
        }
        if (y < clipTop) {
            pixelHeight -= clipTop - y;
            y = clipTop;
        }
        if (x + pixelWidth > clipRight) {
            pixelWidth = clipRight - x;
        }
        if (y + pixelHeight > clipBottom) {
            pixelHeight = clipBottom - y;
        }
        int j1 = width - pixelWidth;
        int k1 = x + y * width;
        for (int l1 = -pixelHeight; l1 < 0; ++l1) {
            for (int i2 = -pixelWidth; i2 < 0; ++i2) {
                DrawingArea.raster[k1++] = color;
            }
            k1 += j1;
        }
    }

    public static void drawHorizontalLine(int i, int j, int k, int l) {
        if (i < clipTop || i >= clipBottom) {
            return;
        }
        if (l < clipLeft) {
            k -= clipLeft - l;
            l = clipLeft;
        }
        if (l + k > clipRight) {
            k = clipRight - l;
        }
        int i1 = l + i * width;
        for (int j1 = 0; j1 < k; ++j1) {
            DrawingArea.raster[i1 + j1] = j;
        }
    }

    public static void fillRect(int posX, int posY, int w, int h2, int rgb) {
        if (posX < clipLeft) {
            width -= clipLeft - posX;
            posX = clipLeft;
        }
        if (posY < clipTop) {
            height -= clipTop - posY;
            posY = clipTop;
        }
        if (posX + width > clipRight) {
            width = clipRight - posX;
        }
        if (posY + height > clipBottom) {
            height = clipBottom - posY;
        }
        int k1 = width - w;
        int l1 = posX + posY * width;
        for (int i2 = -h2; i2 < 0; ++i2) {
            for (int j2 = -w; j2 < 0; ++j2) {
                DrawingArea.raster[l1++] = rgb;
            }
            l1 += k1;
        }
    }

    public static void drawPixels(int height, int posY, int posX, int color, int width) {
        if (posX < clipLeft) {
            width -= clipLeft - posX;
            posX = clipLeft;
        }
        if (posY < clipTop) {
            height -= clipTop - posY;
            posY = clipTop;
        }
        if (posX + width > clipRight) {
            width = clipRight - posX;
        }
        if (posY + height > clipBottom) {
            height = clipBottom - posY;
        }
        int k1 = DrawingArea.width - width;
        int l1 = posX + posY * DrawingArea.width;
        for (int i2 = -height; i2 < 0; ++i2) {
            for (int j2 = -width; j2 < 0; ++j2) {
                DrawingArea.raster[l1++] = color;
            }
            l1 += k1;
        }
    }

    public static void fillPixels(int offSetX, int width, int height, int l, int offSetY) {
        DrawingArea.drawHorizontalLine(offSetY, l, width, offSetX);
        DrawingArea.drawHorizontalLine(offSetY + height - 1, l, width, offSetX);
        DrawingArea.method341(offSetY, l, height, offSetX);
        DrawingArea.method341(offSetY, l, height, offSetX + width - 1);
    }

    public static void drawRect(int x, int y, int w, int h2, int rgb) {
        DrawingArea.drawHorizontalLine(x, y, w, rgb);
        DrawingArea.drawHorizontalLine(x, y + h2 - 1, w, rgb);
        DrawingArea.drawVerticalLine(x, y, h2, rgb);
        DrawingArea.drawVerticalLine(x + w - 1, y, h2, rgb);
    }

    public static void drawVerticalLine(int x, int y, int h2, int rgb) {
        if (x < clipLeft || x >= clipRight) {
            return;
        }
        if (y < clipTop) {
            h2 -= clipTop - y;
            y = clipTop;
        }
        if (y + h2 > clipBottom) {
            h2 = clipBottom - y;
        }
        int j1 = x + y * width;
        for (int k1 = 0; k1 < h2; ++k1) {
            DrawingArea.raster[j1 + k1 * DrawingArea.width] = rgb;
        }
    }

    private static void method341(int i, int j, int k, int l) {
        if (l < clipLeft || l >= clipRight) {
            return;
        }
        if (i < clipTop) {
            k -= clipTop - i;
            i = clipTop;
        }
        if (i + k > clipBottom) {
            k = clipBottom - i;
        }
        int j1 = l + i * width;
        for (int k1 = 0; k1 < k; ++k1) {
            DrawingArea.raster[j1 + k1 * DrawingArea.width] = j;
        }
    }

    public static void fillRect(int xPos, int yPos, int areaWidth, int areaHeight, int color, int transparency) {
        if (xPos < clipLeft) {
            areaWidth -= clipLeft - xPos;
            xPos = clipLeft;
        }
        if (yPos < clipTop) {
            areaHeight -= clipTop - yPos;
            yPos = clipTop;
        }
        if (xPos + areaWidth > clipRight) {
            areaWidth = clipRight - xPos;
        }
        if (yPos + areaHeight > clipBottom) {
            areaHeight = clipBottom - yPos;
        }
        int opacity = 256 - transparency;
        int red = (color >> 16 & 0xFF) * transparency;
        int green = (color >> 8 & 0xFF) * transparency;
        int blue = (color & 0xFF) * transparency;
        int xOffset = width - areaWidth;
        int pixel = xPos + yPos * width;
        for (int y = 0; y < areaHeight; ++y) {
            for (int x = -areaWidth; x < 0; ++x) {
                int originRed = (raster[pixel] >> 16 & 0xFF) * opacity;
                int originGreen = (raster[pixel] >> 8 & 0xFF) * opacity;
                int oritinBlue = (raster[pixel] & 0xFF) * opacity;
                int blindedColor = (red + originRed >> 8 << 16) + (green + originGreen >> 8 << 8) + (blue + oritinBlue >> 8);
                DrawingArea.raster[pixel++] = blindedColor;
            }
            pixel += xOffset;
        }
    }

    public static void initDrawingArea(int h2, int w, int[] ai, float[] depth) {
        raster = ai;
        width = w;
        height = h2;
        DrawingArea.setBounds(0, 0, w, h2);
        if (Configuration.DEPTH_BUFFER) {
            depthBuffer = depth;
        }
    }

    public static void method335(int i, int j, int k, int l, int i1, int k1) {
        if (k1 < clipLeft) {
            k -= clipLeft - k1;
            k1 = clipLeft;
        }
        if (j < clipTop) {
            l -= clipTop - j;
            j = clipTop;
        }
        if (k1 + k > clipRight) {
            k = clipRight - k1;
        }
        if (j + l > clipBottom) {
            l = clipBottom - j;
        }
        int l1 = 256 - i1;
        int i2 = (i >> 16 & 0xFF) * i1;
        int j2 = (i >> 8 & 0xFF) * i1;
        int k2 = (i & 0xFF) * i1;
        int k3 = width - k;
        int l3 = k1 + j * width;
        for (int i4 = 0; i4 < l; ++i4) {
            for (int j4 = -k; j4 < 0; ++j4) {
                int l2 = (raster[l3] >> 16 & 0xFF) * l1;
                int i3 = (raster[l3] >> 8 & 0xFF) * l1;
                int j3 = (raster[l3] & 0xFF) * l1;
                int k4 = (i2 + l2 >> 8 << 16) + (j2 + i3 >> 8 << 8) + (k2 + j3 >> 8);
                DrawingArea.raster[l3++] = k4;
            }
            l3 += k3;
        }
    }

    public static void method338(int i, int j, int k, int l, int i1, int j1) {
        DrawingArea.method340(l, i1, i, k, j1);
        DrawingArea.method340(l, i1, i + j - 1, k, j1);
        if (j >= 3) {
            DrawingArea.method342(l, j1, k, i + 1, j - 2);
            DrawingArea.method342(l, j1 + i1 - 1, k, i + 1, j - 2);
        }
    }

    private static void method340(int i, int j, int k, int l, int i1) {
        if (k < clipTop || k >= clipBottom) {
            return;
        }
        if (i1 < clipLeft) {
            j -= clipLeft - i1;
            i1 = clipLeft;
        }
        if (i1 + j > clipRight) {
            j = clipRight - i1;
        }
        int j1 = 256 - l;
        int k1 = (i >> 16 & 0xFF) * l;
        int l1 = (i >> 8 & 0xFF) * l;
        int i2 = (i & 0xFF) * l;
        int i3 = i1 + k * width;
        for (int j3 = 0; j3 < j; ++j3) {
            int j2 = (raster[i3] >> 16 & 0xFF) * j1;
            int k2 = (raster[i3] >> 8 & 0xFF) * j1;
            int l2 = (raster[i3] & 0xFF) * j1;
            int k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            DrawingArea.raster[i3++] = k3;
        }
    }

    private static void method342(int i, int j, int k, int l, int i1) {
        if (j < clipLeft || j >= clipRight) {
            return;
        }
        if (l < clipTop) {
            i1 -= clipTop - l;
            l = clipTop;
        }
        if (l + i1 > clipBottom) {
            i1 = clipBottom - l;
        }
        int j1 = 256 - k;
        int k1 = (i >> 16 & 0xFF) * k;
        int l1 = (i >> 8 & 0xFF) * k;
        int i2 = (i & 0xFF) * k;
        int i3 = j + l * width;
        for (int j3 = 0; j3 < i1; ++j3) {
            int k3;
            int j2 = (raster[i3] >> 16 & 0xFF) * j1;
            int k2 = (raster[i3] >> 8 & 0xFF) * j1;
            int l2 = (raster[i3] & 0xFF) * j1;
            DrawingArea.raster[i3] = k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            i3 += width;
        }
    }

    public static void setAllPixelsToZero() {
        int i = width * height;
        for (int j = 0; j < i; ++j) {
            DrawingArea.raster[j] = 0;
        }
    }

    public static void setBounds(int posX, int posY, int width, int height) {
        if (posX < 0) {
            posX = 0;
        }
        if (posY < 0) {
            posY = 0;
        }
        if (width > DrawingArea.width) {
            width = DrawingArea.width;
        }
        if (height > DrawingArea.height) {
            height = DrawingArea.height;
        }
        clipLeft = posX;
        clipTop = posY;
        clipRight = width;
        clipBottom = height;
        maxRight = clipRight - 0;
        centerY = clipRight / 2;
        middleY = clipBottom / 2;
    }

    public static void resetDepthBuffer() {
        if (depthBuffer == null || depthBuffer.length != raster.length) {
            depthBuffer = new float[raster.length];
        }
        Arrays.fill(depthBuffer, (float)raster.length);
    }

    public static void drawRoundedRectangle(int x, int y, int width, int height, int color, int alpha, boolean filled, boolean shadowed) {
        if (shadowed) {
            DrawingArea.drawRoundedRectangle(x + 1, y + 1, width, height, 0, alpha, filled, false);
        }
        if (alpha == -1) {
            if (filled) {
                DrawingArea.drawHorizontalLine(y + 1, color, width - 4, x + 2);
                DrawingArea.drawHorizontalLine(y + height - 2, color, width - 4, x + 2);
                DrawingArea.drawPixels(height - 4, y + 2, x + 1, color, width - 2);
            }
            DrawingArea.drawHorizontalLine(y, color, width - 4, x + 2);
            DrawingArea.drawHorizontalLine(y + height - 1, color, width - 4, x + 2);
            DrawingArea.method341(y + 2, color, height - 4, x);
            DrawingArea.method341(y + 2, color, height - 4, x + width - 1);
            DrawingArea.drawPixels(1, y + 1, x + 1, color, 1);
            DrawingArea.drawPixels(1, y + 1, x + width - 2, color, 1);
            DrawingArea.drawPixels(1, y + height - 2, x + width - 2, color, 1);
            DrawingArea.drawPixels(1, y + height - 2, x + 1, color, 1);
        } else if (alpha != -1) {
            if (filled) {
                DrawingArea.method340(color, width - 4, y + 1, alpha, x + 2);
                DrawingArea.method340(color, width - 4, y + height - 2, alpha, x + 2);
                DrawingArea.method335(color, y + 2, width - 2, height - 4, alpha, x + 1);
            }
            DrawingArea.method340(color, width - 4, y, alpha, x + 2);
            DrawingArea.method340(color, width - 4, y + height - 1, alpha, x + 2);
            DrawingArea.method342(color, x, alpha, y + 2, height - 4);
            DrawingArea.method342(color, x + width - 1, alpha, y + 2, height - 4);
            DrawingArea.method335(color, y + 1, 1, 1, alpha, x + 1);
            DrawingArea.method335(color, y + 1, 1, 1, alpha, x + width - 2);
            DrawingArea.method335(color, y + height - 2, 1, 1, alpha, x + 1);
            DrawingArea.method335(color, y + height - 2, 1, 1, alpha, x + width - 2);
        }
    }

    public static void fillRectangle(int color, int y, int widthz, int heightz, int opacity, int x) {
        DrawingArea.fillRect(x, y, widthz, heightz, color, opacity);
    }

    public static void drawArc(double x, double y, double width1, double height1, int stroke, double start, double sweep, int color, int alpha, int closure, boolean fill) {
        Graphics2D graphics = DrawingArea.createGraphics(raster, width, height);
        Color CONVERTED_COLOR = new Color(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, alpha);
        graphics.setColor(CONVERTED_COLOR);
        RenderingHints render = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        render.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics.setRenderingHints(render);
        graphics.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics.setStroke(new BasicStroke(Math.max(stroke, 1)));
        Arc2D.Double arc = new Arc2D.Double(x + (double)stroke, y + (double)stroke, width1, height1, start, sweep, closure);
        if (fill) {
            graphics.fill(arc);
            graphics.setColor(Color.decode("0x3f372c").darker());
        }
        graphics.draw(arc);
    }

    public static Graphics2D createGraphics(int[] pixels, int width, int height) {
        return new BufferedImage(COLOR_MODEL, Raster.createWritableRaster(COLOR_MODEL.createCompatibleSampleModel(width, height), new DataBufferInt(pixels, width * height), null), false, new Hashtable()).createGraphics();
    }

    public static void renderGlow(int drawX, int drawY, int glowColor, int r) {
        int startX = (drawX += 16) - r;
        int endX = drawX + r;
        int startY = (drawY += 16) - r;
        int endY = drawY + r;
        if (startX < clipLeft) {
            startX = clipLeft;
        }
        if (endX > clipRight) {
            endX = clipRight;
        }
        if (startY < clipTop) {
            startY = clipTop;
        }
        if (endY > clipBottom) {
            endY = clipBottom;
        }
        float edge0 = -((float)r / 3.0f);
        for (int x = startX; x < endX; ++x) {
            for (int y = startY; y < endY; ++y) {
                int newColor;
                int index = x + y * width;
                float d = MathUtils.dist(x, y, drawX, drawY);
                float dist = MathUtils.smoothstep(edge0, r, d);
                int oldColor = raster[index];
                DrawingArea.raster[index] = newColor = MathUtils.blend(oldColor, glowColor, 1.0f - dist);
            }
        }
    }

    public static void renderGlow(int drawX, int drawY, int glowColor, int r, int t) {
        int startX = (drawX += 16) - r;
        int endX = drawX + r;
        int startY = drawY - t;
        int endY = drawY + t;
        if (startX < clipLeft) {
            startX = clipLeft;
        }
        if (endX > clipRight) {
            endX = clipRight;
        }
        if (startY < clipTop) {
            startY = clipTop;
        }
        if (endY > clipBottom) {
            endY = clipBottom;
        }
        float edge0 = -((float)r / 3.0f);
        for (int x = startX; x < endX; ++x) {
            for (int y = startY; y < endY; ++y) {
                int newColor;
                int index = x + y * width;
                float d = MathUtils.dist(x, y, drawX, drawY);
                float dist = MathUtils.smoothstep(edge0, r, d);
                int oldColor = raster[index];
                DrawingArea.raster[index] = newColor = MathUtils.blend(oldColor, glowColor, 1.0f - dist);
            }
        }
    }

    static {
        COLOR_MODEL = new DirectColorModel(32, 0xFF0000, 65280, 255);
    }
}

