/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.graphics.fonts;

import java.awt.Color;
import org.necrotic.Configuration;
import org.necrotic.client.AnimatedSprite;
import org.necrotic.client.Client;
import org.necrotic.client.cache.Archive;
import org.necrotic.client.graphics.DrawingArea;
import org.necrotic.client.graphics.Sprite;
import org.necrotic.client.io.ByteBuffer;

public class RSFontSystem
extends DrawingArea {
    private static String aRSString_4135;
    private static String startTransparency;
    private static String startDefaultShadow;
    private static String endShadow;
    private static String endEffect;
    private static String endStrikethrough;
    private static String aRSString_4147;
    private static String startColor;
    private static String lineBreak;
    private static String startStrikethrough;
    private static String endColor;
    private static String startImage;
    private static String startClanImage;
    private static String endUnderline;
    private static String defaultStrikethrough;
    private static String startShadow;
    private static String startEffect;
    private static String aRSString_4162;
    private static String aRSString_4163;
    private static String endTransparency;
    private static String aRSString_4165;
    private static String startUnderline;
    private static String startDefaultUnderline;
    private static String aRSString_4169;
    private static int defaultColor;
    private static int textShadowColor;
    private static int strikethroughColor;
    private static int defaultTransparency;
    private static int anInt4175;
    private static int underlineColor;
    private static int defaultShadow;
    private static int anInt4178;
    private static int transparency;
    private static int textColor;
    private int baseCharacterHeight = 0;
    private int[] characterDrawYOffsets;
    private int[] characterHeights;
    private int[] characterDrawXOffsets;
    private int[] characterWidths;
    private byte[][] fontPixels;
    private int[] characterScreenWidths;

    public RSFontSystem(boolean TypeFont, String s2, Archive archive) {
        try {
            int length = s2.equals("regularhit") || s2.equals("bighit") ? 58 : 256;
            this.fontPixels = new byte[length][];
            this.characterWidths = new int[length];
            this.characterHeights = new int[length];
            this.characterDrawXOffsets = new int[length];
            this.characterDrawYOffsets = new int[length];
            this.characterScreenWidths = new int[length];
            ByteBuffer stream = new ByteBuffer(archive.get(s2 + ".dat"));
            ByteBuffer stream_1 = new ByteBuffer(archive.get("index.dat"));
            stream_1.position = stream.getShort() + 4;
            int k = stream_1.getUnsignedByte();
            if (k > 0) {
                stream_1.position += 3 * (k - 1);
            }
            for (int l = 0; l < length; ++l) {
                this.characterDrawXOffsets[l] = stream_1.getUnsignedByte();
                this.characterDrawYOffsets[l] = stream_1.getUnsignedByte();
                int i1 = this.characterWidths[l] = stream_1.getShort();
                int j1 = this.characterHeights[l] = stream_1.getShort();
                int k1 = stream_1.getUnsignedByte();
                int l1 = i1 * j1;
                this.fontPixels[l] = new byte[l1];
                if (k1 == 0) {
                    for (int i2 = 0; i2 < l1; ++i2) {
                        this.fontPixels[l][i2] = stream.getByte();
                    }
                } else if (k1 == 1) {
                    for (int j2 = 0; j2 < i1; ++j2) {
                        for (int l2 = 0; l2 < j1; ++l2) {
                            this.fontPixels[l][j2 + l2 * i1] = stream.getByte();
                        }
                    }
                }
                if (j1 > this.baseCharacterHeight && l < 128) {
                    this.baseCharacterHeight = j1;
                }
                this.characterDrawXOffsets[l] = 1;
                this.characterScreenWidths[l] = i1 + 2;
                int k2 = 0;
                for (int i3 = j1 / 7; i3 < j1; ++i3) {
                    k2 += this.fontPixels[l][i3 * i1];
                }
                if (k2 <= j1 / 7) {
                    int n = l;
                    this.characterScreenWidths[n] = this.characterScreenWidths[n] - 1;
                    this.characterDrawXOffsets[l] = 0;
                }
                k2 = 0;
                for (int j3 = j1 / 7; j3 < j1; ++j3) {
                    k2 += this.fontPixels[l][i1 - 1 + j3 * i1];
                }
                if (k2 > j1 / 7) continue;
                int n = l;
                this.characterScreenWidths[n] = this.characterScreenWidths[n] - 1;
            }
            this.characterScreenWidths[32] = TypeFont ? this.characterScreenWidths[73] : this.characterScreenWidths[105];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void createCharacterPixels(int[] is, byte[] is_24_, int i, int i_25_, int i_26_, int i_27_, int i_28_, int i_29_, int i_30_) {
        int i_31_ = -(i_27_ >> 2);
        i_27_ = -(i_27_ & 3);
        for (int i_32_ = -i_28_; i_32_ < 0; ++i_32_) {
            for (int i_33_ = i_31_; i_33_ < 0; ++i_33_) {
                if (is_24_[i_25_++] != 0) {
                    is[i_26_++] = i;
                } else {
                    ++i_26_;
                }
                if (is_24_[i_25_++] != 0) {
                    is[i_26_++] = i;
                } else {
                    ++i_26_;
                }
                if (is_24_[i_25_++] != 0) {
                    is[i_26_++] = i;
                } else {
                    ++i_26_;
                }
                if (is_24_[i_25_++] != 0) {
                    is[i_26_++] = i;
                    continue;
                }
                ++i_26_;
            }
            for (int i_34_ = i_27_; i_34_ < 0; ++i_34_) {
                if (is_24_[i_25_++] != 0) {
                    is[i_26_++] = i;
                    continue;
                }
                ++i_26_;
            }
            i_26_ += i_29_;
            i_25_ += i_30_;
        }
    }

    private static void createTransparentCharacterPixels(int[] is, byte[] is_0_, int i, int i_1_, int i_2_, int i_3_, int i_4_, int i_5_, int i_6_, int i_7_) {
        i = ((i & 0xFF00FF) * i_7_ & 0xFF00FF00) + ((i & 0xFF00) * i_7_ & 0xFF0000) >> 8;
        i_7_ = 256 - i_7_;
        for (int i_8_ = -i_4_; i_8_ < 0; ++i_8_) {
            for (int i_9_ = -i_3_; i_9_ < 0; ++i_9_) {
                if (is_0_[i_1_++] != 0) {
                    int i_10_ = is[i_2_];
                    is[i_2_++] = (((i_10_ & 0xFF00FF) * i_7_ & 0xFF00FF00) + ((i_10_ & 0xFF00) * i_7_ & 0xFF0000) >> 8) + i;
                    continue;
                }
                ++i_2_;
            }
            i_2_ += i_5_;
            i_1_ += i_6_;
        }
    }

    public static String handleOldSyntax(String text) {
        text = text.replaceAll("@red@", "<col=ff0000>");
        text = text.replaceAll("@gre@", "<col=65280>");
        text = text.replaceAll("@blu@", "<col=255>");
        text = text.replaceAll("@yel@", "<col=ffff00>");
        text = text.replaceAll("@cya@", "<col=65535>");
        text = text.replaceAll("@mag@", "<col=ff00ff>");
        text = text.replaceAll("@whi@", "<col=ffffff>");
        text = text.replaceAll("@lre@", "<col=ff9040>");
        text = text.replaceAll("@dre@", "<col=800000>");
        text = text.replaceAll("@bla@", "<col=0>");
        text = text.replaceAll("@or1@", "<col=ffb000>");
        text = text.replaceAll("@or2@", "<col=ff7000>");
        text = text.replaceAll("@or3@", "<col=ff3000>");
        text = text.replaceAll("@gr1@", "<col=c0ff00>");
        text = text.replaceAll("@gr2@", "<col=80ff00>");
        text = text.replaceAll("@gr3@", "<col=40ff00>");
        text = text.replaceAll("@cr1@", "<img=1>");
        text = text.replaceAll("@cr2@", "<img=2>");
        text = text.replaceAll("@cr3@", "<img=3>");
        text = text.replaceAll("@dev@", "<img=4>");
        text = text.replaceAll("@con@", "<img=6>");
        text = text.replaceAll("@vet@", "<img=5>");
        text = text.replaceAll("@mem@", "<img=7>");
        text = text.replaceAll("@sup@", "<img=5>");
        text = text.replaceAll("<img=13>", "<img=1508>");
        text = text.replaceAll("@str@", "<str>");
        text = text.replaceAll("@end@", "</str>");
        text = text.replaceAll("@leg@", "<col=e3522c>");
        text = text.replaceAll("@epi@", "<col=a334c4>");
        text = text.replaceAll("@rar@", "<col=005fbe>");
        text = text.replaceAll("@unc@", "<col=1ee021>");
        text = text.replaceAll("@com@", "<col=ffffff>");
        text = text.replaceAll("@sta@", "<col=9d9d9d>");
        if (Configuration.SMILIES_ENABLED && !text.contains(":store")) {
            text = text.replace(":=)", "<img=12>");
            text = text.replace("=)", "<img=12>");
            text = text.replace(":)", "<img=12>");
            text = text.replace(":]", "<img=12>");
            text = text.replace(":=(", "<img=13>");
            text = text.replace("=(", "<img=13>");
            text = text.replace(":(", "<img=13>");
            text = text.replace(":[", "<img=13>");
            text = text.replace(":|", "<img=14>");
            text = text.replace(":S", "<img=15>");
            text = text.replace(":s", "<img=15>");
            text = text.replace(":O", "<img=17>");
            text = text.replace(":o", "<img=17>");
            text = text.replace(":8", "<img=16>");
            text = text.replace(":$", "<img=18>");
            text = text.replace(";)", "<img=19>");
            text = text.replace(";]", "<img=19>");
            text = text.replace(":/", "<img=20>");
            text = text.replace(":\\", "<img=20>");
            text = text.replace("\\:", "<img=20>");
            text = text.replace("(y)", "<img=21>");
            text = text.replace("(Y)", "<img=21>");
            text = text.replace("(n)", "<img=22>");
            text = text.replace("(N)", "<img=22>");
            text = text.replace(":p", "<img=23>");
            text = text.replace(":P", "<img=23>");
            text = text.replace(":d", "<img=24>");
            text = text.replace(":D", "<img=24>");
            text = text.replace("=D", "<img=24>");
            text = text.replace("=d", "<img=24>");
            text = text.replace("^^", "<img=25>");
            text = text.replace("<3", "<img=26>");
            text = text.replace("(L)", "<img=26>");
            text = text.replace("(l)", "<img=26>");
            text = text.replace(":'(", "<img=28>");
            text = text.replace(":*", "<img=29>");
            text = text.replace("(a)", "<img=27>");
            text = text.replace("(A)", "<img=27>");
            text = text.replace("-.-", "<img=30>");
            text = text.replace("O.o", "<img=31>");
            text = text.replace("o.O", "<img=31>");
            text = text.replace("o.o", "<img=31>");
            text = text.replace("O.O", "<img=31>");
        }
        return text;
    }

    private static String replace(String s2, String from, String to) {
        if (from == "=D" && s2.contains("col")) {
            return s2;
        }
        return RSFontSystem.replaceAllString(s2, from, to);
    }

    public static String replaceAllString(String strOrig, String strFind, String strReplace) {
        if (strOrig == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(strOrig);
        String toReplace = "";
        toReplace = strReplace == null ? "" : strReplace;
        for (int pos = strOrig.length(); pos > -1; pos -= strFind.length()) {
            if ((pos = strOrig.lastIndexOf(strFind, pos)) <= -1) continue;
            sb.replace(pos, pos + strFind.length(), toReplace);
        }
        return sb.toString();
    }

    public static String removeColors(String text) {
        text = RSFontSystem.replace(text, "@red@", "");
        text = RSFontSystem.replace(text, "@gre@", "");
        text = RSFontSystem.replace(text, "@blu@", "");
        text = RSFontSystem.replace(text, "@yel@", "");
        text = RSFontSystem.replace(text, "@cya@", "");
        text = RSFontSystem.replace(text, "@mag@", "");
        text = RSFontSystem.replace(text, "@whi@", "");
        text = RSFontSystem.replace(text, "@lre@", "");
        text = RSFontSystem.replace(text, "@dre@", "");
        text = RSFontSystem.replace(text, "@bla@", "");
        text = RSFontSystem.replace(text, "@or1@", "");
        text = RSFontSystem.replace(text, "@or2@", "");
        text = RSFontSystem.replace(text, "@pr2@", "");
        text = RSFontSystem.replace(text, "@or3@", "");
        text = RSFontSystem.replace(text, "@gr1@", "");
        text = RSFontSystem.replace(text, "@gr2@", "");
        text = RSFontSystem.replace(text, "@gr3@", "");
        text = RSFontSystem.replace(text, "@cr1@", "");
        text = RSFontSystem.replace(text, "@cr2@", "");
        text = RSFontSystem.replace(text, "@cr3@", "");
        text = RSFontSystem.replace(text, "@dev@", "");
        text = RSFontSystem.replace(text, "@des@", "");
        text = RSFontSystem.replace(text, "@vet@", "");
        text = RSFontSystem.replace(text, "@don@", "");
        text = RSFontSystem.replace(text, "@or2@", "");
        text = RSFontSystem.replace(text, "@purp@", "");
        text = RSFontSystem.replace(text, "@vea@", "");
        text = RSFontSystem.replace(text, "@eas@", "");
        text = RSFontSystem.replace(text, "@med@", "");
        text = RSFontSystem.replace(text, "@har@", "");
        text = RSFontSystem.replace(text, "@vha@", "");
        text = RSFontSystem.replace(text, "@bl2@", "");
        text = RSFontSystem.replace(text, "@gry@", "");
        text = RSFontSystem.replace(text, "@pnk@", "");
        text = RSFontSystem.replace(text, "@pr3@", "");
        if ((text = RSFontSystem.replace(text, "@skb@", "")) != null) {
            while (text.contains("<")) {
                if (!text.contains("<")) continue;
                int index = text.indexOf("<");
                int index1 = text.indexOf(">");
                text = text.substring(0, index) + text.substring(index1 + 1);
            }
        }
        return text;
    }

    public void drawBasicString(String string, int drawX, int drawY, boolean handleOldSyntax) {
        drawY -= this.baseCharacterHeight;
        int startIndex = -1;
        if (handleOldSyntax) {
            string = RSFontSystem.handleOldSyntax(string);
        }
        for (int currentCharacter = 0; currentCharacter < string.length(); ++currentCharacter) {
            int character = string.charAt(currentCharacter);
            if (character > 255) {
                character = 32;
            }
            if (character == 60) {
                startIndex = currentCharacter;
                continue;
            }
            if (character == 62 && startIndex != -1) {
                String effectString = string.substring(startIndex + 1, currentCharacter);
                startIndex = -1;
                if (effectString.equals(startEffect)) {
                    character = 60;
                } else if (effectString.equals(endEffect)) {
                    character = 62;
                } else if (effectString.equals(aRSString_4135)) {
                    character = 160;
                } else if (effectString.equals(aRSString_4162)) {
                    character = 173;
                } else if (effectString.equals(aRSString_4165)) {
                    character = 215;
                } else if (effectString.equals(aRSString_4147)) {
                    character = 128;
                } else if (effectString.equals(aRSString_4163)) {
                    character = 169;
                } else if (effectString.equals(aRSString_4169)) {
                    character = 174;
                } else {
                    if (effectString.startsWith(startImage)) {
                        try {
                            int offsetY = 0;
                            int imageId = Integer.valueOf(effectString.substring(4));
                            if (imageId >= 1 && imageId <= 11) {
                                imageId = 827 + imageId;
                            } else if (imageId >= 12 && imageId <= 31) {
                                imageId = 838 + imageId;
                                offsetY += 3;
                            }
                            AnimatedSprite as = Client.animatedSpriteForImageId(imageId);
                            if (as != null) {
                                as.getInstance(as.myWidth, as.myHeight).drawAdvancedSprite(drawX, drawY + this.baseCharacterHeight - as.myHeight);
                                drawX += as.myWidth;
                                continue;
                            }
                            Sprite icon = Client.spritesMap.get(imageId);
                            int iconModY = icon.myHeight;
                            if (transparency == 256) {
                                icon.drawSprite(drawX, drawY + this.baseCharacterHeight + offsetY - iconModY);
                            } else {
                                icon.drawSprite(drawX, drawY + this.baseCharacterHeight + offsetY - iconModY, transparency);
                            }
                            drawX += icon.myWidth;
                        }
                        catch (Exception offsetY) {}
                        continue;
                    }
                    if (effectString.startsWith(startClanImage)) {
                        try {
                            int imageId = Integer.valueOf(effectString.substring(5));
                            Sprite icon = Client.spritesMap.get(imageId);
                            int iconModY = icon.myHeight + icon.drawOffsetY + 1;
                            if (transparency == 256) {
                                icon.drawSprite(drawX, drawY + this.baseCharacterHeight - iconModY);
                            } else {
                                icon.drawSprite(drawX, drawY + this.baseCharacterHeight - iconModY, transparency);
                            }
                            drawX += 11;
                        }
                        catch (Exception imageId) {}
                        continue;
                    }
                    this.setTextEffects(effectString);
                    continue;
                }
            }
            if (startIndex != -1) continue;
            int width = this.characterWidths[character];
            int height = this.characterHeights[character];
            if (character != 32) {
                if (transparency == 256) {
                    if (textShadowColor != -1) {
                        this.drawCharacter(character, drawX + this.characterDrawXOffsets[character] + 1, drawY + this.characterDrawYOffsets[character] + 1, width, height, textShadowColor, true);
                    }
                    this.drawCharacter(character, drawX + this.characterDrawXOffsets[character], drawY + this.characterDrawYOffsets[character], width, height, textColor, false);
                } else {
                    if (textShadowColor != -1) {
                        this.drawTransparentCharacter(character, drawX + this.characterDrawXOffsets[character] + 1, drawY + this.characterDrawYOffsets[character] + 1, width, height, textShadowColor, transparency, true);
                    }
                    this.drawTransparentCharacter(character, drawX + this.characterDrawXOffsets[character], drawY + this.characterDrawYOffsets[character], width, height, textColor, transparency, false);
                }
            } else if (anInt4178 > 0) {
                drawX += (anInt4175 += anInt4178) >> 8;
                anInt4175 &= 0xFF;
            }
            int lineWidth = this.characterScreenWidths[character];
            if (strikethroughColor != -1) {
                DrawingArea.drawHorizontalLine(drawY + (int)((double)this.baseCharacterHeight * 0.7), strikethroughColor, lineWidth, drawX);
            }
            if (underlineColor != -1) {
                DrawingArea.drawHorizontalLine(drawY + this.baseCharacterHeight, underlineColor, lineWidth, drawX);
            }
            drawX += lineWidth;
        }
    }

    public void drawBasicString(String string, int drawX, int drawY, int color, int shadow, boolean handleOldSyntax) {
        if (string != null) {
            this.setColorAndShadow(color, shadow);
            this.drawBasicString(string, drawX, drawY, handleOldSyntax);
        }
    }

    public void drawBasicString(String string, int drawX, int drawY, int color, int shadow) {
        if (string != null) {
            this.setColorAndShadow(color, shadow);
            this.drawBasicString(string, drawX, drawY, false);
        }
    }

    public void drawCenteredString(String string, int drawX, int drawY, int color, int shadow) {
        if (string != null) {
            this.setColorAndShadow(color, shadow);
            string = RSFontSystem.handleOldSyntax(string);
            this.drawBasicString(string, drawX - this.getTextWidth(string) / 2, drawY, true);
        }
    }

    private void drawCharacter(int character, int i_35_, int i_36_, int i_37_, int i_38_, int i_39_, boolean bool) {
        int i_40_ = i_35_ + i_36_ * DrawingArea.width;
        int i_41_ = DrawingArea.width - i_37_;
        int i_42_ = 0;
        int i_43_ = 0;
        if (i_36_ < DrawingArea.clipTop) {
            int i_44_ = DrawingArea.clipTop - i_36_;
            i_38_ -= i_44_;
            i_36_ = DrawingArea.clipTop;
            i_43_ += i_44_ * i_37_;
            i_40_ += i_44_ * DrawingArea.width;
        }
        if (i_36_ + i_38_ > DrawingArea.clipBottom) {
            i_38_ -= i_36_ + i_38_ - DrawingArea.clipBottom;
        }
        if (i_35_ < DrawingArea.clipLeft) {
            int i_45_ = DrawingArea.clipLeft - i_35_;
            i_37_ -= i_45_;
            i_35_ = DrawingArea.clipLeft;
            i_43_ += i_45_;
            i_40_ += i_45_;
            i_42_ += i_45_;
            i_41_ += i_45_;
        }
        if (i_35_ + i_37_ > DrawingArea.clipRight) {
            int i_46_ = i_35_ + i_37_ - DrawingArea.clipRight;
            i_37_ -= i_46_;
            i_42_ += i_46_;
            i_41_ += i_46_;
        }
        if (i_37_ > 0 && i_38_ > 0) {
            try {
                RSFontSystem.createCharacterPixels(DrawingArea.raster, this.fontPixels[character], i_39_, i_43_, i_40_, i_37_, i_38_, i_41_, i_42_);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void drawTransparentCharacter(int i, int i_11_, int i_12_, int i_13_, int i_14_, int i_15_, int i_16_, boolean bool) {
        int i_17_ = i_11_ + i_12_ * DrawingArea.width;
        int i_18_ = DrawingArea.width - i_13_;
        int i_19_ = 0;
        int i_20_ = 0;
        if (i_12_ < DrawingArea.clipTop) {
            int i_21_ = DrawingArea.clipTop - i_12_;
            i_14_ -= i_21_;
            i_12_ = DrawingArea.clipTop;
            i_20_ += i_21_ * i_13_;
            i_17_ += i_21_ * DrawingArea.width;
        }
        if (i_12_ + i_14_ > DrawingArea.clipBottom) {
            i_14_ -= i_12_ + i_14_ - DrawingArea.clipBottom;
        }
        if (i_11_ < DrawingArea.clipLeft) {
            int i_22_ = DrawingArea.clipLeft - i_11_;
            i_13_ -= i_22_;
            i_11_ = DrawingArea.clipLeft;
            i_20_ += i_22_;
            i_17_ += i_22_;
            i_19_ += i_22_;
            i_18_ += i_22_;
        }
        if (i_11_ + i_13_ > DrawingArea.clipRight) {
            int i_23_ = i_11_ + i_13_ - DrawingArea.clipRight;
            i_13_ -= i_23_;
            i_19_ += i_23_;
            i_18_ += i_23_;
        }
        if (i_13_ > 0 && i_14_ > 0) {
            RSFontSystem.createTransparentCharacterPixels(DrawingArea.raster, this.fontPixels[i], i_15_, i_20_, i_17_, i_13_, i_14_, i_18_, i_19_, i_16_);
        }
    }

    public int getTextWidth(String string) {
        if (string == null) {
            return 0;
        }
        int startIndex = -1;
        int finalWidth = 0;
        for (int currentCharacter = 0; currentCharacter < string.length(); ++currentCharacter) {
            if (string.charAt(currentCharacter) == '@' && currentCharacter + 4 < string.length() && string.charAt(currentCharacter + 4) == '@') {
                currentCharacter += 4;
                continue;
            }
            int character = string.charAt(currentCharacter);
            if (character > 255) {
                character = 32;
            }
            if (character == 60) {
                startIndex = currentCharacter;
                continue;
            }
            if (character == 62 && startIndex != -1) {
                String effectString = string.substring(startIndex + 1, currentCharacter);
                startIndex = -1;
                if (effectString.equals(startEffect)) {
                    character = 60;
                } else if (effectString.equals(endEffect)) {
                    character = 62;
                } else if (effectString.equals(aRSString_4135)) {
                    character = 160;
                } else if (effectString.equals(aRSString_4162)) {
                    character = 173;
                } else if (effectString.equals(aRSString_4165)) {
                    character = 215;
                } else if (effectString.equals(aRSString_4147)) {
                    character = 128;
                } else if (effectString.equals(aRSString_4163)) {
                    character = 169;
                } else if (effectString.equals(aRSString_4169)) {
                    character = 174;
                } else {
                    if (!effectString.startsWith(startImage)) continue;
                    try {
                        int iconId = Integer.parseInt(effectString.substring(4));
                        int iconWidth = Client.spritesMap.get((int)iconId).myWidth;
                        finalWidth += iconWidth;
                    }
                    catch (Exception exception) {}
                    continue;
                }
            }
            if (startIndex != -1) continue;
            finalWidth += this.characterScreenWidths[character];
        }
        return finalWidth;
    }

    private void setColorAndShadow(int color, int shadow) {
        strikethroughColor = -1;
        underlineColor = -1;
        textShadowColor = defaultShadow = shadow;
        textColor = defaultColor = color;
        defaultTransparency = 256;
        transparency = 256;
        anInt4178 = 0;
        anInt4175 = 0;
    }

    private void setDefaultTextEffectValues(int color, int shadow, int trans) {
        strikethroughColor = -1;
        underlineColor = -1;
        textShadowColor = defaultShadow = shadow;
        textColor = defaultColor = color;
        transparency = defaultTransparency = trans;
        anInt4178 = 0;
        anInt4175 = 0;
    }

    public void setTextEffects(String string) {
        try {
            if (string.startsWith(startColor)) {
                String color = string.substring(4);
                textColor = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string.equals(endColor)) {
                textColor = defaultColor;
            } else if (string.startsWith(startTransparency)) {
                transparency = Integer.valueOf(string.substring(6));
            } else if (string.equals(endTransparency)) {
                transparency = defaultTransparency;
            } else if (string.startsWith(startStrikethrough)) {
                String color = string.substring(4);
                strikethroughColor = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string.equals(defaultStrikethrough)) {
                strikethroughColor = 0x800000;
            } else if (string.equals(endStrikethrough)) {
                strikethroughColor = -1;
            } else if (string.startsWith(startUnderline)) {
                String color = string.substring(2);
                underlineColor = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string.equals(startDefaultUnderline)) {
                underlineColor = 0;
            } else if (string.equals(endUnderline)) {
                underlineColor = -1;
            } else if (string.startsWith(startShadow)) {
                String color = string.substring(5);
                textShadowColor = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string.equals(startDefaultShadow)) {
                textShadowColor = 0;
            } else if (string.equals(endShadow)) {
                textShadowColor = defaultShadow;
            } else if (string.equals(lineBreak)) {
                this.setDefaultTextEffectValues(defaultColor, defaultShadow, defaultTransparency);
            }
        }
        catch (Exception exception) {}
    }

    static {
        endShadow = "/shad";
        endStrikethrough = "/str";
        startTransparency = "trans=";
        startStrikethrough = "str=";
        startDefaultShadow = "shad";
        startColor = "col=";
        lineBreak = "br";
        defaultStrikethrough = "str";
        endUnderline = "/u";
        startImage = "img=";
        startClanImage = "clan=";
        startShadow = "shad=";
        startUnderline = "u=";
        endColor = "/col";
        startDefaultUnderline = "u";
        endTransparency = "/trans";
        aRSString_4135 = "nbsp";
        aRSString_4169 = "reg";
        aRSString_4165 = "times";
        aRSString_4162 = "shy";
        aRSString_4163 = "copy";
        endEffect = "gt";
        aRSString_4147 = "euro";
        startEffect = "lt";
        defaultTransparency = 256;
        defaultShadow = -1;
        anInt4175 = 0;
        textShadowColor = -1;
        textColor = 0;
        defaultColor = 0;
        strikethroughColor = -1;
        underlineColor = -1;
        anInt4178 = 0;
        transparency = 256;
    }
}

