/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.graphics.rsinterface;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.necrotic.client.cache.definition.Animation;
import org.necrotic.client.cache.definition.MobDefinition;

public class PetSystem {
    private final int[] modelArray;
    private final int modelArrayLength;
    private final int primaryModel;
    private final int secondaryModel;
    private final String name;
    private final byte[] description;
    private static int animation;
    private static int animationDelay;
    public static int animationFrame;
    public static boolean updatePetAnimations;
    public static boolean isPetAnimationRunning;
    public static int petSelected;

    public PetSystem(MobDefinition entity) {
        this.modelArray = entity.npcModels;
        this.modelArrayLength = entity.npcModels.length;
        this.primaryModel = entity.npcModels[0];
        this.secondaryModel = entity.npcModels[1];
        this.name = entity.name;
        this.description = entity.description;
        animation = entity.walkAnimation;
        animationDelay = Animation.cache[PetSystem.animation].delays[animationFrame];
    }

    public static void petAnimationStep() {
        if (updatePetAnimations) {
            return;
        }
        if (++animationFrame >= Animation.cache[PetSystem.animation].frameIDs.length) {
            animationFrame = 0;
        }
    }

    public static void updateAnimations() {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                isPetAnimationRunning = true;
                PetSystem.petAnimationStep();
            }
        }, 0L, animationDelay == 0 ? 100L : (long)(animationDelay * 100), TimeUnit.MILLISECONDS);
    }

    public int getAnimationDelay() {
        return animationDelay;
    }

    public int getPrimaryModel() {
        return this.primaryModel;
    }

    public int getAnimation() {
        return animation;
    }

    public String getName() {
        return this.name;
    }

    public int getAnimationFrame() {
        return animationFrame;
    }

    public byte[] getDescription() {
        return this.description;
    }

    public int getSecondaryModel() {
        return this.secondaryModel;
    }

    public int getModelArrayLength() {
        return this.modelArrayLength;
    }

    public int[] getModelArray() {
        return this.modelArray;
    }

    public int getPetSelected() {
        return petSelected;
    }

    public void setPetSelected(int petID) {
        petSelected = petID;
    }

    static {
        updatePetAnimations = false;
        isPetAnimationRunning = false;
        petSelected = 6260;
    }
}

