/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.io;

import java.math.BigInteger;
import org.necrotic.client.Signlink;
import org.necrotic.client.cache.node.Deque;
import org.necrotic.client.cache.node.NodeSub;
import org.necrotic.client.io.ISAACCipher;

public final class ByteBuffer
extends NodeSub {
    private static int anInt1412;
    private static final int[] anIntArray1409;
    private static final Deque nodeList;
    public int bitPosition;
    public byte[] buffer;
    public ISAACCipher encryption;
    public int position = 0;
    public static final BigInteger RSA_MODULUS;
    public static final BigInteger RSA_EXPONENT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer create() {
        Deque deque = nodeList;
        synchronized (deque) {
            ByteBuffer stream = null;
            if (anInt1412 > 0) {
                --anInt1412;
                stream = (ByteBuffer)nodeList.popHead();
            }
            if (stream != null) {
                stream.position = 0;
                return stream;
            }
        }
        ByteBuffer stream_1 = new ByteBuffer();
        stream_1.position = 0;
        stream_1.buffer = new byte[5000];
        return stream_1;
    }

    private ByteBuffer() {
    }

    public ByteBuffer(byte[] buffer) {
        this.buffer = buffer;
        this.position = 0;
    }

    public void increaseCapacity(int size) {
        byte[] newBuffer = new byte[this.buffer.length + 1];
        for (int i = 0; i < this.buffer.length; ++i) {
            newBuffer[i] = this.buffer[i];
        }
        this.buffer = newBuffer;
    }

    public void encryptRSAContent() {
        int currentPosition = this.position;
        this.position = 0;
        byte[] decodeBuffer = new byte[currentPosition];
        this.getBytes(currentPosition, 0, decodeBuffer);
        BigInteger decodedBigInteger = new BigInteger(decodeBuffer);
        BigInteger encodedBigInteger = decodedBigInteger.modPow(RSA_EXPONENT, RSA_MODULUS);
        byte[] encodedBuffer = encodedBigInteger.toByteArray();
        this.position = 0;
        this.putByte(encodedBuffer.length);
        this.putBytes(encodedBuffer, encodedBuffer.length, 0);
    }

    public void finishBitAccess() {
        this.position = (this.bitPosition + 7) / 8;
    }

    public int getBits(int bitLength) {
        int k = this.bitPosition >> 3;
        int l = 8 - (this.bitPosition & 7);
        int i1 = 0;
        this.bitPosition += bitLength;
        while (bitLength > l) {
            i1 += (this.buffer[k++] & anIntArray1409[l]) << bitLength - l;
            bitLength -= l;
            l = 8;
        }
        i1 = bitLength == l ? (i1 += this.buffer[k] & anIntArray1409[l]) : (i1 += this.buffer[k] >> l - bitLength & anIntArray1409[bitLength]);
        return i1;
    }

    public byte getByte() {
        return this.buffer[this.position++];
    }

    public void getByte(int value) {
        this.buffer[this.position++] = (byte)value;
    }

    public byte[] getBytes() {
        int pos = this.position;
        while (this.buffer[this.position++] != 10) {
        }
        byte[] buf = new byte[this.position - pos - 1];
        System.arraycopy(this.buffer, pos, buf, pos - pos, this.position - 1 - pos);
        return buf;
    }

    public void getBytes(int len, int off, byte[] dest) {
        for (int i = off; i < off + len; ++i) {
            dest[i] = this.buffer[this.position++];
        }
    }

    public int getInt() {
        this.position += 4;
        return ((this.buffer[this.position - 4] & 0xFF) << 24) + ((this.buffer[this.position - 3] & 0xFF) << 16) + ((this.buffer[this.position - 2] & 0xFF) << 8) + (this.buffer[this.position - 1] & 0xFF);
    }

    public int getIntLittleEndian() {
        this.position += 4;
        return ((this.buffer[this.position - 4] & 0xFF) << 24) + ((this.buffer[this.position - 3] & 0xFF) << 16) + ((this.buffer[this.position - 2] & 0xFF) << 8) + (this.buffer[this.position - 1] & 0xFF);
    }

    public long getLong() {
        long msw = (long)this.getIntLittleEndian() & 0xFFFFFFFFL;
        long lsw = (long)this.getIntLittleEndian() & 0xFFFFFFFFL;
        return msw << 32 | lsw;
    }

    public int getShort() {
        this.position += 2;
        return ((this.buffer[this.position - 2] & 0xFF) << 8) + (this.buffer[this.position - 1] & 0xFF);
    }

    public int getShort2() {
        this.position += 2;
        int i = ((this.buffer[this.position - 2] & 0xFF) << 8) + (this.buffer[this.position - 1] & 0xFF);
        if (i > 60000) {
            i = -65535 + i;
        }
        return i;
    }

    public int getShortBigEndian() {
        this.position += 2;
        return ((this.buffer[this.position - 1] & 0xFF) << 8) + (this.buffer[this.position - 2] & 0xFF);
    }

    public int getShortBigEndianA() {
        this.position += 2;
        return ((this.buffer[this.position - 1] & 0xFF) << 8) + (this.buffer[this.position - 2] - 128 & 0xFF);
    }

    public byte getSignedByte() {
        return this.buffer[this.position++];
    }

    public int getSignedShort() {
        this.position += 2;
        int value = ((this.buffer[this.position - 2] & 0xFF) << 8) + (this.buffer[this.position - 1] & 0xFF);
        if (value > Short.MAX_VALUE) {
            value -= 65536;
        }
        return value;
    }

    public int getSmart() {
        try {
            if (this.position >= this.buffer.length) {
                return this.buffer[this.buffer.length - 1] & 0xFF;
            }
            int value = this.buffer[this.position] & 0xFF;
            if (value < 128) {
                return this.getUnsignedByte();
            }
            return this.getUnsignedShort() - 32768;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.getUnsignedShort() - 32768;
        }
    }

    public String getString() {
        int i = this.position;
        while (this.buffer[this.position++] != 10) {
        }
        return new String(this.buffer, i, this.position - i - 1);
    }

    public int getTribyte() {
        this.position += 3;
        return ((this.buffer[this.position - 3] & 0xFF) << 16) + ((this.buffer[this.position - 2] & 0xFF) << 8) + (this.buffer[this.position - 1] & 0xFF);
    }

    public final int getTribyte(int value) {
        this.position += 3;
        return (0xFF & this.buffer[this.position - 3] << 16) + (0xFF & this.buffer[this.position - 2] << 8) + (0xFF & this.buffer[this.position - 1]);
    }

    public int getUnsignedByte() {
        if (this.position + 1 > this.buffer.length) {
            this.position = this.buffer.length - 2;
        }
        return this.buffer[this.position++] & 0xFF;
    }

    public int getUnsignedShort() {
        if (this.position + 2 > this.buffer.length) {
            return this.buffer[this.buffer.length - 1];
        }
        this.position += 2;
        return ((this.buffer[this.position - 2] & 0xFF) << 8) + (this.buffer[this.position - 1] & 0xFF);
    }

    public int readUnsignedWord() {
        this.position += 2;
        return ((this.buffer[this.position - 2] & 0xFF) << 8) + (this.buffer[this.position - 1] & 0xFF);
    }

    public int getUSmart2() {
        int baseVal = 0;
        int lastVal = 0;
        while ((lastVal = this.getSmart()) == Short.MAX_VALUE) {
            baseVal += Short.MAX_VALUE;
        }
        return baseVal + lastVal;
    }

    public void initBitAccess() {
        this.bitPosition = this.position << 3;
    }

    void method400(int value) {
        this.buffer[this.position++] = (byte)value;
        this.buffer[this.position++] = (byte)(value >> 8);
    }

    void method403(int value) {
        this.buffer[this.position++] = (byte)value;
        this.buffer[this.position++] = (byte)(value >> 8);
        this.buffer[this.position++] = (byte)(value >> 16);
        this.buffer[this.position++] = (byte)(value >> 24);
    }

    public int method421() {
        int i = this.buffer[this.position] & 0xFF;
        if (i < 128) {
            return this.getUnsignedByte() - 64;
        }
        return this.getUnsignedShort() - 49152;
    }

    public void method424(int i) {
        this.buffer[this.position++] = (byte)(-i);
    }

    public void method425(int j) {
        this.buffer[this.position++] = (byte)(128 - j);
    }

    public int method426() {
        return this.buffer[this.position++] - 128 & 0xFF;
    }

    public int method427() {
        return -this.buffer[this.position++] & 0xFF;
    }

    public int getByteA() {
        this.position += 2;
        return ((this.buffer[this.position - 2] & 0xFF) << 8) + (this.buffer[this.position - 1] - 128 & 0xFF);
    }

    public int method428() {
        return 128 - this.buffer[this.position++] & 0xFF;
    }

    public byte method429() {
        return -this.buffer[this.position++];
    }

    public byte method430() {
        return (byte)(128 - this.buffer[this.position++]);
    }

    public void writeUnsignedWordBigEndian(int i) {
        this.buffer[this.position++] = (byte)i;
        this.buffer[this.position++] = (byte)(i >> 8);
    }

    public void writeUnsignedWordA(int j) {
        this.buffer[this.position++] = (byte)(j >> 8);
        this.buffer[this.position++] = (byte)(j + 128);
    }

    public void writeSignedBigEndian(int j) {
        this.buffer[this.position++] = (byte)(j + 128);
        this.buffer[this.position++] = (byte)(j >> 8);
    }

    public int method435() {
        this.position += 2;
        return ((this.buffer[this.position - 2] & 0xFF) << 8) + (this.buffer[this.position - 1] - 128 & 0xFF);
    }

    public int method437() {
        this.position += 2;
        int j = ((this.buffer[this.position - 1] & 0xFF) << 8) + (this.buffer[this.position - 2] & 0xFF);
        if (j > Short.MAX_VALUE) {
            j -= 65536;
        }
        return j;
    }

    public int method438() {
        this.position += 2;
        int j = ((this.buffer[this.position - 1] & 0xFF) << 8) + (this.buffer[this.position - 2] - 128 & 0xFF);
        if (j > Short.MAX_VALUE) {
            j -= 65536;
        }
        return j;
    }

    public int method439() {
        this.position += 4;
        return ((this.buffer[this.position - 2] & 0xFF) << 24) + ((this.buffer[this.position - 1] & 0xFF) << 16) + ((this.buffer[this.position - 4] & 0xFF) << 8) + (this.buffer[this.position - 3] & 0xFF);
    }

    public int method440() {
        this.position += 4;
        return ((this.buffer[this.position - 3] & 0xFF) << 24) + ((this.buffer[this.position - 4] & 0xFF) << 16) + ((this.buffer[this.position - 1] & 0xFF) << 8) + (this.buffer[this.position - 2] & 0xFF);
    }

    public void method441(int i, byte[] abyte0, int j) {
        for (int k = i + j - 1; k >= i; --k) {
            this.buffer[this.position++] = (byte)(abyte0[k] + 128);
        }
    }

    public int readInt() {
        return (this.getUnsignedByte() << 24) + (this.getUnsignedByte() << 16) + (this.getUnsignedByte() << 8) + this.getUnsignedByte();
    }

    public void method442(int i, int j, byte[] abyte0) {
        for (int k = j + i - 1; k >= j; --k) {
            abyte0[k] = this.buffer[this.position++];
        }
    }

    public void putBytes(byte[] tmp, int len, int off) {
        for (int i = off; i < off + len; ++i) {
            this.buffer[this.position++] = tmp[i];
        }
    }

    public void putDWordBigEndian(int value) {
        this.buffer[this.position++] = (byte)(value >> 16);
        this.buffer[this.position++] = (byte)(value >> 8);
        this.buffer[this.position++] = (byte)value;
    }

    public void putInt(int i) {
        this.buffer[this.position++] = (byte)(i >> 24);
        this.buffer[this.position++] = (byte)(i >> 16);
        this.buffer[this.position++] = (byte)(i >> 8);
        this.buffer[this.position++] = (byte)i;
    }

    public void putLong(long value) {
        try {
            this.buffer[this.position++] = (byte)(value >> 56);
            this.buffer[this.position++] = (byte)(value >> 48);
            this.buffer[this.position++] = (byte)(value >> 40);
            this.buffer[this.position++] = (byte)(value >> 32);
            this.buffer[this.position++] = (byte)(value >> 24);
            this.buffer[this.position++] = (byte)(value >> 16);
            this.buffer[this.position++] = (byte)(value >> 8);
            this.buffer[this.position++] = (byte)value;
        }
        catch (RuntimeException runtimeexception) {
            Signlink.reportError("14395, 5, " + value + ", " + runtimeexception.toString());
            throw new RuntimeException();
        }
    }

    public void putOpcode(int i) {
        this.buffer[this.position++] = (byte)(i + this.encryption.next());
    }

    public void putShort(int value) {
        this.buffer[this.position++] = (byte)(value >> 8);
        this.buffer[this.position++] = (byte)value;
    }

    public void putString(String s2) {
        System.arraycopy(s2.getBytes(), 0, this.buffer, this.position, s2.length());
        this.position += s2.length();
        this.buffer[this.position++] = 10;
    }

    public void putVariableSizeByte(int size) {
        this.buffer[this.position - size - 1] = (byte)size;
    }

    public void putByte(int i) {
        this.buffer[this.position++] = (byte)i;
    }

    public void doKeys() {
        int i = this.position;
        this.position = 0;
        byte[] abyte0 = new byte[i];
        this.getBytes(i, 0, abyte0);
        BigInteger biginteger2 = new BigInteger(abyte0);
        BigInteger biginteger3 = biginteger2.modPow(RSA_EXPONENT, RSA_MODULUS);
        byte[] abyte1 = biginteger3.toByteArray();
        this.position = 0;
        this.putByte(abyte1.length);
        this.putBytes(abyte1, abyte1.length, 0);
    }

    static {
        anIntArray1409 = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
        nodeList = new Deque();
        RSA_MODULUS = new BigInteger("96194624385427946013325647944654257605872529630710948700405785661900897013831925044455154327577673396546454845008566365279459218895926920900465797949129028296450751054265941727527953060792972393944366210261778350949306621157386141134363849408962437807899195137501781977001604779512001906684176249221065475087");
        RSA_EXPONENT = new BigInteger("65537");
    }
}

