/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.notification;

import java.awt.Color;
import org.necrotic.client.Client;
import org.necrotic.client.graphics.DrawingArea;

public class AlertBox {
    private int width;
    private int height;
    private int openedHeight;
    private final String headerText;
    private final String[] lines;
    private boolean isHovered;
    private boolean closing = false;
    private boolean opening = false;
    private int color;
    private int opacitymax = 100;
    private int opacity = 10;
    private int addX;
    private int addY;
    private int spriteID;

    public AlertBox(int paramInt1, int paramInt2, int spriteId, int color, int opacity, String paramString, String ... paramVarArgs) {
        this.width = paramInt1;
        this.height = paramInt2;
        this.openedHeight = paramInt2;
        this.headerText = paramString;
        this.lines = paramVarArgs;
        this.spriteID = spriteId;
        this.color = color;
        this.opacitymax = opacity;
    }

    public AlertBox(String paramString, int spriteId, int width, int height, int color, int opacity, String ... paramVarArgs) {
        this(width, height, spriteId, color, opacity, paramString, paramVarArgs);
    }

    public void close() {
        this.closing = true;
    }

    public boolean done() {
        return this.closing && this.opacity < 10;
    }

    public void draw() {
        if (this.closing) {
            this.opacity -= 2;
            this.height -= 2;
        }
        if (!this.closing && this.opacity == 10) {
            this.height = 10;
            this.opening = true;
        }
        int i = this.getStartX() + this.addX;
        int j = this.getStartY() + this.addY;
        DrawingArea.drawRoundedRectangle(i, j + 5, this.width, this.getHeight() - 5, this.color, this.opacity, true, false);
        if (!this.closing) {
            Client.instance.newRegularFont.drawCenteredString(this.headerText, this.getStartX(this.headerText), j + 25, Color.WHITE.getRGB(), 0);
            for (int k = 0; k < this.lines.length; ++k) {
                Client.instance.newSmallFont.drawCenteredString(this.lines[k], this.getStartX(this.lines[k]), this.getStartY(k), Color.WHITE.getRGB(), 0);
            }
            if (this.spriteID >= 0) {
                Client.spritesMap.get(this.spriteID).drawSprite3(i + 10, j + 8, this.opacity + 100);
                Client.spritesMap.get(this.spriteID).drawSprite3(i + this.width - 60, j + 8, this.opacity + 100);
            }
        }
    }

    public void processMouse(int paramInt1, int paramInt2) {
        if (this.closing) {
            return;
        }
        boolean bl = this.isHovered = paramInt1 >= this.getStartX() && paramInt1 <= this.getStartX() + this.width && paramInt2 >= this.getStartY() && paramInt2 <= this.getStartY() + this.getHeight() && this.opacity >= this.opacitymax - 30 && !this.opening;
        if (this.isHovered) {
            if (this.opacity > this.opacitymax - 30) {
                this.opacity -= 5;
            }
            Client.instance.menuActionName[1] = "Dismiss";
            Client.instance.menuActionID[1] = 476;
            Client.instance.menuActionRow = 2;
        } else {
            if (this.opacity <= this.opacitymax && this.opening) {
                this.height += 3;
            }
            if (this.opacity >= this.opacitymax || this.height == this.openedHeight) {
                this.opening = false;
                this.opacity = this.opacitymax;
            }
            if (this.opacity < this.opacitymax) {
                this.opacity += 2;
            }
        }
    }

    private int getStartX(String paramString) {
        return 254 - Client.instance.newSmallFont.getTextWidth(paramString) / paramString.length();
    }

    private int getStartY(int paramInt) {
        return this.getStartY() + 25 + 16 + paramInt * 14;
    }

    private int calculateRequiredExtraHeight() {
        return this.lines.length * 16 - 16;
    }

    private int getStartX() {
        return 254 - this.width / 2;
    }

    private int getStartY() {
        return (Client.resize_canvas_requested ? Client.clientHeight - 171 : Client.clientHeight - 169) - this.getHeight();
    }

    private int getHeight() {
        return this.height + this.calculateRequiredExtraHeight();
    }
}

