/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.necrotic.client.cache.definition.ItemDefinition;
import org.necrotic.client.tools.ItemPanel;

public class ItemEditor
implements ActionListener,
ChangeListener,
MouseListener,
MouseMotionListener {
    private static ItemEditor instance;
    private int itemId = -1;
    public int x = -1;
    public int y = -1;
    public int saveClickX = -1;
    public int saveClickY = -1;
    private boolean selected = false;
    private final int modifiedModelColor = 0;
    private JMenuItem menuItem;
    private JFrame frame;
    private ItemPanel gamePanel;
    private JPanel toolBox;
    private JPanel innerToolBox;
    private JLabel xRotSliderLabel;
    private JSlider rotationXSlider;
    private JLabel yRotSliderLabel;
    private JSlider rotationYSlider;
    private JLabel zoomSliderLabel;
    private JSlider zoomSlider;
    private JLabel xOffSliderLabel;
    private JSlider offsetXSlider;
    private JLabel yOffSliderLabel;
    private JSlider offsetYSlider;
    private JLabel colorLabel;
    private JSlider colorSlider;
    private JLabel presetsLabel;
    private JComboBox presets;
    private JPopupMenu rightClickMenu;
    private JMenuItem menuItem1;
    private JMenu menuItem2;
    private JButton b1;
    private JMenuItem menuItem3;
    private JMenuItem menuItem4;
    private JMenuItem menuItem5;
    private JMenuItem menuItem6;
    private JMenuItem menuItem7;
    private JMenuItem menuItem8;
    private JMenuItem menuItem9;

    public boolean isSelected() {
        return this.selected;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public int getItemID() {
        return this.itemId;
    }

    public static ItemEditor getInstance() {
        return instance;
    }

    public static ItemEditor getInstance(int item) {
        if (instance != null && ItemEditor.instance.itemId != item) {
            ItemEditor.instance.frame.dispose();
            instance = null;
        }
        if (instance == null) {
            instance = new ItemEditor(new String[]{item + ""});
        }
        return instance;
    }

    public ItemEditor(String[] args) {
        try {
            this.itemId = Integer.parseInt(args[0]);
            this.initUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void initUI() {
        try {
            ItemDefinition iDef = ItemDefinition.get(this.getItemID());
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            this.frame = new JFrame("Inventory Model Calibrator - By Supah Fly");
            this.frame.setLayout(new BorderLayout());
            this.frame.setDefaultCloseOperation(2);
            this.frame.addMouseListener(this);
            this.frame.addMouseMotionListener(this);
            this.rightClickMenu = new JPopupMenu();
            this.menuItem1 = new JMenuItem("Choose Item");
            this.menuItem1.addActionListener(this);
            this.menuItem2 = new JMenu("Set");
            this.menuItem2.addActionListener(this);
            this.menuItem3 = new JMenuItem("X-Axis Rotation");
            this.menuItem3.addActionListener(this);
            this.menuItem4 = new JMenuItem("Y-Axis Rotation");
            this.menuItem4.addActionListener(this);
            this.menuItem5 = new JMenuItem("Z-Axis Zoom");
            this.menuItem5.addActionListener(this);
            this.menuItem6 = new JMenuItem("X Offset");
            this.menuItem6.addActionListener(this);
            this.menuItem7 = new JMenuItem("Y Offset");
            this.menuItem7.addActionListener(this);
            this.b1 = new JButton("Export");
            this.b1.setActionCommand("export");
            this.b1.addActionListener(this);
            this.menuItem2.add(this.menuItem3);
            this.menuItem2.add(this.menuItem4);
            this.menuItem2.add(this.menuItem5);
            this.menuItem2.add(this.menuItem6);
            this.menuItem2.add(this.menuItem7);
            this.rightClickMenu.add(this.menuItem1);
            this.rightClickMenu.add(this.menuItem2);
            this.gamePanel = new ItemPanel(this);
            this.gamePanel.setLayout(new BorderLayout());
            this.gamePanel.setPreferredSize(new Dimension(240, 324));
            this.toolBox = new JPanel();
            this.toolBox.setLayout(new BoxLayout(this.toolBox, 1));
            this.toolBox.setPreferredSize(new Dimension(225, 324));
            this.innerToolBox = new JPanel();
            this.innerToolBox.setLayout(new FlowLayout());
            this.xRotSliderLabel = new JLabel("X-Axis Rotation (" + iDef.rotationX + ")", 0);
            this.xRotSliderLabel.setAlignmentX(0.5f);
            this.xRotSliderLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            this.rotationXSlider = new JSlider(0, 0, 2000, iDef.rotationX);
            this.rotationXSlider.addChangeListener(this);
            this.rotationXSlider.setMajorTickSpacing(500);
            this.rotationXSlider.setMinorTickSpacing(100);
            this.rotationXSlider.setPaintTicks(true);
            this.rotationXSlider.setBorder(BorderFactory.createEmptyBorder(0, 5, 10, 5));
            this.yRotSliderLabel = new JLabel("Y-Axis Rotation (" + iDef.rotationY + ")", 0);
            this.yRotSliderLabel.setAlignmentX(0.5f);
            this.rotationYSlider = new JSlider(0, 0, 2000, iDef.rotationY);
            this.rotationYSlider.addChangeListener(this);
            this.rotationYSlider.setMajorTickSpacing(500);
            this.rotationYSlider.setMinorTickSpacing(100);
            this.rotationYSlider.setPaintTicks(true);
            this.rotationYSlider.setBorder(BorderFactory.createEmptyBorder(0, 5, 10, 5));
            this.zoomSliderLabel = new JLabel("Z-Axis Zoom (" + iDef.modelZoom + ")", 0);
            this.zoomSliderLabel.setAlignmentX(0.5f);
            this.zoomSlider = new JSlider(0, 317, 2000, iDef.modelZoom);
            this.zoomSlider.addChangeListener(this);
            this.zoomSlider.setMajorTickSpacing(500);
            this.zoomSlider.setMinorTickSpacing(100);
            this.zoomSlider.setPaintTicks(true);
            this.zoomSlider.setBorder(BorderFactory.createEmptyBorder(0, 5, 10, 5));
            this.xOffSliderLabel = new JLabel("X Offset (" + iDef.rotationZ + ")", 0);
            this.xOffSliderLabel.setAlignmentX(0.5f);
            this.xOffSliderLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            this.offsetXSlider = new JSlider(0, -200, 200, iDef.rotationZ);
            this.offsetXSlider.addChangeListener(this);
            this.offsetXSlider.setMajorTickSpacing(50);
            this.offsetXSlider.setMinorTickSpacing(10);
            this.offsetXSlider.setPaintTicks(true);
            this.offsetXSlider.setBorder(BorderFactory.createEmptyBorder(0, 5, 10, 5));
            this.yOffSliderLabel = new JLabel("Y Offset (" + iDef.modelOffsetY + ")", 0);
            this.yOffSliderLabel.setAlignmentX(0.5f);
            this.yOffSliderLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            this.offsetYSlider = new JSlider(0, -200, 200, iDef.modelOffsetY);
            this.offsetYSlider.addChangeListener(this);
            this.offsetYSlider.setMajorTickSpacing(50);
            this.offsetYSlider.setMinorTickSpacing(10);
            this.offsetYSlider.setPaintTicks(true);
            this.offsetYSlider.setBorder(BorderFactory.createEmptyBorder(0, 5, 10, 5));
            this.presetsLabel = new JLabel("Presets:", 0);
            this.presetsLabel.setAlignmentX(0.5f);
            this.presets = new JComboBox<String>(new String[]{"Custom", "Top View", "Helmet", "Platebody", "Ring", "Amulet", "Kite Shield", "Square Shield", "Platelegs", "Boots", "Scimitar", "Whip", "Claws", "Dragon Claws", "Defender"});
            this.presets.addActionListener(this);
            this.innerToolBox.add(this.presetsLabel);
            this.innerToolBox.add(this.presets);
            this.innerToolBox.add(this.b1);
            this.toolBox.add(this.xRotSliderLabel);
            this.toolBox.add(this.rotationXSlider);
            this.toolBox.add(this.yRotSliderLabel);
            this.toolBox.add(this.rotationYSlider);
            this.toolBox.add(this.zoomSliderLabel);
            this.toolBox.add(this.zoomSlider);
            this.toolBox.add(this.xOffSliderLabel);
            this.toolBox.add(this.offsetXSlider);
            this.toolBox.add(this.yOffSliderLabel);
            this.toolBox.add(this.offsetYSlider);
            this.toolBox.add(this.innerToolBox);
            this.frame.getContentPane().add((Component)this.gamePanel, "West");
            this.frame.getContentPane().add((Component)this.toolBox, "East");
            this.frame.pack();
            this.frame.setLocationRelativeTo(null);
            this.frame.setVisible(true);
            this.frame.setResizable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.presets.setSelectedIndex(0);
        this.updateModel();
    }

    public void updateModel() {
        ItemDefinition iDef = ItemDefinition.get(this.getItemID());
        iDef.rotationX = this.rotationXSlider.getValue();
        iDef.rotationY = this.rotationYSlider.getValue();
        iDef.modelZoom = this.zoomSlider.getValue();
        iDef.rotationZ = this.offsetXSlider.getValue();
        iDef.modelOffsetY = this.offsetYSlider.getValue();
        this.xRotSliderLabel.setText("X-Axis Rotation (" + iDef.rotationX + ")");
        this.yRotSliderLabel.setText("Y-Axis Rotation (" + iDef.rotationY + ")");
        this.zoomSliderLabel.setText("Z-Axis Zoom (" + iDef.modelZoom + ")");
        this.xOffSliderLabel.setText("X Offset (" + iDef.rotationZ + ")");
        this.yOffSliderLabel.setText("Y Offset (" + iDef.modelOffsetY + ")");
        this.gamePanel.repaint();
    }

    public void loadModel(int id) {
        ItemDefinition iDef = ItemDefinition.get(id);
        this.itemId = id;
        int rotX = iDef.rotationX;
        int rotY = iDef.rotationY;
        int zoom = iDef.modelZoom;
        int offX = iDef.rotationZ;
        int offY = iDef.modelOffsetY;
        this.rotationXSlider.setValue(rotX);
        this.rotationYSlider.setValue(rotY);
        this.zoomSlider.setValue(zoom);
        this.offsetXSlider.setValue(offX);
        this.offsetYSlider.setValue(offY);
        this.selected = false;
        this.updateModel();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("export")) {
            try {
                this.exportValues();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (evt.getSource() instanceof JComboBox) {
            int idx = ((JComboBox)evt.getSource()).getSelectedIndex();
            switch (idx) {
                case 1: {
                    this.rotationXSlider.setValue(520);
                    this.rotationYSlider.setValue(0);
                    this.zoomSlider.setValue(1740);
                    this.offsetXSlider.setValue(0);
                    this.offsetYSlider.setValue(0);
                    break;
                }
                case 2: {
                    this.rotationXSlider.setValue(160);
                    this.rotationYSlider.setValue(152);
                    this.zoomSlider.setValue(800);
                    this.offsetXSlider.setValue(-1);
                    this.offsetYSlider.setValue(6);
                    break;
                }
                case 3: {
                    this.rotationXSlider.setValue(452);
                    this.rotationYSlider.setValue(0);
                    this.zoomSlider.setValue(1180);
                    this.offsetXSlider.setValue(-1);
                    this.offsetYSlider.setValue(-1);
                    break;
                }
                case 4: {
                    this.rotationXSlider.setValue(322);
                    this.rotationYSlider.setValue(135);
                    this.zoomSlider.setValue(830);
                    this.offsetXSlider.setValue(-1);
                    this.offsetYSlider.setValue(1);
                    break;
                }
                case 5: {
                    this.rotationXSlider.setValue(424);
                    this.rotationYSlider.setValue(68);
                    this.zoomSlider.setValue(620);
                    this.offsetXSlider.setValue(1);
                    this.offsetYSlider.setValue(16);
                    break;
                }
                case 6: {
                    this.rotationXSlider.setValue(344);
                    this.rotationYSlider.setValue(1104);
                    this.zoomSlider.setValue(1560);
                    this.offsetXSlider.setValue(-6);
                    this.offsetYSlider.setValue(-14);
                    break;
                }
                case 7: {
                    this.rotationXSlider.setValue(268);
                    this.rotationYSlider.setValue(60);
                    this.zoomSlider.setValue(1410);
                    this.offsetXSlider.setValue(2);
                    this.offsetYSlider.setValue(174);
                    break;
                }
                case 8: {
                    this.rotationXSlider.setValue(444);
                    this.rotationYSlider.setValue(0);
                    this.zoomSlider.setValue(1740);
                    this.offsetXSlider.setValue(0);
                    this.offsetYSlider.setValue(-8);
                    break;
                }
                case 9: {
                    this.rotationXSlider.setValue(152);
                    this.rotationYSlider.setValue(160);
                    this.zoomSlider.setValue(770);
                    this.offsetXSlider.setValue(1);
                    this.offsetYSlider.setValue(-6);
                    break;
                }
                case 10: {
                    this.rotationXSlider.setValue(456);
                    this.rotationYSlider.setValue(12);
                    this.zoomSlider.setValue(1640);
                    this.offsetXSlider.setValue(0);
                    this.offsetYSlider.setValue(6);
                    break;
                }
                case 11: {
                    this.rotationXSlider.setValue(280);
                    this.rotationYSlider.setValue(0);
                    this.zoomSlider.setValue(840);
                    this.offsetXSlider.setValue(-2);
                    this.offsetYSlider.setValue(56);
                    break;
                }
                case 12: {
                    this.rotationXSlider.setValue(268);
                    this.rotationYSlider.setValue(1340);
                    this.zoomSlider.setValue(630);
                    this.offsetXSlider.setValue(-7);
                    this.offsetYSlider.setValue(-13);
                    break;
                }
                case 13: {
                    this.rotationXSlider.setValue(239);
                    this.rotationYSlider.setValue(70);
                    this.zoomSlider.setValue(836);
                    this.offsetXSlider.setValue(-2);
                    this.offsetYSlider.setValue(-40);
                    break;
                }
                case 14: {
                    this.rotationXSlider.setValue(344);
                    this.rotationYSlider.setValue(192);
                    this.zoomSlider.setValue(490);
                    this.offsetXSlider.setValue(1);
                    this.offsetYSlider.setValue(20);
                    break;
                }
            }
        } else if (evt.getSource() instanceof JMenuItem) {
            String id;
            JMenuItem item = (JMenuItem)evt.getSource();
            if (item == this.menuItem1) {
                String id2 = JOptionPane.showInputDialog(null, "Enter the item ID you want to calibrate:", this.getItemID() + "");
                if (id2 != null) {
                    try {
                        this.loadModel(Integer.parseInt(id2));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Invalid Item ID. Please try again.", "Error", 1);
                    }
                }
            } else if (item == this.menuItem3) {
                String id3 = JOptionPane.showInputDialog(null, "Enter the X-Axis Rotation:", this.rotationXSlider.getValue() + "");
                if (id3 != null) {
                    try {
                        this.rotationXSlider.setValue(Integer.parseInt(id3));
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "Invalid rotation. Please try again.", "Error", 1);
                    }
                }
            } else if (item == this.menuItem4) {
                String id4 = JOptionPane.showInputDialog(null, "Enter the Y-Axis Rotation:", this.rotationYSlider.getValue() + "");
                if (id4 != null) {
                    try {
                        this.rotationYSlider.setValue(Integer.parseInt(id4));
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "Invalid rotation. Please try again.", "Error", 1);
                    }
                }
            } else if (item == this.menuItem5) {
                String id5 = JOptionPane.showInputDialog(null, "Enter the Z-Axis Zoom:", this.zoomSlider.getValue() + "");
                if (id5 != null) {
                    try {
                        this.zoomSlider.setValue(Integer.parseInt(id5));
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "Invalid zoom. Please try again.", "Error", 1);
                    }
                }
            } else if (item == this.menuItem6) {
                String id6 = JOptionPane.showInputDialog(null, "Enter the X Offset:", this.offsetXSlider.getValue() + "");
                if (id6 != null) {
                    try {
                        this.offsetXSlider.setValue(Integer.parseInt(id6));
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "Invalid offset. Please try again.", "Error", 1);
                    }
                }
            } else if (item == this.menuItem7 && (id = JOptionPane.showInputDialog(null, "Enter the Y Offset:", this.offsetYSlider.getValue() + "")) != null) {
                try {
                    this.offsetYSlider.setValue(Integer.parseInt(id));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Invalid offset. Please try again.", "Error", 1);
                }
            }
        }
    }

    private void exportValues() throws IOException {
        File file = new File("exported.txt");
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter("exported.txt", true));
        writer.newLine();
        writer.newLine();
        writer.write("ItemID: " + this.itemId);
        writer.write("\nitemDef.rotationX = " + this.rotationXSlider.getValue() + ";");
        writer.write("\nitemDef.rotationY = " + this.rotationYSlider.getValue() + ";");
        writer.write("\nitemDef.modelZoom = " + this.zoomSlider.getValue() + ";");
        writer.write("\nitemDef.offsetX = " + this.offsetXSlider.getValue() + ";");
        writer.write("\nitemDef.offsetY = " + this.offsetYSlider.getValue() + ";");
        writer.close();
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        this.saveClickX = ev.getX();
        this.saveClickY = ev.getY();
        if (ev.isPopupTrigger()) {
            this.rightClickMenu.show(ev.getComponent(), this.saveClickX, this.saveClickY);
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (ev.isPopupTrigger()) {
            this.rightClickMenu.show(ev.getComponent(), this.saveClickX, this.saveClickY);
            this.saveClickX = -1;
            this.saveClickY = -1;
        }
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        this.selected = this.saveClickX >= 40 && this.saveClickX <= 82 && this.saveClickY >= 70 && this.saveClickY <= 102 ? !this.selected : false;
        this.updateModel();
        this.saveClickX = -1;
        this.saveClickY = -1;
    }

    @Override
    public void mouseExited(MouseEvent ev) {
        this.x = -1;
        this.y = -1;
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
        this.x = ev.getX();
        this.y = ev.getY();
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        int differenceX = ev.getXOnScreen() - this.saveClickX;
        int differenceY = ev.getYOnScreen() - this.saveClickY;
    }
}

