/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.world;

import org.necrotic.client.Client;
import org.necrotic.client.io.ByteBuffer;

public final class Texture {
    private static Texture[] cache = new Texture[678];
    public final int[][] mipmaps = new int[8][];
    private static double brightness;

    private Texture() {
    }

    public static final Texture get(int index) {
        if (index < 0 || index >= cache.length) {
            return null;
        }
        if (cache[index] == null) {
            Client.instance.onDemandFetcher.requestFileData(4, index);
            return null;
        }
        return cache[index];
    }

    public static final void decode(int index, byte[] data) {
        Texture texture = Texture.cache[index] = new Texture();
        ByteBuffer buffer = new ByteBuffer(data);
        int width = buffer.getShort();
        int height = buffer.getShort();
        texture.mipmaps[0] = new int[16384];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = buffer.getTribyte();
                if (width <= 64 && height <= 64) {
                    int x_ = x << 1;
                    int y_ = y << 1;
                    texture.set(x_, y_, rgb);
                    texture.set(x_ + 1, y_, rgb);
                    texture.set(x_ + 1, y_ + 1, rgb);
                    texture.set(x_, y_ + 1, rgb);
                    continue;
                }
                texture.set(x, y, rgb);
            }
        }
        texture.generate();
    }

    public static void setBrightness(double value) {
        brightness = value;
    }

    private void set(int x, int y, int rgb) {
        if (x < 128 && y < 128) {
            this.mipmaps[0][x + (y << 7)] = Texture.adjustBrightness(rgb, brightness / 1.25);
        }
    }

    private static int adjustBrightness(int rgb, double brightness) {
        int r = (int)(Math.pow((double)(rgb >>> 16) / 256.0, brightness) * 256.0) << 16;
        int g2 = (int)(Math.pow((double)(rgb >>> 8 & 0xFF) / 256.0, brightness) * 256.0) << 8;
        int b = (int)(Math.pow((double)(rgb & 0xFF) / 256.0, brightness) * 256.0);
        return r | g2 | b;
    }

    private void generate() {
        int size = 64;
        for (int level = 1; level < 8; ++level) {
            int[] src = this.mipmaps[level - 1];
            this.mipmaps[level] = new int[size * size];
            int[] dst = this.mipmaps[level];
            for (int x = 0; x < size; ++x) {
                for (int y = 0; y < size; ++y) {
                    double r = 0.0;
                    double g2 = 0.0;
                    double b = 0.0;
                    int count = 0;
                    for (int rgb : new int[]{src[x + (y * size << 1) << 1], src[(x + (y * size << 1) << 1) + 1], src[(x + (y * size << 1) << 1) + (size << 1)], src[(x + (y * size << 1) << 1) + (size << 1) + 1]}) {
                        if (rgb == 0) continue;
                        double dr = (double)(rgb >> 16 & 0xFF) / 255.0;
                        double dg = (double)(rgb >> 8 & 0xFF) / 255.0;
                        double db = (double)(rgb & 0xFF) / 255.0;
                        r += dr * dr;
                        g2 += dg * dg;
                        b += db * db;
                        ++count;
                    }
                    if (count == 0) continue;
                    int ri = Math.round(255.0f * (float)Math.sqrt(r / (double)count));
                    int gi = Math.round(255.0f * (float)Math.sqrt(g2 / (double)count));
                    int bi = Math.round(255.0f * (float)Math.sqrt(b / (double)count));
                    dst[x + y * size] = ri << 16 | gi << 8 | bi;
                }
            }
            size >>= 1;
        }
    }

    public static final void reset() {
        cache = null;
    }

    public static double getBrightness() {
        return brightness;
    }
}

