/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.xoetrope.editor.color;

import java.awt.Color;

public class ModelColor {
    public static final int NUM_COLOR_RINGS = 7;
    public static final int NUM_SEGMENTS = 24;
    protected boolean webSnap = false;
    private static ModelColor[][] baseColors;
    protected int R;
    protected int G;
    protected int B;
    protected double H;
    protected double S;
    protected double V;
    protected double rgbMinValue;
    protected double rgbMaxValue;
    public static double[] SATURATION_BANDS;
    public static double[] BRIGHTNESS_BANDS;

    public ModelColor(int R, int G, int B) {
        this(R, G, B, -1);
    }

    public ModelColor(double H, double S, double V) {
        this.setHSV(H, S, V);
    }

    public ModelColor(int R, int G, int B, int H) {
        ModelColor.initColorWheel();
        this.setRGB(R, G, B, H);
    }

    public ModelColor(ModelColor c) {
        ModelColor.initColorWheel();
        this.R = c.R;
        this.G = c.G;
        this.B = c.B;
        this.H = c.H;
        this.S = c.S;
        this.V = c.V;
        this.getRgbMinMaxValues();
    }

    public int getRed() {
        return this.R;
    }

    public int getGreen() {
        return this.G;
    }

    public int getBlue() {
        return this.B;
    }

    public int getHue() {
        return (int)Math.floor(this.H + 0.5);
    }

    public double getH() {
        return this.H;
    }

    public double getSaturation() {
        return this.S;
    }

    public double getBrightness() {
        return this.V;
    }

    public void setRGB(int R, int G, int B) {
        this.setRGB(R, G, B, -1);
    }

    public void setRGB(int r, int g2, int b, int h2) {
        if (this.webSnap) {
            this.R = Math.round(r / 51) * 51;
            this.G = Math.round(g2 / 51) * 51;
            this.B = Math.round(b / 51) * 51;
        } else {
            this.R = r;
            this.G = g2;
            this.B = b;
        }
        this.checkRange();
        this.getRgbMinMaxValues();
        if (h2 > -1) {
            this.H = h2;
            this.S = this.rgbMaxValue > 0.0 ? (this.rgbMaxValue - this.rgbMinValue) / this.rgbMaxValue : 0.0;
            this.V = this.rgbMaxValue / 255.0;
        } else if (this.R == this.G && this.G == this.B) {
            this.H = 0.0;
            this.S = 0.0;
            this.V = this.rgbMaxValue / 255.0;
        } else {
            this.calculateHSVfromRGB();
        }
    }

    public void setHSV(double _h, double _s, double _v) {
        if (Math.abs(this.H - _h) > 0.499999) {
            this.H = _h;
        }
        if (Math.abs(this.S - _s) > 0.009999) {
            this.S = _s;
        }
        if (Math.abs(this.V - _v) > 0.009999) {
            this.V = _v;
        }
        if (this.S > 1.0 || this.S < 0.0) {
            double d = this.S = this.S < 0.0 ? 0.0 : 1.0;
        }
        if (this.V > 1.0 || this.V < 0.0) {
            this.V = this.V < 0.0 ? 0.0 : 1.0;
        }
        this.calculateRGBfromHSV();
    }

    private void checkRange() {
        if (this.R > 255) {
            this.R = 255;
        }
        if (this.G > 255) {
            this.G = 255;
        }
        if (this.B > 255) {
            this.B = 255;
        }
        if (this.webSnap) {
            this.R = Math.round(this.R / 51) * 51;
            this.G = Math.round(this.G / 51) * 51;
            this.B = Math.round(this.B / 51) * 51;
        }
    }

    private void getRgbMinMaxValues() {
        this.rgbMaxValue = Math.max(Math.max(this.R, this.G), this.B);
        this.rgbMinValue = Math.min(Math.min(this.R, this.G), this.B);
    }

    private void calculateHSVfromRGB() {
        boolean exactMatch = false;
        block0: for (int j = 0; j < 7; ++j) {
            if (j == 6) {
                j = 6;
            }
            for (int i = 0; i < 360; i += 15) {
                ModelColor c = baseColors[i / 15][j];
                if (this.R != c.R || this.G != c.G || this.B != c.B) continue;
                exactMatch = true;
                this.H = c.H;
                this.S = this.rgbMaxValue > 0.0 ? 1.0 * (this.rgbMaxValue - this.rgbMinValue) / this.rgbMaxValue : 0.0;
                this.V = this.rgbMaxValue / 255.0;
                break block0;
            }
        }
        if (!exactMatch) {
            float[] values = new float[3];
            values = Color.RGBtoHSB(this.R, this.G, this.B, values);
            float h2 = values[0];
            this.S = this.rgbMaxValue > 0.0 ? 1.0 * (this.rgbMaxValue - this.rgbMinValue) / this.rgbMaxValue : 0.0;
            this.V = this.rgbMaxValue / 255.0;
            if (h2 < 0.1666668f) {
                h2 *= 2.0f;
            } else if (h2 < 0.3333334f) {
                h2 += 0.1666667f;
            } else if (h2 < 0.6666668f) {
                h2 += 0.1666667f * ((0.6666667f - h2) / 0.3333334f);
            }
            this.H = 360.0 * (double)h2;
        }
    }

    private void calculateRGBfromHSV() {
        double h2 = this.H / 360.0;
        if (h2 < 0.3333334) {
            h2 /= 2.0;
        } else if (h2 < 0.5000001) {
            h2 -= 0.1666667;
        } else if (h2 < 0.6666668) {
            h2 = 2.0 * h2 - 0.6666667;
        }
        Color c = new Color(Color.HSBtoRGB((float)h2, (float)this.S, (float)this.V));
        this.R = c.getRed();
        this.G = c.getGreen();
        this.B = c.getBlue();
        this.checkRange();
        this.getRgbMinMaxValues();
    }

    public void rotate(int angle) {
        if (this.S > 0.0 && this.V > 0.0) {
            double newHue = (this.H + (double)angle) % 360.0;
            this.setHSV(newHue, this.S, this.V);
        }
    }

    public void setWebSnap(boolean snapTo) {
        this.webSnap = snapTo;
    }

    public static String dec2hex(int n) {
        String s2 = Integer.toHexString(n);
        if (s2.length() < 2) {
            s2 = "0" + s2;
        }
        return s2.toUpperCase();
    }

    public static int hex2dec(String n) {
        if (n.length() == 0) {
            return 0;
        }
        return Integer.parseInt(n, 16);
    }

    public static String toHexString(int value) {
        String hex = Integer.toHexString(value).toUpperCase();
        if (hex.length() < 2) {
            return "0" + hex;
        }
        return hex;
    }

    public static String col2Gray(double r, double g2, double b) {
        double lum = Math.round(r * 0.299 + g2 * 0.587 + b * 0.114);
        return ModelColor.dec2hex((int)lum) + ModelColor.dec2hex((int)lum) + ModelColor.dec2hex((int)lum);
    }

    public static ModelColor[][] getBaseColors() {
        ModelColor.initColorWheel();
        return baseColors;
    }

    private static void initColorWheel() {
        if (baseColors == null) {
            baseColors = new ModelColor[24][7];
            for (int i = 0; i < 7; ++i) {
                for (int j = 0; j < 24; ++j) {
                    ModelColor.baseColors[j][i] = new ModelColor(15.0 * (double)j, SATURATION_BANDS[i], BRIGHTNESS_BANDS[i + 1 - j % 2]);
                }
            }
        }
    }

    static {
        SATURATION_BANDS = new double[]{0.4, 0.6, 0.8, 1.0, 1.0, 1.0, 1.0};
        BRIGHTNESS_BANDS = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 0.85, 0.65, 0.45};
    }
}

