/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceTitlePaneUtilities {
    public static final String EXTRA_COMPONENT_KIND = "substancelaf.internal.titlePane.extraComponentKind";

    public static ExtraComponentKind getTitlePaneControlButtonKind(JRootPane rootPane) {
        SubstanceSlices.HorizontalGravity controlButtonGroupGravity = SubstanceTitlePaneUtilities.getTitleControlButtonGroupHorizontalGravity(rootPane);
        switch (controlButtonGroupGravity) {
            case LEADING: {
                return ExtraComponentKind.LEADING;
            }
            case TRAILING: 
            case SWING_DEFAULT: {
                return ExtraComponentKind.TRAILING;
            }
        }
        SubstanceCoreUtilities.Platform platform = SubstanceCoreUtilities.getPlatform();
        switch (platform) {
            case MACOS: {
                return ExtraComponentKind.LEADING;
            }
        }
        return ExtraComponentKind.TRAILING;
    }

    public static SubstanceSlices.HorizontalGravity getTitleTextHorizontalGravity() {
        Object globalProperty = UIManager.get("substancelaf.internal.titleTextHorizontalGravity");
        if (globalProperty instanceof SubstanceSlices.HorizontalGravity) {
            return (SubstanceSlices.HorizontalGravity)((Object)globalProperty);
        }
        return SubstanceSlices.HorizontalGravity.SWING_DEFAULT;
    }

    public static SubstanceSlices.TitleIconHorizontalGravity getTitleIconHorizontalGravity() {
        Object globalProperty = UIManager.get("substancelaf.internal.titleIconHorizontalGravity");
        if (globalProperty instanceof SubstanceSlices.TitleIconHorizontalGravity) {
            return (SubstanceSlices.TitleIconHorizontalGravity)((Object)globalProperty);
        }
        return SubstanceSlices.TitleIconHorizontalGravity.SWING_DEFAULT;
    }

    public static SubstanceSlices.HorizontalGravity getTitleControlButtonGroupHorizontalGravity(JRootPane rootPane) {
        Object rootPaneProperty;
        Object object = rootPaneProperty = rootPane == null ? null : rootPane.getClientProperty("substancelaf.internal.titleControlButtonGroupHorizontalGravity");
        if (rootPaneProperty instanceof SubstanceSlices.HorizontalGravity) {
            return (SubstanceSlices.HorizontalGravity)((Object)rootPaneProperty);
        }
        Object globalProperty = UIManager.get("substancelaf.internal.titleControlButtonGroupHorizontalGravity");
        if (globalProperty instanceof SubstanceSlices.HorizontalGravity) {
            return (SubstanceSlices.HorizontalGravity)((Object)globalProperty);
        }
        return SubstanceSlices.HorizontalGravity.SWING_DEFAULT;
    }

    public static SubstanceSlices.VerticalGravity getTitleControlButtonGroupVerticalGravity(JRootPane rootPane) {
        Object rootPaneProperty;
        Object object = rootPaneProperty = rootPane == null ? null : rootPane.getClientProperty("substancelaf.internal.titleControlButtonGroupVerticalGravity");
        if (rootPaneProperty instanceof SubstanceSlices.VerticalGravity) {
            return (SubstanceSlices.VerticalGravity)((Object)rootPaneProperty);
        }
        Object globalProperty = UIManager.get("substancelaf.internal.titleControlButtonGroupVerticalGravity");
        if (globalProperty instanceof SubstanceSlices.HorizontalGravity) {
            return (SubstanceSlices.VerticalGravity)((Object)globalProperty);
        }
        return SubstanceSlices.VerticalGravity.CENTERED;
    }

    public static boolean areTitlePaneControlButtonsOnRight(JRootPane rootPane) {
        boolean isLtr = rootPane.getComponentOrientation().isLeftToRight();
        SubstanceSlices.HorizontalGravity controlButtonGroupGravity = SubstanceTitlePaneUtilities.getTitleControlButtonGroupHorizontalGravity(rootPane);
        switch (controlButtonGroupGravity) {
            case LEADING: {
                return !isLtr;
            }
            case TRAILING: 
            case SWING_DEFAULT: {
                return isLtr;
            }
        }
        SubstanceCoreUtilities.Platform platform = SubstanceCoreUtilities.getPlatform();
        switch (platform) {
            case MACOS: {
                return !isLtr;
            }
        }
        return isLtr;
    }

    public static SubstanceSlices.HorizontalGravity getTitlePaneTextGravity() {
        SubstanceSlices.HorizontalGravity titleTextGravity = SubstanceCortex.GlobalScope.getTitleTextHorizontalGravity();
        switch (titleTextGravity) {
            case LEADING: 
            case TRAILING: 
            case CENTERED: {
                return titleTextGravity;
            }
            case SWING_DEFAULT: {
                return SubstanceSlices.HorizontalGravity.LEADING;
            }
        }
        SubstanceCoreUtilities.Platform platform = SubstanceCoreUtilities.getPlatform();
        switch (platform) {
            case WINDOWS: {
                return SubstanceSlices.HorizontalGravity.LEADING;
            }
        }
        return SubstanceSlices.HorizontalGravity.CENTERED;
    }

    public static SubstanceSlices.TitleIconHorizontalGravity getTitlePaneIconGravity() {
        SubstanceSlices.TitleIconHorizontalGravity iconGravity = SubstanceCortex.GlobalScope.getTitleIconHorizontalGravity();
        switch (iconGravity) {
            case NONE: 
            case OPPOSITE_CONTROL_BUTTONS: 
            case NEXT_TO_TITLE: {
                return iconGravity;
            }
            case SWING_DEFAULT: {
                return SubstanceSlices.TitleIconHorizontalGravity.OPPOSITE_CONTROL_BUTTONS;
            }
        }
        SubstanceCoreUtilities.Platform platform = SubstanceCoreUtilities.getPlatform();
        switch (platform) {
            case MACOS: {
                return SubstanceSlices.TitleIconHorizontalGravity.NEXT_TO_TITLE;
            }
            case GNOME: {
                return SubstanceSlices.TitleIconHorizontalGravity.NONE;
            }
        }
        return SubstanceSlices.TitleIconHorizontalGravity.OPPOSITE_CONTROL_BUTTONS;
    }

    public static void markTitlePaneExtraComponent(JComponent comp, ExtraComponentKind kind) {
        comp.putClientProperty(EXTRA_COMPONENT_KIND, (Object)kind);
    }

    public static Rectangle getTitlePaneTextRectangle(JComponent titlePane, Component rootComponent) {
        boolean leftToRight = rootComponent.getComponentOrientation().isLeftToRight();
        if (leftToRight) {
            int maxLeadingX = 0;
            int minTrailingX = titlePane.getWidth();
            int extraWidthTaken = 0;
            block8: for (int i = 0; i < titlePane.getComponentCount(); ++i) {
                Component child = titlePane.getComponent(i);
                if (!child.isVisible() || !(child instanceof JComponent)) continue;
                ExtraComponentKind kind = (ExtraComponentKind)((Object)((JComponent)child).getClientProperty(EXTRA_COMPONENT_KIND));
                if (kind == null) {
                    throw new IllegalStateException("Title pane child " + child.getClass().getName() + " is not marked as leading or trailing");
                }
                switch (kind) {
                    case LEADING: {
                        int childRight = child.getX() + child.getWidth();
                        if (childRight <= maxLeadingX) continue block8;
                        maxLeadingX = childRight;
                        continue block8;
                    }
                    case TRAILING: {
                        int childLeft = child.getX();
                        if (childLeft >= minTrailingX) continue block8;
                        minTrailingX = childLeft;
                        continue block8;
                    }
                    default: {
                        extraWidthTaken += child.getWidth();
                    }
                }
            }
            int start = maxLeadingX + 5 + extraWidthTaken;
            int end = minTrailingX - 5;
            return new Rectangle(start, 0, end - start, titlePane.getHeight());
        }
        int minLeadingX = titlePane.getWidth();
        int maxTrailingX = 0;
        int extraWidthTaken = 0;
        block9: for (int i = 0; i < titlePane.getComponentCount(); ++i) {
            Component child = titlePane.getComponent(i);
            if (!child.isVisible() || !(child instanceof JComponent)) continue;
            ExtraComponentKind kind = (ExtraComponentKind)((Object)((JComponent)child).getClientProperty(EXTRA_COMPONENT_KIND));
            if (kind == null) {
                throw new IllegalStateException("Title pane child " + child.getClass().getName() + " is not marked as leading or trailing");
            }
            switch (kind) {
                case LEADING: {
                    int childLeft = child.getX();
                    if (childLeft >= minLeadingX) continue block9;
                    minLeadingX = childLeft;
                    continue block9;
                }
                case TRAILING: {
                    int childRight = child.getX() + child.getWidth();
                    if (childRight <= maxTrailingX) continue block9;
                    maxTrailingX = childRight;
                    continue block9;
                }
                default: {
                    extraWidthTaken += child.getWidth();
                }
            }
        }
        int start = maxTrailingX + 5;
        int end = minLeadingX - 5 - extraWidthTaken;
        return new Rectangle(start, 0, end - start, titlePane.getHeight());
    }

    public static enum ExtraComponentKind {
        LEADING,
        TRAILING,
        WITH_TITLE;

    }
}

