/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.applet.Applet;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import net.runelite.client.config.ChatColorConfig;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.task.Scheduler;
import net.runelite.client.util.DeferredEventBus;
import net.runelite.client.util.ExecutorServiceExceptionLogger;
import org.necrotic.client.Client;

public class RuneLiteModule
extends AbstractModule {
    private final Supplier<Applet> clientLoader;
    private final boolean developerMode;
    private final File config;

    public RuneLiteModule(Supplier<Applet> clientLoader, boolean developerMode, File config) {
        this.clientLoader = clientLoader;
        this.developerMode = developerMode;
        this.config = config;
    }

    @Override
    protected void configure() {
        this.bindConstant().annotatedWith(Names.named("developerMode")).to(this.developerMode);
        this.bind(File.class).annotatedWith(Names.named("config")).toInstance(this.config);
        this.bind(ScheduledExecutorService.class).toInstance(new ExecutorServiceExceptionLogger(Executors.newSingleThreadScheduledExecutor()));
        this.bind(Scheduler.class);
        this.bind(PluginManager.class);
        this.bind(EventBus.class).toInstance(new EventBus());
        this.bind(EventBus.class).annotatedWith(Names.named("Deferred EventBus")).to(DeferredEventBus.class);
    }

    @Provides
    @Singleton
    Applet provideApplet() {
        return this.clientLoader.get();
    }

    @Provides
    @Singleton
    Client provideClient(@Nullable Applet applet) {
        return applet instanceof Client ? (Client)applet : null;
    }

    @Provides
    @Singleton
    RuneLiteConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(RuneLiteConfig.class);
    }

    @Provides
    @Singleton
    ChatColorConfig provideChatColorConfig(ConfigManager configManager) {
        return configManager.getConfig(ChatColorConfig.class);
    }
}

