/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.input;

import java.awt.event.KeyEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.input.KeyListener;
import net.runelite.client.util.HotkeyListener;
import org.necrotic.client.Client;

@Singleton
public class KeyManager {
    private final Client client;
    private final List<KeyListener> keyListeners = new CopyOnWriteArrayList<KeyListener>();

    @Inject
    private KeyManager(@Nullable Client client) {
        this.client = client;
    }

    public void registerKeyListener(KeyListener keyListener) {
        if (!this.keyListeners.contains(keyListener)) {
            this.keyListeners.add(keyListener);
        }
    }

    public void unregisterKeyListener(KeyListener keyListener) {
        this.keyListeners.remove(keyListener);
    }

    public void processKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        for (KeyListener keyListener : this.keyListeners) {
            if (!this.shouldProcess(keyListener)) continue;
            keyListener.keyPressed(keyEvent);
            if (!keyEvent.isConsumed()) continue;
            break;
        }
    }

    public void processKeyReleased(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        for (KeyListener keyListener : this.keyListeners) {
            if (!this.shouldProcess(keyListener)) continue;
            keyListener.keyReleased(keyEvent);
            if (!keyEvent.isConsumed()) continue;
            break;
        }
    }

    public void processKeyTyped(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        for (KeyListener keyListener : this.keyListeners) {
            if (!this.shouldProcess(keyListener)) continue;
            keyListener.keyTyped(keyEvent);
            if (!keyEvent.isConsumed()) continue;
            break;
        }
    }

    private boolean shouldProcess(KeyListener keyListener) {
        if (this.client == null) {
            return true;
        }
        if (!(keyListener instanceof HotkeyListener)) {
            return true;
        }
        HotkeyListener hotkeyListener = (HotkeyListener)keyListener;
        if (hotkeyListener.isEnabledOnLogin()) {
            return true;
        }
        return Client.loggedIn;
    }
}

