/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.config;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.runelite.client.config.ConfigDescriptor;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigItemDescriptor;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.Keybind;
import net.runelite.client.config.ModifierlessKeybind;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.PluginChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.config.FixedWidthPanel;
import net.runelite.client.plugins.config.HotkeyButton;
import net.runelite.client.plugins.config.PluginConfigurationDescriptor;
import net.runelite.client.plugins.config.PluginListPanel;
import net.runelite.client.plugins.config.PluginToggleButton;
import net.runelite.client.plugins.config.UnitFormatterFactory;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.ComboBoxListRenderer;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(ConfigPanel.class);
    private static final int SPINNER_FIELD_WIDTH = 6;
    static final ImageIcon BACK_ICON;
    static final ImageIcon BACK_ICON_HOVER;
    private final FixedWidthPanel mainPanel;
    private final JLabel title;
    private final PluginToggleButton pluginToggle;
    @Inject
    private PluginListPanel pluginList;
    @Inject
    private ConfigManager configManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private ColorPickerManager colorPickerManager;
    private PluginConfigurationDescriptor pluginConfig = null;

    public ConfigPanel() {
        super(false);
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        topPanel.setLayout(new BorderLayout(0, 6));
        this.add((Component)topPanel, "North");
        this.mainPanel = new FixedWidthPanel();
        this.mainPanel.setBorder(new EmptyBorder(8, 10, 10, 10));
        this.mainPanel.setLayout(new DynamicGridLayout(0, 1, 0, 5));
        this.mainPanel.setAlignmentX(0.0f);
        FixedWidthPanel northPanel = new FixedWidthPanel();
        northPanel.setLayout(new BorderLayout());
        northPanel.add((Component)this.mainPanel, "North");
        JScrollPane scrollPane = new JScrollPane(northPanel);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)scrollPane, "Center");
        JButton topPanelBackButton = new JButton(BACK_ICON);
        topPanelBackButton.setRolloverIcon(BACK_ICON_HOVER);
        SwingUtil.removeButtonDecorations(topPanelBackButton);
        topPanelBackButton.setPreferredSize(new Dimension(22, 0));
        topPanelBackButton.setBorder(new EmptyBorder(0, 0, 0, 5));
        topPanelBackButton.addActionListener(e -> this.pluginList.getMuxer().popState());
        topPanelBackButton.setToolTipText("Back");
        topPanel.add((Component)topPanelBackButton, "West");
        this.pluginToggle = new PluginToggleButton();
        topPanel.add((Component)this.pluginToggle, "East");
        this.title = new JLabel();
        this.title.setForeground(Color.WHITE);
        topPanel.add(this.title);
    }

    void init(PluginConfigurationDescriptor pluginConfig) {
        assert (this.pluginConfig == null);
        this.pluginConfig = pluginConfig;
        String name = pluginConfig.getName();
        this.title.setText(name);
        this.title.setForeground(Color.WHITE);
        this.title.setToolTipText("<html>" + name + ":<br>" + pluginConfig.getDescription() + "</html>");
        if (pluginConfig.getPlugin() != null) {
            this.pluginToggle.setSelected(this.pluginManager.isPluginEnabled(pluginConfig.getPlugin()));
            this.pluginToggle.addItemListener(i -> {
                if (this.pluginToggle.isSelected()) {
                    this.pluginList.startPlugin(pluginConfig.getPlugin());
                } else {
                    this.pluginList.stopPlugin(pluginConfig.getPlugin());
                }
            });
        } else {
            this.pluginToggle.setVisible(false);
        }
        this.rebuild();
    }

    private void rebuild() {
        this.mainPanel.removeAll();
        final ConfigDescriptor cd2 = this.pluginConfig.getConfigDescriptor();
        for (final ConfigItemDescriptor cid : cd2.getItems()) {
            if (cid.getItem().hidden()) continue;
            JPanel item = new JPanel();
            item.setLayout(new BorderLayout());
            item.setMinimumSize(new Dimension(225, 0));
            String name = cid.getItem().name();
            JLabel configEntryName = new JLabel(name);
            configEntryName.setForeground(Color.WHITE);
            configEntryName.setToolTipText("<html>" + name + ":<br>" + cid.getItem().description() + "</html>");
            item.add((Component)configEntryName, "Center");
            if (cid.getType() == Boolean.TYPE) {
                JCheckBox checkbox = new JCheckBox();
                checkbox.setBackground(ColorScheme.LIGHT_GRAY_COLOR);
                checkbox.setSelected(Boolean.parseBoolean(this.configManager.getConfiguration(cd2.getGroup().value(), cid.getItem().keyName())));
                checkbox.addActionListener(ae -> this.changeConfiguration(checkbox, cd2, cid));
                item.add((Component)checkbox, "East");
            }
            if (cid.getType() == Integer.TYPE) {
                int value = Integer.parseInt(this.configManager.getConfiguration(cd2.getGroup().value(), cid.getItem().keyName()));
                Range range = cid.getRange();
                int min2 = 0;
                int max = Integer.MAX_VALUE;
                if (range != null) {
                    min2 = range.min();
                    max = range.max();
                }
                value = Ints.constrainToRange(value, min2, max);
                SpinnerNumberModel model = new SpinnerNumberModel(value, min2, max, 1);
                JSpinner spinner = new JSpinner(model);
                JComponent editor = spinner.getEditor();
                JFormattedTextField spinnerTextField = ((JSpinner.DefaultEditor)editor).getTextField();
                spinnerTextField.setColumns(6);
                spinner.addChangeListener(ce -> this.changeConfiguration(spinner, cd2, cid));
                Units units = cid.getUnits();
                if (units != null) {
                    spinnerTextField.setFormatterFactory(new UnitFormatterFactory(units));
                }
                item.add((Component)spinner, "East");
            }
            if (cid.getType() == String.class) {
                JTextComponent textField;
                if (cid.getItem().secret()) {
                    textField = new JPasswordField();
                } else {
                    JTextArea textArea = new JTextArea();
                    textArea.setLineWrap(true);
                    textArea.setWrapStyleWord(true);
                    textField = textArea;
                }
                textField.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                textField.setText(this.configManager.getConfiguration(cd2.getGroup().value(), cid.getItem().keyName()));
                textField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        ConfigPanel.this.changeConfiguration(textField, cd2, cid);
                    }
                });
                item.add((Component)textField, "South");
            }
            if (cid.getType() == Color.class) {
                JButton colorPickerBtn;
                Color existingColor;
                String existing = this.configManager.getConfiguration(cd2.getGroup().value(), cid.getItem().keyName());
                if (existing == null) {
                    existingColor = Color.BLACK;
                    colorPickerBtn = new JButton("Pick a color");
                } else {
                    existingColor = ColorUtil.fromString(existing);
                    colorPickerBtn = new JButton(ColorUtil.toHexColor(existingColor).toUpperCase());
                }
                colorPickerBtn.setFocusable(false);
                colorPickerBtn.setBackground(existingColor);
                colorPickerBtn.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        RuneliteColorPicker colorPicker = ConfigPanel.this.colorPickerManager.create(SwingUtilities.windowForComponent(ConfigPanel.this), colorPickerBtn.getBackground(), cid.getItem().name(), cid.getAlpha() == null);
                        colorPicker.setLocation(ConfigPanel.this.getLocationOnScreen());
                        colorPicker.setOnColorChange(c -> {
                            colorPickerBtn.setBackground((Color)c);
                            colorPickerBtn.setText(ColorUtil.toHexColor(c).toUpperCase());
                        });
                        colorPicker.setOnClose(c -> ConfigPanel.this.changeConfiguration(colorPicker, cd2, cid));
                        colorPicker.setVisible(true);
                    }
                });
                item.add((Component)colorPickerBtn, "East");
            }
            if (cid.getType() == Dimension.class) {
                JPanel dimensionPanel = new JPanel();
                dimensionPanel.setLayout(new BorderLayout());
                String str = this.configManager.getConfiguration(cd2.getGroup().value(), cid.getItem().keyName());
                String[] splitStr = str.split("x");
                int width = Integer.parseInt(splitStr[0]);
                int height = Integer.parseInt(splitStr[1]);
                SpinnerNumberModel widthModel = new SpinnerNumberModel(width, 0, Integer.MAX_VALUE, 1);
                JSpinner widthSpinner = new JSpinner(widthModel);
                JComponent widthEditor = widthSpinner.getEditor();
                JFormattedTextField widthSpinnerTextField = ((JSpinner.DefaultEditor)widthEditor).getTextField();
                widthSpinnerTextField.setColumns(4);
                SpinnerNumberModel heightModel = new SpinnerNumberModel(height, 0, Integer.MAX_VALUE, 1);
                JSpinner heightSpinner = new JSpinner(heightModel);
                JComponent heightEditor = heightSpinner.getEditor();
                JFormattedTextField heightSpinnerTextField = ((JSpinner.DefaultEditor)heightEditor).getTextField();
                heightSpinnerTextField.setColumns(4);
                ChangeListener listener = e -> this.configManager.setConfiguration(cd2.getGroup().value(), cid.getItem().keyName(), widthSpinner.getValue() + "x" + heightSpinner.getValue());
                widthSpinner.addChangeListener(listener);
                heightSpinner.addChangeListener(listener);
                dimensionPanel.add((Component)widthSpinner, "West");
                dimensionPanel.add((Component)new JLabel(" x "), "Center");
                dimensionPanel.add((Component)heightSpinner, "East");
                item.add((Component)dimensionPanel, "East");
            }
            if (cid.getType().isEnum()) {
                Class<?> type = cid.getType();
                JComboBox box = new JComboBox(type.getEnumConstants());
                box.setPreferredSize(new Dimension(box.getPreferredSize().width, 25));
                box.setRenderer(new ComboBoxListRenderer());
                box.setForeground(Color.WHITE);
                box.setFocusable(false);
                box.setPrototypeDisplayValue("XXXXXXXX");
                try {
                    Object selectedItem = Enum.valueOf(type, this.configManager.getConfiguration(cd2.getGroup().value(), cid.getItem().keyName()));
                    box.setSelectedItem(selectedItem);
                    box.setToolTipText(Text.titleCase(selectedItem));
                }
                catch (IllegalArgumentException ex) {
                    log.debug("invalid seleced item", ex);
                }
                box.addItemListener(e -> {
                    if (e.getStateChange() == 1) {
                        this.changeConfiguration(box, cd2, cid);
                        box.setToolTipText(Text.titleCase((Enum)box.getSelectedItem()));
                    }
                });
                item.add(box, "East");
            }
            if (cid.getType() == Keybind.class || cid.getType() == ModifierlessKeybind.class) {
                Keybind startingValue = (Keybind)this.configManager.getConfiguration(cd2.getGroup().value(), cid.getItem().keyName(), cid.getType());
                final HotkeyButton button = new HotkeyButton(startingValue, cid.getType() == ModifierlessKeybind.class);
                button.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        ConfigPanel.this.changeConfiguration(button, cd2, cid);
                    }
                });
                item.add((Component)button, "East");
            }
            this.mainPanel.add(item);
        }
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(e -> {
            int result = JOptionPane.showOptionDialog(resetButton, "Are you sure you want to reset this plugin's configuration?", "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No");
            if (result == 0) {
                this.configManager.setDefaultConfiguration(this.pluginConfig.getConfig(), true);
                Plugin plugin = this.pluginConfig.getPlugin();
                if (plugin != null) {
                    plugin.resetConfiguration();
                }
                this.rebuild();
            }
        });
        this.mainPanel.add(resetButton);
        JButton backButton = new JButton("Back");
        backButton.addActionListener(e -> this.pluginList.getMuxer().popState());
        this.mainPanel.add(backButton);
        this.revalidate();
    }

    private void changeConfiguration(Component component, ConfigDescriptor cd2, ConfigItemDescriptor cid) {
        int result;
        ConfigItem configItem = cid.getItem();
        if (!Strings.isNullOrEmpty(configItem.warning()) && (result = JOptionPane.showOptionDialog(component, configItem.warning(), "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No")) != 0) {
            this.rebuild();
            return;
        }
        if (component instanceof JCheckBox) {
            JCheckBox checkbox = (JCheckBox)component;
            this.configManager.setConfiguration(cd2.getGroup().value(), cid.getItem().keyName(), "" + checkbox.isSelected());
        } else if (component instanceof JSpinner) {
            JSpinner spinner = (JSpinner)component;
            this.configManager.setConfiguration(cd2.getGroup().value(), cid.getItem().keyName(), "" + spinner.getValue());
        } else if (component instanceof JTextComponent) {
            JTextComponent textField = (JTextComponent)component;
            this.configManager.setConfiguration(cd2.getGroup().value(), cid.getItem().keyName(), textField.getText());
        } else if (component instanceof RuneliteColorPicker) {
            RuneliteColorPicker colorPicker = (RuneliteColorPicker)component;
            this.configManager.setConfiguration(cd2.getGroup().value(), cid.getItem().keyName(), colorPicker.getSelectedColor().getRGB() + "");
        } else if (component instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)component;
            this.configManager.setConfiguration(cd2.getGroup().value(), cid.getItem().keyName(), ((Enum)jComboBox.getSelectedItem()).name());
        } else if (component instanceof HotkeyButton) {
            HotkeyButton hotkeyButton = (HotkeyButton)component;
            this.configManager.setConfiguration(cd2.getGroup().value(), cid.getItem().keyName(), hotkeyButton.getValue());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(242, super.getPreferredSize().height);
    }

    @Subscribe
    public void onPluginChanged(PluginChanged event) {
        if (event.getPlugin() == this.pluginConfig.getPlugin()) {
            SwingUtilities.invokeLater(() -> this.pluginToggle.setSelected(event.isLoaded()));
        }
    }

    static {
        BufferedImage backIcon = ImageUtil.getResourceStreamFromClass(ConfigPanel.class, "config_back_icon.png");
        BACK_ICON = new ImageIcon(backIcon);
        BACK_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)backIcon, -100));
    }
}

