/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.config;

import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.inject.Provider;
import net.runelite.client.config.ChatColorConfig;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.config.PluginConfigurationDescriptor;
import net.runelite.client.plugins.config.PluginListPanel;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Configuration", loadWhenOutdated=true, hidden=true)
public class ConfigPlugin
extends Plugin {
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private Provider<PluginListPanel> pluginListPanelProvider;
    @Inject
    private ConfigManager configManager;
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private ChatColorConfig chatColorConfig;
    private PluginListPanel pluginListPanel;
    private NavigationButton navButton;

    @Override
    protected void startUp() throws Exception {
        this.pluginListPanel = this.pluginListPanelProvider.get();
        this.pluginListPanel.addFakePlugin(new PluginConfigurationDescriptor("RuneLite", "RuneLite client settings", new String[]{"client", "notification", "size", "position", "window", "chrome", "focus", "font", "overlay", "tooltip", "infobox"}, null, this.runeLiteConfig, this.configManager.getConfigDescriptor(this.runeLiteConfig)));
        this.pluginListPanel.rebuildPluginList();
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(this.getClass(), "config_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Configuration").icon(icon).priority(0).panel(this.pluginListPanel.getMuxer()).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    @Override
    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
    }
}

