/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.necrotic.Configuration;
import org.necrotic.client.Client;
import org.necrotic.client.Signlink;

public class CacheDownloader {
    private static final String CACHE_FILE_NAME = "cache.zip";
    private static final String CACHE_URL = "https://avernic.com/ozara/cache.zip";
    private static final String CACHE_URL1 = "https://avernic.com/ozara/cache.zip";
    public static final String URL_TO_LOADING_IMAGES = "https://avernic.com/realms/imgs/";
    public static final String MIRROR_URL_TO_LOADING_IMAGES = "http://avernic.com/ozara/data/img/";
    private static final String NEWEST_VERSION_FILE_URL = "https://avernic.com/ozara/cache_version.txt";
    private static final String CURRENT_VERSION_FILE = "cache_version.txt";
    public static boolean UPDATING = true;

    public static boolean updatedCache() {
        try {
            double newest = CacheDownloader.getNewestVersion();
            double current = CacheDownloader.getCurrentVersion();
            if (CacheDownloader.cacheDownloadRequired(newest, current) || CacheDownloader.forceUpdateCache()) {
                if (CacheDownloader.forceUpdateCache()) {
                    System.out.println("We are localhost, and being forced to update cache.");
                } else {
                    System.out.println("Updated Avernic Cache. No manual overrides detected, proceeding as normal. Current: " + current + ", Newest: " + newest);
                }
                CacheDownloader.downloadCache();
                CacheDownloader.unzipCache();
                CacheDownloader.setLatestCacheVersion(newest);
            }
            UPDATING = true;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            UPDATING = true;
            return false;
        }
    }

    public static boolean forceUpdateCache() {
        if (Configuration.SERVER_HOST().equalsIgnoreCase("localhost")) {
            // empty if block
        }
        return false;
    }

    public static boolean cacheDownloadRequired(double newest, double current) {
        return newest != current;
    }

    public static void downloadCache() throws IOException {
        URL url = new URL("https://avernic.com/ozara/cache.zip");
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.addRequestProperty("User-Agent", "Mozilla/4.76");
        int responseCode = httpConn.getResponseCode();
        if (responseCode != 200) {
            return;
        }
        System.out.println("First cache download");
        if (responseCode == 200) {
            int length;
            String fileName = CACHE_FILE_NAME;
            InputStream inputStream = httpConn.getInputStream();
            String saveFilePath = Signlink.getCacheDirectory() + File.separator + fileName;
            FileOutputStream outputStream = new FileOutputStream(saveFilePath);
            int bytesRead = -1;
            byte[] buffer = new byte[4096];
            long startTime = System.currentTimeMillis();
            int downloaded = 0;
            long numWritten = 0L;
            if (httpConn.getContentLength() <= 0) {
                return;
            }
            int n = length = httpConn.getContentLength() > 0 ? httpConn.getContentLength() : 135445935;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                downloaded += bytesRead;
                int percentage = (int)((double)(numWritten += (long)bytesRead) / (double)length * 100.0);
                Client.getClient().setLoadingPercentage(percentage);
            }
            outputStream.close();
            inputStream.close();
        } else {
            System.out.println("Cache host replied HTTP code: " + responseCode);
        }
        httpConn.disconnect();
    }

    public static void downloadCache2() throws IOException {
        System.out.println("Second cache download");
        URL url = new URL("https://avernic.com/ozara/cache.zip");
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.addRequestProperty("User-Agent", "Mozilla/4.76");
        int responseCode = httpConn.getResponseCode();
        if (responseCode == 200) {
            int length;
            String fileName = CACHE_FILE_NAME;
            InputStream inputStream = httpConn.getInputStream();
            String saveFilePath = Signlink.getCacheDirectory() + File.separator + fileName;
            FileOutputStream outputStream = new FileOutputStream(saveFilePath);
            int bytesRead = -1;
            byte[] buffer = new byte[4096];
            long startTime = System.currentTimeMillis();
            int downloaded = 0;
            long numWritten = 0L;
            int n = length = httpConn.getContentLength() > 0 ? httpConn.getContentLength() : 135445935;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                downloaded += bytesRead;
                int percentage = (int)((double)(numWritten += (long)bytesRead) / (double)length * 100.0);
                Client.getClient().setLoadingPercentage(percentage);
            }
            outputStream.close();
            inputStream.close();
        } else {
            System.out.println("Cache host replied HTTP code: " + responseCode);
        }
        httpConn.disconnect();
    }

    private static void unzipCache() {
        try {
            ZipEntry e;
            File file = new File(Signlink.getCacheDirectory() + CACHE_FILE_NAME);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            ZipInputStream zin = new ZipInputStream(in);
            while ((e = zin.getNextEntry()) != null) {
                if (e.isDirectory()) {
                    new File(Signlink.getCacheDirectory() + e.getName()).mkdir();
                    continue;
                }
                if (e.getName().equals(file.getName())) {
                    CacheDownloader.unzipPartlyArchive(zin, file.getName());
                    break;
                }
                CacheDownloader.unzipPartlyArchive(zin, Signlink.getCacheDirectory() + e.getName());
            }
            zin.close();
            file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void unzipPartlyArchive(ZipInputStream zin, String s2) throws Exception {
        FileOutputStream out = new FileOutputStream(s2);
        byte[] b = new byte[1024];
        int len = 0;
        while ((len = zin.read(b)) != -1) {
            out.write(b, 0, len);
        }
        out.close();
    }

    public static double getCurrentVersion() {
        try {
            File file = new File(Signlink.getCacheDirectory() + CURRENT_VERSION_FILE);
            if (!file.exists()) {
                return 0.0;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            double version = Double.parseDouble(br.readLine());
            br.close();
            return version;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.1;
        }
    }

    public static double getNewestVersion() {
        try {
            System.out.println("First cache version link");
            URL url = new URL(NEWEST_VERSION_FILE_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/4.76");
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            double version = Double.parseDouble(br.readLine());
            br.close();
            return version;
        }
        catch (Exception e) {
            System.out.println("HERE SECOND");
            e.printStackTrace();
            return 0.1;
        }
    }

    public static void setLatestCacheVersion(double newest) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(Signlink.getCacheDirectory() + CURRENT_VERSION_FILE));
        bw.write(String.valueOf(newest));
        bw.close();
    }
}

