/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client;

public class DrawingArea2 {
    public static float[] depthBuffer;
    public static int[] pixels;
    public static int width;
    public static int height;
    public static int topY;
    private static int bottomY;
    public static int topX;
    private static int clipRight;
    public static int centerX;
    public static int centerY;
    public static int anInt1387;

    public static void initDrawingArea2(int i, int j, int[] ai, float[] depth) {
        pixels = ai;
        width = j;
        height = i;
        depthBuffer = depth;
        DrawingArea2.setDrawingArea2(i, 0, j, 0);
    }

    public static void drawVerticalLine2(int xPosition, int yPosition, int height, int rgbColour) {
        if (xPosition < topX || xPosition >= clipRight) {
            return;
        }
        if (yPosition < topY) {
            height -= topY - yPosition;
            yPosition = topY;
        }
        if (yPosition + height > bottomY) {
            height = bottomY - yPosition;
        }
        int pixelIndex = xPosition + yPosition * width;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            DrawingArea2.pixels[pixelIndex + rowIndex * DrawingArea2.width] = rgbColour;
        }
    }

    public static void drawHorizontalLine2(int xPosition, int yPosition, int width, int rgbColour) {
        if (yPosition < topY || yPosition >= bottomY) {
            return;
        }
        if (xPosition < topX) {
            width -= topX - xPosition;
            xPosition = topX;
        }
        if (xPosition + width > clipRight) {
            width = clipRight - xPosition;
        }
        int pixelIndex = xPosition + yPosition * DrawingArea2.width;
        for (int i = 0; i < width; ++i) {
            DrawingArea2.pixels[pixelIndex + i] = rgbColour;
        }
    }

    public static void fillRectangleTransparent(int x, int y, int w, int h2, int color, int alpha) {
        if (x < topX) {
            w -= topX - x;
            x = topX;
        }
        if (y < topY) {
            h2 -= topY - y;
            y = topY;
        }
        if (x + w > clipRight) {
            w = clipRight - x;
        }
        if (y + h2 > bottomY) {
            h2 = bottomY - y;
        }
        int a2 = 256 - alpha;
        int r1 = (color >> 16 & 0xFF) * alpha;
        int g1 = (color >> 8 & 0xFF) * alpha;
        int b1 = (color & 0xFF) * alpha;
        int k3 = width - w;
        int pixel = x + y * width;
        for (int i4 = 0; i4 < h2; ++i4) {
            for (int j4 = -w; j4 < 0; ++j4) {
                int r2 = (pixels[pixel] >> 16 & 0xFF) * a2;
                int g2 = (pixels[pixel] >> 8 & 0xFF) * a2;
                int b2 = (pixels[pixel] & 0xFF) * a2;
                int rgb = (r1 + r2 >> 8 << 16) + (g1 + g2 >> 8 << 8) + (b1 + b2 >> 8);
                DrawingArea2.pixels[pixel++] = rgb;
            }
            pixel += k3;
        }
    }

    public static void drawBoxOutline(int leftX, int topY, int width, int height, int rgbColour) {
        DrawingArea2.drawHorizontalLine2(leftX, topY, width, rgbColour);
        DrawingArea2.drawHorizontalLine2(leftX, topY + height - 1, width, rgbColour);
        DrawingArea2.drawVerticalLine2(leftX, topY, height, rgbColour);
        DrawingArea2.drawVerticalLine2(leftX + width - 1, topY, height, rgbColour);
    }

    public static void drawAlphaGradient(int x, int y, int gradientWidth, int gradientHeight, int startColor, int endColor, int alpha) {
        int k1 = 0;
        int l1 = 65536 / gradientHeight;
        if (x < topX) {
            gradientWidth -= topX - x;
            x = topX;
        }
        if (y < topY) {
            k1 += (topY - y) * l1;
            gradientHeight -= topY - y;
            y = topY;
        }
        if (x + gradientWidth > clipRight) {
            gradientWidth = clipRight - x;
        }
        if (y + gradientHeight > bottomY) {
            gradientHeight = bottomY - y;
        }
        int i2 = width - gradientWidth;
        int result_alpha = 256 - alpha;
        int total_pixels = x + y * width;
        for (int k2 = -gradientHeight; k2 < 0; ++k2) {
            int gradient1 = 65536 - k1 >> 8;
            int gradient2 = k1 >> 8;
            int gradient_color = ((startColor & 0xFF00FF) * gradient1 + (endColor & 0xFF00FF) * gradient2 & 0xFF00FF00) + ((startColor & 0xFF00) * gradient1 + (endColor & 0xFF00) * gradient2 & 0xFF0000) >>> 8;
            int color = ((gradient_color & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((gradient_color & 0xFF00) * alpha >> 8 & 0xFF00);
            for (int k3 = -gradientWidth; k3 < 0; ++k3) {
                int colored_pixel = pixels[total_pixels];
                colored_pixel = ((colored_pixel & 0xFF00FF) * result_alpha >> 8 & 0xFF00FF) + ((colored_pixel & 0xFF00) * result_alpha >> 8 & 0xFF00);
                DrawingArea2.pixels[total_pixels++] = color + colored_pixel;
            }
            total_pixels += i2;
            k1 += l1;
        }
    }

    public static void drawRectangle(int x, int y, int width, int height, int color) {
        DrawingArea2.drawHorizontalLine(x, y, width, color);
        DrawingArea2.drawHorizontalLine(x, y + height - 1, width, color);
        DrawingArea2.drawVerticalLine(x, y, height, color);
        DrawingArea2.drawVerticalLine(x + width - 1, y, height, color);
    }

    public static void drawHorizontalLine(int drawX, int drawY, int lineWidth, int i_62_) {
    }

    public static void transparentBox(int i, int j, int k, int l, int i1, int j1, int opac) {
        int j3 = 256 - opac;
        if (k < topX) {
            i1 -= topX - k;
            k = topX;
        }
        if (j < topY) {
            i -= topY - j;
            j = topY;
        }
        if (k + i1 > DrawingArea2.getclipRight()) {
            i1 = DrawingArea2.getclipRight() - k;
        }
        if (j + i > DrawingArea2.getBottomY()) {
            i = DrawingArea2.getBottomY() - j;
        }
        int k1 = width - i1;
        int l1 = k + j * width;
        if (j1 != 0) {
            anInt1387 = -374;
        }
        for (int i2 = -i; i2 < 0; ++i2) {
            for (int j2 = -i1; j2 < 0; ++j2) {
                int i3 = pixels[l1];
                DrawingArea2.pixels[l1++] = ((l & 0xFF00FF) * opac + (i3 & 0xFF00FF) * j3 & 0xFF00FF00) + ((l & 0xFF00) * opac + (i3 & 0xFF00) * j3 & 0xFF0000) >> 8;
            }
            l1 += k1;
        }
    }

    public static void drawTransparentBox(int leftX, int topY, int width, int height, int rgbColour, int opacity) {
        if (leftX < topX) {
            width -= topX - leftX;
            leftX = topX;
        }
        if (topY < DrawingArea2.topY) {
            height -= DrawingArea2.topY - topY;
            topY = DrawingArea2.topY;
        }
        if (leftX + width > clipRight) {
            width = clipRight - leftX;
        }
        if (topY + height > bottomY) {
            height = bottomY - topY;
        }
        int transparency = 256 - opacity;
        int red = (rgbColour >> 16 & 0xFF) * opacity;
        int green = (rgbColour >> 8 & 0xFF) * opacity;
        int blue = (rgbColour & 0xFF) * opacity;
        int leftOver = DrawingArea2.width - width;
        int pixelIndex = leftX + topY * DrawingArea2.width;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < width; ++columnIndex) {
                int otherRed = (pixels[pixelIndex] >> 16 & 0xFF) * transparency;
                int otherGreen = (pixels[pixelIndex] >> 8 & 0xFF) * transparency;
                int otherBlue = (pixels[pixelIndex] & 0xFF) * transparency;
                int transparentColour = (red + otherRed >> 8 << 16) + (green + otherGreen >> 8 << 8) + (blue + otherBlue >> 8);
                DrawingArea2.pixels[pixelIndex++] = transparentColour;
            }
            pixelIndex += leftOver;
        }
    }

    public static void drawVerticalLine(int x, int y, int length, int color) {
        if (x < topX || x >= clipRight) {
            return;
        }
        if (y < topY) {
            length -= topY - y;
            y = topY;
        }
        if (y + length > bottomY) {
            length = bottomY - y;
        }
        int pixel = x + y * width;
        for (int k1 = 0; k1 < length; ++k1) {
            DrawingArea2.pixels[pixel + k1 * DrawingArea2.width] = color;
        }
    }

    public static void drawVerticalLine(int x, int y, int length, int color, int alpha) {
        if (x < topX || x >= clipRight) {
            return;
        }
        if (y < topY) {
            length -= topY - y;
            y = topY;
        }
        if (y + length > bottomY) {
            length = bottomY - y;
        }
        int a2 = 256 - alpha;
        int r1 = (color >> 16 & 0xFF) * alpha;
        int g1 = (color >> 8 & 0xFF) * alpha;
        int b1 = (color & 0xFF) * alpha;
        int pixel = x + y * width;
        for (int j3 = 0; j3 < length; ++j3) {
            int rgb;
            int r2 = (pixels[pixel] >> 16 & 0xFF) * a2;
            int g2 = (pixels[pixel] >> 8 & 0xFF) * a2;
            int b2 = (pixels[pixel] & 0xFF) * a2;
            DrawingArea2.pixels[pixel] = rgb = (r1 + r2 >> 8 << 16) + (g1 + g2 >> 8 << 8) + (b1 + b2 >> 8);
            pixel += width;
        }
    }

    public static void method336(int i, int j, int k, int l, int i1) {
        if (k < topX) {
            i1 -= topX - k;
            k = topX;
        }
        if (j < topY) {
            i -= topY - j;
            j = topY;
        }
        if (k + i1 > DrawingArea2.getclipRight()) {
            i1 = DrawingArea2.getclipRight() - k;
        }
        if (j + i > DrawingArea2.getBottomY()) {
            i = DrawingArea2.getBottomY() - j;
        }
        int k1 = width - i1;
        int l1 = k + j * width;
        for (int i2 = -i; i2 < 0; ++i2) {
            for (int j2 = -i1; j2 < 0; ++j2) {
                DrawingArea2.pixels[l1++] = l;
            }
            l1 += k1;
        }
    }

    public static void defaultDrawingArea2Size() {
        topX = 0;
        topY = 0;
        DrawingArea2.setclipRight(width);
        DrawingArea2.setBottomY(height);
        centerX = DrawingArea2.getclipRight() - 0;
        centerY = DrawingArea2.getclipRight() / 2;
    }

    public static void setDrawingArea2(int i, int j, int k, int l) {
        if (j < 0) {
            j = 0;
        }
        if (l < 0) {
            l = 0;
        }
        if (k > width) {
            k = width;
        }
        if (i > height) {
            i = height;
        }
        topX = j;
        topY = l;
        DrawingArea2.setclipRight(k);
        DrawingArea2.setBottomY(i);
        centerX = DrawingArea2.getclipRight() - 0;
        centerY = DrawingArea2.getclipRight() / 2;
        anInt1387 = DrawingArea2.getBottomY() / 2;
    }

    public static void setAllPixelsToZero() {
        int i = width * height;
        for (int j = 0; j < i; ++j) {
            DrawingArea2.pixels[j] = 0;
            DrawingArea2.depthBuffer[j] = Float.MAX_VALUE;
        }
    }

    public static void method335(int i, int j, int k, int l, int i1, int k1) {
        if (k1 < topX) {
            k -= topX - k1;
            k1 = topX;
        }
        if (j < topY) {
            l -= topY - j;
            j = topY;
        }
        if (k1 + k > DrawingArea2.getclipRight()) {
            k = DrawingArea2.getclipRight() - k1;
        }
        if (j + l > DrawingArea2.getBottomY()) {
            l = DrawingArea2.getBottomY() - j;
        }
        int l1 = 256 - i1;
        int i2 = (i >> 16 & 0xFF) * i1;
        int j2 = (i >> 8 & 0xFF) * i1;
        int k2 = (i & 0xFF) * i1;
        int k3 = width - k;
        int l3 = k1 + j * width;
        for (int i4 = 0; i4 < l; ++i4) {
            for (int j4 = -k; j4 < 0; ++j4) {
                int l2 = (pixels[l3] >> 16 & 0xFF) * l1;
                int i3 = (pixels[l3] >> 8 & 0xFF) * l1;
                int j3 = (pixels[l3] & 0xFF) * l1;
                int k4 = (i2 + l2 >> 8 << 16) + (j2 + i3 >> 8 << 8) + (k2 + j3 >> 8);
                DrawingArea2.pixels[l3++] = k4;
            }
            l3 += k3;
        }
    }

    public static void drawPixels(int lengthOfDrawing, int yPosition, int xPosition, int colour, int widthOfDrawing) {
        if (xPosition < topX) {
            widthOfDrawing -= topX - xPosition;
            xPosition = topX;
        }
        if (yPosition < topY) {
            lengthOfDrawing -= topY - yPosition;
            yPosition = topY;
        }
        if (xPosition + widthOfDrawing > DrawingArea2.getclipRight()) {
            widthOfDrawing = DrawingArea2.getclipRight() - xPosition;
        }
        if (yPosition + lengthOfDrawing > DrawingArea2.getBottomY()) {
            lengthOfDrawing = DrawingArea2.getBottomY() - yPosition;
        }
        int k1 = width - widthOfDrawing;
        int l1 = xPosition + yPosition * width;
        for (int i2 = -lengthOfDrawing; i2 < 0; ++i2) {
            for (int j2 = -widthOfDrawing; j2 < 0; ++j2) {
                DrawingArea2.pixels[l1++] = colour;
            }
            l1 += k1;
        }
    }

    public static void fillRectangle(int x, int y, int w, int h2, int color) {
        if (x < topX) {
            w -= topX - x;
            x = topX;
        }
        if (y < topY) {
            h2 -= topY - y;
            y = topY;
        }
        if (x + w > clipRight) {
            w = clipRight - x;
        }
        if (y + h2 > bottomY) {
            h2 = bottomY - y;
        }
        int k1 = width - w;
        int l1 = x + y * width;
        for (int i2 = -h2; i2 < 0; ++i2) {
            for (int j2 = -w; j2 < 0; ++j2) {
                DrawingArea2.pixels[l1++] = color;
            }
            l1 += k1;
        }
    }

    public static void fillRectangle(int x, int y, int w, int h2, int color, int alpha) {
        if (x < topX) {
            w -= topX - x;
            x = topX;
        }
        if (y < topY) {
            h2 -= topY - y;
            y = topY;
        }
        if (x + w > clipRight) {
            w = clipRight - x;
        }
        if (y + h2 > bottomY) {
            h2 = bottomY - y;
        }
        int a2 = 256 - alpha;
        int r1 = (color >> 16 & 0xFF) * alpha;
        int g1 = (color >> 8 & 0xFF) * alpha;
        int b1 = (color & 0xFF) * alpha;
        int k3 = width - w;
        int pixel = x + y * width;
        for (int i4 = 0; i4 < h2; ++i4) {
            for (int j4 = -w; j4 < 0; ++j4) {
                int r2 = (pixels[pixel] >> 16 & 0xFF) * a2;
                int g2 = (pixels[pixel] >> 8 & 0xFF) * a2;
                int b2 = (pixels[pixel] & 0xFF) * a2;
                int rgb = (r1 + r2 >> 8 << 16) + (g1 + g2 >> 8 << 8) + (b1 + b2 >> 8);
                DrawingArea2.pixels[pixel++] = rgb;
            }
            pixel += k3;
        }
    }

    public static void fillPixels(int xPos, int width, int height, int colour, int yPos) {
        DrawingArea2.method339(yPos, colour, width, xPos);
        DrawingArea2.method339(yPos + height - 1, colour, width, xPos);
        DrawingArea2.drawVerticalLineNew(yPos, colour, height, xPos);
        DrawingArea2.drawVerticalLineNew(yPos, colour, height, xPos + width - 1);
    }

    public static void method338(int i, int j, int k, int l, int i1, int j1) {
        DrawingArea2.drawHorizontalLineNew(l, i1, i, k, j1);
        DrawingArea2.drawHorizontalLineNew(l, i1, i + j - 1, k, j1);
        if (j >= 3) {
            DrawingArea2.drawVerticleLineNew(l, j1, k, i + 1, j - 2);
            DrawingArea2.drawVerticleLineNew(l, j1 + i1 - 1, k, i + 1, j - 2);
        }
    }

    public static void method339(int i, int j, int k, int l) {
        if (i < topY || i >= DrawingArea2.getBottomY()) {
            return;
        }
        if (l < topX) {
            k -= topX - l;
            l = topX;
        }
        if (l + k > DrawingArea2.getclipRight()) {
            k = DrawingArea2.getclipRight() - l;
        }
        int i1 = l + i * width;
        for (int j1 = 0; j1 < k; ++j1) {
            DrawingArea2.pixels[i1 + j1] = j;
        }
    }

    protected static void drawHorizontalLineNew(int i, int j, int k, int l, int i1) {
        if (k < topY || k >= DrawingArea2.getBottomY()) {
            return;
        }
        if (i1 < topX) {
            j -= topX - i1;
            i1 = topX;
        }
        if (i1 + j > DrawingArea2.getclipRight()) {
            j = DrawingArea2.getclipRight() - i1;
        }
        int j1 = 256 - l;
        int k1 = (i >> 16 & 0xFF) * l;
        int l1 = (i >> 8 & 0xFF) * l;
        int i2 = (i & 0xFF) * l;
        int i3 = i1 + k * width;
        for (int j3 = 0; j3 < j; ++j3) {
            int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
            int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
            int l2 = (pixels[i3] & 0xFF) * j1;
            int k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            DrawingArea2.pixels[i3++] = k3;
        }
    }

    public static void drawVerticalLineNew(int i, int j, int k, int l) {
        if (l < topX || l >= DrawingArea2.getclipRight()) {
            return;
        }
        if (i < topY) {
            k -= topY - i;
            i = topY;
        }
        if (i + k > DrawingArea2.getBottomY()) {
            k = DrawingArea2.getBottomY() - i;
        }
        int j1 = l + i * width;
        for (int k1 = 0; k1 < k; ++k1) {
            DrawingArea2.pixels[j1 + k1 * DrawingArea2.width] = j;
        }
    }

    protected static void drawVerticleLineNew(int i, int j, int k, int l, int i1) {
        if (j < topX || j >= DrawingArea2.getclipRight()) {
            return;
        }
        if (l < topY) {
            i1 -= topY - l;
            l = topY;
        }
        if (l + i1 > DrawingArea2.getBottomY()) {
            i1 = DrawingArea2.getBottomY() - l;
        }
        int j1 = 256 - k;
        int k1 = (i >> 16 & 0xFF) * k;
        int l1 = (i >> 8 & 0xFF) * k;
        int i2 = (i & 0xFF) * k;
        int i3 = j + l * width;
        for (int j3 = 0; j3 < i1; ++j3) {
            int k3;
            int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
            int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
            int l2 = (pixels[i3] & 0xFF) * j1;
            DrawingArea2.pixels[i3] = k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            i3 += width;
        }
    }

    DrawingArea2() {
    }

    public static int getBottomY() {
        return bottomY;
    }

    public static void setBottomY(int bottomY) {
        DrawingArea2.bottomY = bottomY;
    }

    public static int getclipRight() {
        return clipRight;
    }

    public static void setclipRight(int clipRight) {
        DrawingArea2.clipRight = clipRight;
    }
}

