/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UnsupportedLookAndFeelException;
import org.necrotic.Configuration;
import org.necrotic.client.Client;
import org.necrotic.client.GameCanvas;
import org.necrotic.client.GameShell;
import org.necrotic.client.RSInterface;
import org.necrotic.client.graphics.CursorData;
import org.necrotic.client.graphics.RSImageProducer;
import org.necrotic.client.graphics.Sprite;
import org.necrotic.client.graphics.gameframe.GameFrame;
import org.necrotic.client.graphics.rsinterface.TradingPost;
import org.necrotic.client.io.ByteBuffer;

public class GameRenderer
extends Applet
implements Runnable,
MouseListener,
MouseMotionListener,
KeyListener,
FocusListener,
WindowListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    private final long[] aLongArray7 = new long[10];
    private int anInt4;
    public boolean awtFocus = true;
    private final int[] charQueue;
    private int clickMode1;
    private int clickMode2;
    public int clickMode3;
    protected int clickX;
    protected int clickY;
    private int delayTime = 20;
    int fps;
    RSImageProducer fullGameScreen;
    public int idleTime;
    final int[] keyArray = new int[128];
    GameShell gameFrame;
    int minDelay = 1;
    public int mouseX;
    public int mouseY;
    public static int myHeight;
    public static int myWidth;
    private int readIndex;
    boolean resized;
    int saveClickX;
    int saveClickY;
    private boolean shouldClearScreen = true;
    private boolean shouldDebug = false;
    private int writeIndex;
    private long clickTime;
    protected boolean isApplet;
    public int forceWidth = -1;
    public int forceHeight = -1;
    public static int canvas_x;
    public static int canvas_y;
    Graphics graphics;
    private static final Color FONT_COLOR;
    private static final Font LOADING_FONT;
    private static final int barWidth = 300;
    private static final int barHeight = 30;
    private static final int barSpace = 2;
    private static final int barMax = 368;
    private static int currentLoadingColor;
    private static int nextLoadingColor;
    private Image loadingBuffer;
    private long startTime = 0L;
    private long colorStart = 0L;
    private static final Color BACKGROUND_COLOR;
    public int mouseWheelX;
    public int mouseWheelY;
    public boolean mouseWheelDown;
    private Thread thread;
    public static int max_display_width;
    public static int max_display_height;
    public static int canvas_width;
    public static int canvas_height;
    public static Canvas canvas;
    public static boolean full_redraw;
    public static boolean resize_canvas_requested;

    public int getScreenWidth() {
        if (this.isApplet) {
            return canvas_width;
        }
        if (this.forceWidth >= 0) {
            return this.forceWidth;
        }
        return this.getRealScreenWidth();
    }

    public int getScreenHeight() {
        if (this.isApplet) {
            return canvas_height;
        }
        if (this.forceHeight >= 0) {
            return this.forceHeight;
        }
        return this.getRealScreenHeight();
    }

    public int getRealScreenWidth() {
        if (this.isApplet) {
            return canvas_width;
        }
        Container component = this.getGameComponent();
        if (component == null) {
            return this.forceWidth >= 0 ? this.forceWidth : 765;
        }
        int w = component.getWidth();
        return w;
    }

    public int getRealScreenHeight() {
        if (this.isApplet) {
            return canvas_height;
        }
        Container component = this.getGameComponent();
        if (component == null) {
            return this.forceHeight >= 0 ? this.forceHeight : 503;
        }
        int h2 = component.getHeight();
        return h2;
    }

    GameRenderer() {
        this.charQueue = new int[128];
    }

    void cleanUpForQuit() {
    }

    final void initApplet(int width, int height) {
        try {
            this.isApplet = true;
            myWidth = canvas_width = width;
            myHeight = canvas_height = height;
            this.forceWidth = myWidth;
            this.forceHeight = myHeight;
            this.getGameComponent().setBackground(Color.black);
            this.updateGraphics(true);
            this.fullGameScreen = new RSImageProducer(myWidth, myHeight);
            this.startRunnable(this, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    final void createClientFrame(int w, int h2) {
        this.isApplet = false;
        myWidth = w;
        myHeight = h2;
        this.forceWidth = w;
        this.forceHeight = myHeight;
        this.setSize(w, h2);
        this.setPreferredSize(new Dimension(w, h2));
        try {
            SwingUtilities.invokeAndWait(() -> {
                this.gameFrame = new GameShell(this, myWidth, myHeight, false, false);
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.getGameComponent().setBackground(Color.black);
        this.updateGraphics(true);
        this.fullGameScreen = new RSImageProducer(myWidth, myHeight);
        this.startRunnable(this, 1);
    }

    public void updateGraphics(boolean clear) {
    }

    @Override
    public final void destroy() {
        this.anInt4 = -1;
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.anInt4 == -1) {
            this.exit();
        }
    }

    private static void options(Graphics g2) {
        try {
            if (g2 instanceof Graphics2D) {
                Graphics2D r = (Graphics2D)g2;
                r.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                r.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int randomColor() {
        int red = 0;
        int green = (int)(Math.random() * 17.0);
        int blue = 0;
        return red << 16 | (green += 50 + (int)(Math.random() * 200.0)) << 8 | blue;
    }

    private static int blend(int dst, int src, int src_alpha) {
        if (src_alpha <= 0) {
            return dst;
        }
        if (src_alpha >= 255) {
            return src;
        }
        int src_delta = 255 - src_alpha;
        return ((0xFF00FF00 & (0xFF00FF & src) * src_alpha | 0xFF0000 & (src & 0xFF00) * src_alpha) >>> 8) + ((0xFF0000 & src_delta * (dst & 0xFF00) | src_delta * (dst & 0xFF00FF) & 0xFF00FF00) >>> 8);
    }

    void resetGraphic() {
    }

    private void exit() {
        this.anInt4 = -2;
        this.cleanUpForQuit();
        if (this.gameFrame != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                System.exit(0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public final void focusGained(FocusEvent event) {
        this.awtFocus = true;
        this.shouldClearScreen = true;
        this.raiseWelcomeScreen();
    }

    @Override
    public final void focusLost(FocusEvent event) {
        this.awtFocus = false;
        for (int i = 0; i < 128; ++i) {
            this.keyArray[i] = 0;
        }
    }

    public void rebuildFrame(boolean undecorated, int width, int height, boolean resizable, boolean full) {
        boolean createdByApplet = this.isApplet && !full;
        myWidth = width;
        myHeight = height;
        if (this.gameFrame != null) {
            this.gameFrame.dispose();
        }
        if (!createdByApplet) {
            this.gameFrame = new GameShell(this, width, height, undecorated, resizable);
            this.gameFrame.addWindowListener(this);
        }
        this.graphics = (createdByApplet ? this : this.gameFrame).getGraphics();
        if (!createdByApplet) {
            this.setFocusTraversalKeysEnabled(false);
            this.getGameComponent().addMouseWheelListener(this);
            this.getGameComponent().addMouseListener(this);
            this.getGameComponent().addMouseMotionListener(this);
            this.getGameComponent().addKeyListener(this);
            this.getGameComponent().addFocusListener(this);
        }
    }

    public void recreateClientFrame(boolean decorative, int width, int height, boolean resizable) {
        Container component = this.getGameComponent();
        component.setBackground(Color.black);
        component.removeMouseWheelListener(this);
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        component.removeKeyListener(this);
        component.removeFocusListener(this);
        if (this.gameFrame != null) {
            this.gameFrame.removeWindowListener(this);
            this.gameFrame.setVisible(false);
            this.gameFrame.dispose();
            this.gameFrame = null;
        }
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
        if (!this.isApplet || decorative) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    this.gameFrame = new GameShell(this, width, height, decorative, resizable);
                });
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.gameFrame.addWindowListener(this);
        }
        if (resizable && decorative) {
            if (!this.isApplet) {
                this.gameFrame.setMinimumSize(new Dimension(800, 600));
            }
        } else if (!resizable) {
            if (!this.isApplet) {
                this.gameFrame.setMinimumSize(new Dimension(765, 503));
            } else {
                this.setMinimumSize(new Dimension(765, 503));
            }
        }
        component = this.getGameComponent();
        component.setBackground(Color.black);
        component.addMouseWheelListener(this);
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addKeyListener(this);
        component.addFocusListener(this);
        this.mouseY = -1;
        this.mouseX = -1;
    }

    private int getChildHeight(RSInterface Interface, int Index) {
        return RSInterface.interfaceCache[Interface.children[Index]].height;
    }

    private int getChildWidth(RSInterface Interface, int Index) {
        return RSInterface.interfaceCache[Interface.children[Index]].width;
    }

    public Container getGameComponent() {
        return this;
    }

    private void interfaceScrollCheck(MouseWheelEvent e) {
        try {
            int rot = e.getWheelRotation();
            boolean TAB = false;
            boolean WINDOW = true;
            boolean POSX = false;
            boolean POSY = true;
            int WIDTH = 2;
            int HEIGHT = 3;
            int OFFX = 4;
            int OFFY = 5;
            int CHILD = 6;
            int SENSITIVITY = 7;
            int tabInterfaceID = Client.tabInterfaceIDs[Client.tabID];
            if (tabInterfaceID == 11000) {
                tabInterfaceID = 1151;
            }
            int[] InterfaceID = new int[]{tabInterfaceID, Client.openInterfaceID};
            int[] variables = new int[]{0, 0, 0, 0, canvas_x, canvas_y, 0, 15};
            if (InterfaceID[1] != -1) {
                boolean resizable = GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED;
                int interfaceWidth = GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? this.getScreenWidth() : 516;
                int interfaceHeight = GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? this.getScreenHeight() : 338;
                RSInterface Window2 = RSInterface.interfaceCache[InterfaceID[1]];
                variables[4] = resizable ? Client.instance.gameScreenDrawX + (interfaceWidth - 765) / 2 : 4;
                variables[5] = resizable ? Client.instance.gameScreenDrawY + (interfaceHeight - 503) / 2 : 4;
                for (int Index = 0; Index < Window2.children.length; ++Index) {
                    if (RSInterface.interfaceCache[Window2.children[Index]].scrollMax <= 0) continue;
                    variables[6] = Index;
                    variables[0] = Window2.childX[Index];
                    variables[1] = Window2.childY[Index];
                    variables[2] = this.getChildWidth(Window2, Index);
                    variables[3] = this.getChildHeight(Window2, Index);
                    break;
                }
                if (this.mouseX > variables[4] + variables[0] && this.mouseY > variables[5] + variables[1] && this.mouseX < variables[4] + variables[0] + variables[2] && this.mouseY < variables[5] + variables[1] + variables[3]) {
                    switch (InterfaceID[1]) {
                        default: 
                    }
                    variables[7] = 30;
                    switch (rot) {
                        case -1: {
                            if (RSInterface.interfaceCache[Window2.children[variables[6]]].scrollPosition == 0) break;
                            RSInterface.interfaceCache[Window2.children[variables[6]]].scrollPosition += rot * variables[7];
                            Client.tabAreaAltered = true;
                            break;
                        }
                        case 1: {
                            if (RSInterface.interfaceCache[Window2.children[variables[6]]].scrollPosition == RSInterface.interfaceCache[Window2.children[variables[6]]].scrollMax - RSInterface.interfaceCache[Window2.children[variables[6]]].height) break;
                            RSInterface.interfaceCache[Window2.children[variables[6]]].scrollPosition += rot * variables[7];
                        }
                    }
                    RSInterface.interfaceCache[Window2.children[variables[6]]].scrollPosition += rot * 30;
                }
            }
            if (InterfaceID[0] != -1) {
                RSInterface Tab = RSInterface.interfaceCache[InterfaceID[0]];
                if (Tab == null || Tab.children == null) {
                    return;
                }
                variables[4] = this.getRealScreenWidth() - 218;
                variables[5] = this.getRealScreenHeight() - 298;
                for (int Index = 0; Index < Tab.children.length; ++Index) {
                    if (RSInterface.interfaceCache[Tab.children[Index]].scrollMax <= 0) continue;
                    variables[6] = Index;
                    variables[0] = Tab.childX[Index];
                    variables[1] = Tab.childY[Index];
                    variables[2] = this.getChildWidth(Tab, Index);
                    variables[3] = this.getChildHeight(Tab, Index);
                    break;
                }
                if (this.mouseX > variables[4] + variables[0] && this.mouseY > variables[5] + variables[1] && this.mouseX < variables[4] + variables[0] + variables[2] && this.mouseY < variables[5] + variables[1] + variables[3]) {
                    switch (InterfaceID[0]) {
                        case 962: {
                            variables[7] = 30;
                            break;
                        }
                        case 638: {
                            variables[7] = 30;
                            break;
                        }
                        case 1151: {
                            variables[7] = 7;
                            break;
                        }
                        case 147: {
                            variables[7] = 15;
                            break;
                        }
                        default: {
                            variables[7] = 15;
                        }
                    }
                    switch (rot) {
                        case -1: {
                            if (RSInterface.interfaceCache[Tab.children[variables[6]]].scrollPosition == 0) break;
                            RSInterface.interfaceCache[Tab.children[variables[6]]].scrollPosition += rot * variables[7];
                            Client.tabAreaAltered = true;
                            break;
                        }
                        case 1: {
                            if (RSInterface.interfaceCache[Tab.children[variables[6]]].scrollPosition == RSInterface.interfaceCache[Tab.children[variables[6]]].scrollMax - RSInterface.interfaceCache[Tab.children[variables[6]]].height) break;
                            RSInterface.interfaceCache[Tab.children[variables[6]]].scrollPosition += rot * variables[7];
                            Client.tabAreaAltered = true;
                        }
                    }
                }
            }
            if (Client.getClient().inputDialogState == 3 && Client.getClient().getGrandExchange().searching) {
                Client.getClient().getGrandExchange().itemResultScrollPos += rot * 10;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public final void keyPressed(KeyEvent keyEvent) {
        String regex = "[a-zA-z\\s]*";
        this.idleTime = 0;
        Client.getClient().setActive();
        int keyCode = keyEvent.getKeyCode();
        int keyChar = keyEvent.getKeyChar();
        if (keyChar == 96) {
            boolean bl = Client.consoleOpen = !Client.consoleOpen;
        }
        if (keyEvent.isControlDown() && keyEvent.isShiftDown()) {
            Client.controlShiftTeleporting = true;
        }
        if (keyCode == 16) {
            Client.shiftIsDown = true;
        }
        if (keyCode == 17) {
            Client.controlIsDown = true;
        }
        if (keyEvent.isControlDown()) {
            if (keyCode == 72) {
                this.sendCommand("home");
                keyEvent.consume();
                return;
            }
            if (keyCode == 80) {
                this.sendCommand("pos");
                keyEvent.consume();
                return;
            }
            if (keyCode == 83) {
                this.sendCommand("bp");
                keyEvent.consume();
                return;
            }
            if (keyCode == 66) {
                this.sendCommand("bank");
                keyEvent.consume();
                return;
            }
            if (keyCode == 84) {
                this.sendCommand("tracks");
                keyEvent.consume();
                return;
            }
            if (keyCode == 73) {
                this.sendCommand("instances");
                keyEvent.consume();
                return;
            }
            if (keyCode == 77) {
                this.sendCommand("monsters");
                keyEvent.consume();
                return;
            }
            if (keyCode == 65) {
                this.sendCommand("achieve");
                keyEvent.consume();
                return;
            }
            if (keyCode == 68) {
                this.sendCommand("drops");
                keyEvent.consume();
                return;
            }
            if (keyCode == 76) {
                this.sendCommand("loots");
                keyEvent.consume();
                return;
            }
            if (keyCode == 89) {
                this.sendCommand("bis");
                keyEvent.consume();
                return;
            }
            if (keyCode == 69) {
                this.sendCommand("daily");
                keyEvent.consume();
                return;
            }
            if (keyCode == 81) {
                this.sendCommand("dissolve-all");
                keyEvent.consume();
                return;
            }
            if (keyCode == 88) {
                this.sendCommand("sendclientinterfacecommand");
                keyEvent.consume();
                return;
            }
        }
        if (keyCode == 27 && Client.openInterfaceID != -1) {
            Client.instance.closeGameInterfaces();
            return;
        }
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 67) {
            Client.setClipboardContents(Client.inputString);
            Client.inputTaken = true;
        }
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 88) {
            Client.setClipboardContents(Client.inputString);
            Client.inputString = "";
            Client.inputTaken = true;
        }
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 90) {
            Client.inputString = "";
        }
        if (!Configuration.NEW_FUNCTION_KEYS) {
            if (keyCode == 27) {
                Client.setTab(3);
            } else if (keyCode == 112) {
                Client.setTab(0);
            } else if (keyCode == 113) {
                Client.setTab(1);
            } else if (keyCode == 114) {
                Client.setTab(2);
            } else if (keyCode == 115) {
                Client.setTab(3);
            } else if (keyCode == 116) {
                Client.setTab(4);
            } else if (keyCode == 117) {
                Client.setTab(5);
            } else if (keyCode == 118) {
                Client.setTab(6);
            } else if (keyCode == 119) {
                Client.setTab(7);
            } else if (keyCode == 120) {
                Client.setTab(8);
            } else if (keyCode == 121) {
                Client.setTab(9);
            } else if (keyCode == 122) {
                Client.setTab(10);
            } else if (keyCode == 123) {
                Client.setTab(11);
            }
        } else if (keyCode == 27) {
            Client.setTab(10);
        } else if (keyCode == 112) {
            Client.setTab(3);
        } else if (keyCode == 113) {
            Client.setTab(4);
        } else if (keyCode == 114) {
            Client.setTab(5);
        } else if (keyCode == 115) {
            Client.setTab(6);
        } else if (keyCode == 116) {
            Client.setTab(0);
        } else if (keyCode == 117) {
            Client.setTab(1);
        } else if (keyCode == 118) {
            Client.setTab(2);
        } else if (keyCode == 119) {
            Client.setTab(7);
        } else if (keyCode == 120) {
            Client.setTab(8);
        } else if (keyCode == 121) {
            Client.setTab(9);
        } else if (keyCode == 122) {
            Client.setTab(11);
        } else if (keyCode == 123) {
            Client.setTab(12);
        }
        if (keyChar < 30) {
            keyChar = 0;
        }
        if (keyCode == 37) {
            keyChar = 1;
        }
        if (keyCode == 39) {
            keyChar = 2;
        }
        if (keyCode == 38) {
            keyChar = 3;
        }
        if (keyCode == 40) {
            keyChar = 4;
        }
        if (keyCode == 17) {
            keyChar = 5;
        }
        if (keyCode == 8) {
            keyChar = 8;
        }
        if (keyCode == 127) {
            keyChar = 8;
        }
        if (keyCode == 9) {
            keyChar = 9;
        }
        if (keyCode == 10) {
            keyChar = 10;
        }
        if (keyCode >= 112 && keyCode <= 123) {
            keyChar = 1008 + keyCode - 112;
        }
        if (keyCode == 36) {
            keyChar = 1000;
        }
        if (keyCode == 35) {
            keyChar = 1001;
        }
        if (keyCode == 33) {
            keyChar = 1002;
        }
        if (keyCode == 34) {
            keyChar = 1003;
        }
        if (keyChar > 0 && keyChar < 128) {
            this.keyArray[keyChar] = 1;
        }
        if (keyChar > 4) {
            this.charQueue[this.writeIndex] = keyChar;
            this.writeIndex = this.writeIndex + 1 & 0x7F;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(String cmd) {
        if (Client.loggedIn) {
            ByteBuffer byteBuffer = Client.getOut();
            synchronized (byteBuffer) {
                Client.getOut().putOpcode(231);
                Client.getOut().putByte(cmd.length() + 1);
                Client.getOut().putString(cmd);
            }
        }
    }

    @Override
    public final void keyReleased(KeyEvent keyevent) {
        this.idleTime = 0;
        Client.getClient().setActive();
        int keyCode = keyevent.getKeyCode();
        int keyChar = keyevent.getKeyChar();
        if (keyCode == 16) {
            Client.shiftIsDown = false;
        }
        if (keyCode == 17) {
            Client.controlIsDown = false;
        }
        if (!keyevent.isControlDown() || !keyevent.isShiftDown()) {
            Client.controlShiftTeleporting = false;
        }
        if (keyChar < 30) {
            keyChar = 0;
        }
        if (keyCode == 37) {
            keyChar = 1;
        }
        if (keyCode == 39) {
            keyChar = 2;
        }
        if (keyCode == 38) {
            keyChar = 3;
        }
        if (keyCode == 40) {
            keyChar = 4;
        }
        if (keyCode == 17) {
            keyChar = 5;
        }
        if (keyCode == 8) {
            keyChar = 8;
        }
        if (keyCode == 127) {
            keyChar = 8;
        }
        if (keyCode == 9) {
            keyChar = 9;
        }
        if (keyCode == 10) {
            keyChar = 10;
        }
        if (keyChar > 0 && keyChar < 128) {
            this.keyArray[keyChar] = 0;
        }
    }

    @Override
    public final void keyTyped(KeyEvent keyevent) {
    }

    final void method4(int i) {
        this.delayTime = 1000 / i;
    }

    @Override
    public final void mouseClicked(MouseEvent mouseevent) {
        int x = mouseevent.getX();
        int y = mouseevent.getY();
        this.idleTime = 0;
        Client.getClient().setActive();
        this.clickX = x;
        this.clickY = y;
    }

    @Override
    public final void mouseDragged(MouseEvent mouseevent) {
        int x = mouseevent.getX();
        int y = mouseevent.getY();
        if (this.mouseWheelDown) {
            y = this.mouseWheelX - mouseevent.getX();
            int k = this.mouseWheelY - mouseevent.getY();
            this.mouseWheelDragged(y, -k);
            this.mouseWheelX = mouseevent.getX();
            this.mouseWheelY = mouseevent.getY();
            return;
        }
        if (x < 0 || y < 0) {
            return;
        }
        if (System.currentTimeMillis() - this.clickTime >= 250L || Math.abs(this.saveClickX - x) > 5 || Math.abs(this.saveClickY - y) > 5) {
            this.idleTime = 0;
            Client.getClient().setActive();
            this.mouseX = x;
            this.mouseY = y;
        }
    }

    @Override
    public final void mouseEntered(MouseEvent mouseevent) {
    }

    @Override
    public final void mouseExited(MouseEvent mouseevent) {
        if (this.idleTime > 0) {
            this.idleTime = 0;
            Client.getClient().setActive();
        }
        this.mouseX = -1;
        this.mouseY = -1;
    }

    @Override
    public final void mouseMoved(MouseEvent mouseevent) {
        int x = mouseevent.getX();
        int y = mouseevent.getY();
        if (x < 0 || y < 0) {
            return;
        }
        if (System.currentTimeMillis() - this.clickTime >= 250L || Math.abs(this.saveClickX - x) > 5 || Math.abs(this.saveClickY - y) > 5) {
            this.idleTime = 0;
            Client.getClient().setActive();
            this.mouseX = x;
            this.mouseY = y;
        }
    }

    @Override
    public final void mousePressed(MouseEvent mouseevent) {
        int x = mouseevent.getX();
        int y = mouseevent.getY();
        Client.mousePressed = true;
        this.idleTime = 0;
        Client.getClient().setActive();
        this.clickX = x;
        this.clickY = y;
        this.clickTime = System.currentTimeMillis();
        int type = mouseevent.getButton();
        if (SwingUtilities.isMiddleMouseButton(mouseevent)) {
            this.mouseWheelDown = true;
            this.mouseWheelX = x;
            this.mouseWheelY = y;
            return;
        }
        if (SwingUtilities.isRightMouseButton(mouseevent)) {
            this.clickMode1 = 2;
            this.setClickMode2(2);
        } else if (SwingUtilities.isLeftMouseButton(mouseevent)) {
            this.clickMode1 = 1;
            this.setClickMode2(1);
        }
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        this.idleTime = 0;
        Client.getClient().setActive();
        this.mouseWheelDown = false;
        Client.mousePressed = false;
        this.setClickMode2(0);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int rotation = e.getWheelRotation();
        int xPos = Client.instance.chatArea.getxPos();
        int yPos = Client.instance.chatArea.getyPos();
        if (this.mouseX > 0 && this.mouseX < 512) {
            int mouseY = this.mouseY;
            Client.getClient();
            if (mouseY > Client.clientHeight - 165) {
                int mouseY2 = this.mouseY;
                Client.getClient();
                if (mouseY2 < Client.clientHeight - 25) {
                    int scrollPos = Client.anInt1089;
                    if ((scrollPos -= rotation * 30) < 0) {
                        scrollPos = 0;
                    }
                    if (scrollPos > Client.anInt1211 - 110) {
                        scrollPos = Client.anInt1211 - 110;
                    }
                    if (Client.anInt1089 != scrollPos) {
                        Client.anInt1089 = scrollPos;
                        Client.inputTaken = true;
                    }
                    return;
                }
            }
        }
        if (Client.loggedIn) {
            this.interfaceScrollCheck(e);
            this.handleInterfaceScrolling(e);
            boolean canZoom = GameFrame.isFixed() ? this.mouseX < 512 : this.mouseX < Client.clientWidth - 200;
            if (Client.openInterfaceID == -1 && canZoom) {
                boolean fixed = GameFrame.isFixed();
                if ((Client.clientZoom -= rotation * 80) > (fixed ? 1100 : 2200)) {
                    Client.clientZoom = fixed ? 1100 : 2200;
                } else if (Client.clientZoom < (fixed ? 180 : 240)) {
                    Client.clientZoom = fixed ? 180 : 240;
                }
            }
            Client.instance.setInputTaken(true);
        }
    }

    public boolean handleInterfaceScrolling(MouseWheelEvent event) {
        int rotation = event.getWheelRotation();
        int offsetX = 0;
        int offsetY = 0;
        int[] positionX1 = new int[5];
        int[] positionY1 = new int[5];
        int[] width1 = new int[5];
        int[] height1 = new int[5];
        int[] offsetX1 = new int[5];
        int[] offsetY1 = new int[5];
        int[] childID1 = new int[5];
        Client.getClient();
        int tabInterfaceID = Client.tabInterfaceIDs[Client.tabID];
        if (tabInterfaceID == 11000) {
            tabInterfaceID = 1151;
        }
        if (tabInterfaceID != -1) {
            RSInterface tab = RSInterface.interfaceCache[tabInterfaceID];
            int n = GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? Client.clientWidth - 218 : (offsetX = GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 28 : Client.clientWidth - 197);
            offsetY = GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? Client.clientHeight - 298 : (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 37 : Client.clientHeight - (Client.clientWidth >= 900 ? 37 : 74) - 267);
            int off = 0;
            for (int index = 0; index < tab.children.length; ++index) {
                if (RSInterface.interfaceCache[tab.children[index]].scrollMax <= 0) continue;
                childID1[off] = index;
                positionX1[off] = tab.childX[index];
                positionY1[off] = tab.childY[index];
                width1[off] = RSInterface.interfaceCache[tab.children[index]].width;
                height1[off] = RSInterface.interfaceCache[tab.children[index]].height;
                ++off;
            }
            for (int i = 0; i < childID1.length; ++i) {
                if (this.mouseX <= offsetX + positionX1[i] || this.mouseY <= offsetY + positionY1[i] || this.mouseX >= offsetX + positionX1[i] + width1[i] || this.mouseY >= offsetY + positionY1[i] + height1[i]) continue;
                if (RSInterface.interfaceCache[tab.children[childID1[i]]].scrollPosition > 0) {
                    RSInterface.interfaceCache[tab.children[childID1[i]]].scrollPosition += rotation * 30;
                    return true;
                }
                if (rotation <= 0) continue;
                RSInterface.interfaceCache[tab.children[childID1[i]]].scrollPosition += rotation * 30;
                return true;
            }
        }
        positionX1 = new int[5];
        positionY1 = new int[5];
        width1 = new int[5];
        height1 = new int[5];
        offsetX1 = new int[5];
        offsetY1 = new int[5];
        childID1 = new int[5];
        if (Client.openInterfaceID != -1) {
            int interfaceId = Client.openInterfaceID;
            if (Client.overlayInterfaceId != -1) {
                interfaceId = Client.overlayInterfaceId;
            }
            RSInterface rsi = RSInterface.interfaceCache[interfaceId];
            if (rsi.disableInteraction) {
                return false;
            }
            offsetX = GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 4 : Client.clientWidth / 2 - 360;
            offsetY = GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 4 : Client.clientHeight / 2 - 235;
            int off = 0;
            for (int index = 0; index < rsi.children.length; ++index) {
                if (RSInterface.interfaceCache[rsi.children[index]] == null || RSInterface.interfaceCache[rsi.children[index]].scrollMax <= 0) continue;
                childID1[off] = index;
                positionX1[off] = rsi.childX[index];
                positionY1[off] = rsi.childY[index];
                width1[off] = RSInterface.interfaceCache[rsi.children[index]].width;
                height1[off] = RSInterface.interfaceCache[rsi.children[index]].height;
                ++off;
            }
            for (int i = 0; i < childID1.length; ++i) {
                if (this.mouseX <= offsetX + positionX1[i] || this.mouseY <= offsetY + positionY1[i] || this.mouseX >= offsetX + positionX1[i] + width1[i] || this.mouseY >= offsetY + positionY1[i] + height1[i]) continue;
                if (RSInterface.interfaceCache[rsi.children[childID1[i]]].scrollPosition > 0) {
                    RSInterface.interfaceCache[rsi.children[childID1[i]]].scrollPosition += rotation * 30;
                    return true;
                }
                if (rotation <= 0) continue;
                RSInterface.interfaceCache[rsi.children[childID1[i]]].scrollPosition += rotation * 30;
                return true;
            }
        }
        if (Client.getClient().inputDialogState == 5 && TradingPost.selectedItemId != -1) {
            TradingPost.scrollPosition += rotation * 10;
        }
        return false;
    }

    @Override
    public final void paint(Graphics g2) {
        this.shouldClearScreen = true;
        this.raiseWelcomeScreen();
    }

    void mouseWheelDragged(int param1, int param2) {
    }

    void processDrawing() {
    }

    void processGameLoop() throws ClassNotFoundException, UnsupportedLookAndFeelException, InstantiationException, IllegalAccessException {
    }

    void raiseWelcomeScreen() {
    }

    final int readChar(int dummy) {
        int k = -1;
        if (this.writeIndex != this.readIndex) {
            k = this.charQueue[this.readIndex];
            this.readIndex = this.readIndex + 1 & 0x7F;
        }
        return k;
    }

    @Override
    public void run() {
        if (this.gameFrame != null) {
            this.gameFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    int result = JOptionPane.showConfirmDialog(GameRenderer.this.gameFrame, "Are you sure you want to exit Realm of Legends ?", "Exit Confirmation", 0);
                    if (result == 0) {
                        GameRenderer.this.gameFrame.setDefaultCloseOperation(3);
                        System.exit(0);
                    } else if (result == 1) {
                        GameRenderer.this.gameFrame.setDefaultCloseOperation(0);
                    }
                }
            });
        }
        this.thread = Thread.currentThread();
        this.getGameComponent().setFocusTraversalKeysEnabled(true);
        this.addCanvas();
        try {
            this.startUp();
            int i = 0;
            int j = 256;
            int k = 1;
            int i1 = 0;
            int j1 = 0;
            for (int k1 = 0; k1 < 10; ++k1) {
                this.aLongArray7[k1] = System.currentTimeMillis();
            }
            while (this.anInt4 >= 0) {
                if (this.anInt4 > 0) {
                    --this.anInt4;
                    if (this.anInt4 == 0) {
                        this.exit();
                        return;
                    }
                }
                int i2 = j;
                int j2 = k;
                j = 300;
                k = 1;
                long l1 = System.currentTimeMillis();
                if (this.aLongArray7[i] == 0L) {
                    j = i2;
                    k = j2;
                } else if (l1 > this.aLongArray7[i]) {
                    j = (int)((long)(2560 * this.delayTime) / (l1 - this.aLongArray7[i]));
                }
                if (j < 25) {
                    j = 25;
                }
                if (j > 256) {
                    j = 256;
                    k = (int)((long)this.delayTime - (l1 - this.aLongArray7[i]) / 10L);
                }
                if (k > this.delayTime) {
                    k = this.delayTime;
                }
                this.aLongArray7[i] = l1;
                i = (i + 1) % 10;
                if (k > 1) {
                    for (int k2 = 0; k2 < 10; ++k2) {
                        if (this.aLongArray7[k2] == 0L) continue;
                        int n = k2;
                        this.aLongArray7[n] = this.aLongArray7[n] + (long)k;
                    }
                }
                if (k < this.minDelay) {
                    k = this.minDelay;
                }
                try {
                    Thread.sleep(k);
                }
                catch (InterruptedException _ex) {
                    ++j1;
                }
                while (i1 < 256) {
                    this.clickMode3 = this.clickMode1;
                    this.saveClickX = this.clickX;
                    this.saveClickY = this.clickY;
                    this.clickMode1 = 0;
                    this.processGameLoop();
                    this.readIndex = this.writeIndex;
                    i1 += j;
                }
                i1 &= 0xFF;
                if (this.delayTime > 0) {
                    this.fps = 1000 * j / (this.delayTime * 256);
                }
                this.updateGraphics(false);
                this.processDrawing();
                if (!this.shouldDebug) continue;
                System.out.println("ntime:" + l1);
                for (int l2 = 0; l2 < 10; ++l2) {
                    int i3 = (i - l2 - 1 + 20) % 10;
                    System.out.println("otim" + i3 + ":" + this.aLongArray7[i3]);
                }
                System.out.println("fps:" + this.fps + " ratio:" + j + " count:" + i1);
                System.out.println("del:" + k + " deltime:" + this.delayTime + " mindel:" + this.minDelay);
                System.out.println("intex:" + j1 + " opos:" + i);
                this.shouldDebug = false;
                j1 = 0;
            }
            if (this.anInt4 == -1) {
                this.exit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public final void start() {
        if (this.anInt4 >= 0) {
            this.anInt4 = 0;
        }
    }

    public void startRunnable(Runnable runnable, int priority) {
        Thread thread = new Thread(runnable);
        thread.start();
        thread.setPriority(priority);
    }

    void startUp() {
    }

    @Override
    public final void stop() {
        if (this.anInt4 >= 0) {
            this.anInt4 = 4000 / this.delayTime;
        }
    }

    @Override
    public final void update(Graphics graphics) {
        this.shouldClearScreen = true;
        this.raiseWelcomeScreen();
    }

    @Override
    public final void windowActivated(WindowEvent event) {
    }

    @Override
    public final void windowClosed(WindowEvent event) {
    }

    @Override
    public final void windowClosing(WindowEvent event) {
        this.destroy();
    }

    @Override
    public final void windowDeactivated(WindowEvent event) {
    }

    @Override
    public final void windowDeiconified(WindowEvent event) {
    }

    @Override
    public final void windowIconified(WindowEvent event) {
    }

    @Override
    public final void windowOpened(WindowEvent event) {
    }

    public int getClickMode2() {
        return this.clickMode2;
    }

    public void setClickMode2(int clickMode2) {
        this.clickMode2 = clickMode2;
    }

    public void setCursor(CursorData cursor) {
        if (Client.getClient().oldCursor != null && Client.getClient().oldCursor == cursor) {
            return;
        }
        Sprite sprite = Client.spritesMap.get(cursor.sprite);
        Image image = sprite.getImage();
        this.getGameComponent().setCursor(this.getGameComponent().getToolkit().createCustomCursor(image, new Point(0, 0), null));
        Client.getClient().oldCursor = cursor;
    }

    public Thread getClientThread() {
        return this.thread;
    }

    public boolean isClientThread() {
        return this.thread == Thread.currentThread();
    }

    public static void set_max_display(int max_display_width, int max_display_height) {
        GameRenderer.max_display_width = max_display_width;
        GameRenderer.max_display_height = max_display_height;
        resize_canvas_requested = true;
    }

    public void checkResize() {
        Container container = this.getGameComponent();
        int width = container.getSize().width;
        int height = container.getSize().height;
        if (myWidth != width || myHeight != height || resize_canvas_requested) {
            this.resizeCanvas();
            resize_canvas_requested = false;
        }
        if (full_redraw) {
            GameRenderer.clear_screen();
            full_redraw = false;
        }
    }

    public void resizeCanvas() {
        Container container = this.getGameComponent();
        if (container == null) {
            return;
        }
        myWidth = container.getWidth();
        myHeight = container.getHeight();
        if (myWidth <= 0) {
            myWidth = 1;
        }
        if (myHeight <= 0) {
            myHeight = 1;
        }
        canvas_width = Math.min(myWidth, max_display_width);
        canvas_height = Math.min(myHeight, max_display_height);
        canvas_x = (myWidth - canvas_width) / 2;
        canvas_y = 0;
        canvas.setSize(canvas_width, canvas_height);
        Client.clientWidth = canvas_width;
        Client.clientHeight = canvas_height;
        if (Client.instance != null) {
            Client.instance.updateScreen();
        }
        canvas.setLocation(canvas_x, canvas_y);
        GameRenderer.clear_screen();
    }

    private synchronized void addCanvas() {
        this.removeCanvas();
        Container container = this.getGameComponent();
        canvas = new GameCanvas(container);
        this.addCanvas(container);
    }

    private void addCanvas(Container container) {
        container.setBackground(Color.black);
        container.setLayout(null);
        container.add(canvas);
        canvas.setSize(canvas_width, canvas_height);
        canvas.setVisible(true);
        canvas.setLocation(canvas_x, canvas_y);
        canvas.addMouseWheelListener(this);
        canvas.addMouseListener(this);
        canvas.addMouseMotionListener(this);
        canvas.addKeyListener(this);
        canvas.addFocusListener(this);
        canvas.requestFocus();
        canvas.setFocusTraversalKeysEnabled(false);
    }

    private void removeCanvas() {
        if (canvas != null) {
            canvas.removeMouseWheelListener(this);
            canvas.removeMouseListener(this);
            canvas.removeMouseMotionListener(this);
            canvas.removeKeyListener(this);
            canvas.removeFocusListener(this);
            canvas.getParent().setBackground(Color.black);
            canvas.getParent().remove(canvas);
        }
    }

    public static void clear_screen() {
        int left = canvas_x;
        int top = canvas_y;
        int right = myWidth - canvas_width - left;
        int bottom = myHeight - canvas_height - top;
        if (left > 0 || right > 0 || top > 0 || bottom > 0) {
            try {
                Container container = Client.instance.getGameComponent();
                int x = 0;
                int y = 0;
                Graphics graphics = container.getGraphics();
                graphics.setColor(Color.black);
                if (left > 0) {
                    graphics.fillRect(x, y, left, myHeight);
                }
                if (top > 0) {
                    graphics.fillRect(x, y, myWidth, top);
                }
                if (right > 0) {
                    graphics.fillRect(x + myWidth - right, y, right, myHeight);
                }
                if (bottom > 0) {
                    graphics.fillRect(x, y + myHeight - bottom, myWidth, bottom);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        canvas_x = 0;
        canvas_y = 0;
        FONT_COLOR = Color.white;
        LOADING_FONT = new Font("Helvetica", 1, 13);
        currentLoadingColor = -1;
        nextLoadingColor = -1;
        BACKGROUND_COLOR = Color.black;
    }
}

