/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client;

public enum IronIcon {
    ULTIMATE(839, 1),
    EXTREME(856, 1),
    NORMAL(840, 2);

    private final int icon;
    private final int rights;

    private IronIcon(int icon, int rights) {
        this.icon = icon;
        this.rights = rights;
    }

    public int getIcon() {
        return this.icon;
    }

    public int getRights() {
        return this.rights;
    }

    public static IronIcon forSprite(int spriteId) {
        for (IronIcon mi : IronIcon.values()) {
            if (mi.getIcon() != spriteId) continue;
            return mi;
        }
        return null;
    }

    public static IronIcon forRights(int rights) {
        for (IronIcon mi : IronIcon.values()) {
            if (mi.getRights() != rights) continue;
            return mi;
        }
        return null;
    }

    public static final int getMaxRights() {
        int maxValue = 0;
        for (IronIcon m3 : IronIcon.values()) {
            if (m3.getRights() <= maxValue) continue;
            maxValue = m3.getRights();
        }
        return ++maxValue;
    }
}

