/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client;

public class MathUtils {
    public static float map(float value, float istart, float istop, float ostart, float ostop) {
        return ostart + (ostop - ostart) * ((value - istart) / (istop - istart));
    }

    public static float smoothstep(float edge0, float edge1, float x) {
        x = MathUtils.constrain((x - edge0) / (edge1 - edge0), 0.0f, 1.0f);
        return x * x * (3.0f - 2.0f * x);
    }

    public static float constrain(float value, float min2, float max) {
        return Math.min(Math.max(value, min2), max);
    }

    public static float dist(int x1, int y1, int x2, int y2) {
        return (float)Math.sqrt((y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1));
    }

    public static int blend(int a, int b, float ratio) {
        int mask1 = 0xFF00FF;
        int mask2 = -16711936;
        int f2 = (int)(256.0f * ratio);
        int f1 = 256 - f2;
        return (a & mask1) * f1 + (b & mask1) * f2 >> 8 & mask1 | (a & mask2) * f1 + (b & mask2) * f2 >> 8 & mask2;
    }
}

