/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client;

public enum ModIcon {
    SUPPORT(832, 5),
    HELPER(832, 5),
    MODERATOR(828, 1),
    ADMINISTRATOR(829, 2),
    OWNER(830, 3),
    DEVELOPER(831, 4),
    CONTRIBUTOR(831, 6),
    REGULAR_DONATOR(832, 7),
    SUPER_DONATOR(833, 9),
    EXTREME_DONATOR(834, 11),
    SPONSOR_DONATOR(835, 12),
    ZENYTE_DONATOR(1508, 13),
    YOUTUBER(837, 8);

    private final int icon;
    private final int rights;

    private ModIcon(int icon, int rights) {
        this.icon = icon;
        this.rights = rights;
    }

    public int getIcon() {
        return this.icon;
    }

    public int getRights() {
        return this.rights;
    }

    public static ModIcon forSprite(int spriteId) {
        for (ModIcon mi : ModIcon.values()) {
            if (mi.getIcon() != spriteId) continue;
            return mi;
        }
        return null;
    }

    public static ModIcon forRights(int rights) {
        for (ModIcon mi : ModIcon.values()) {
            if (mi.getRights() != rights) continue;
            return mi;
        }
        return null;
    }

    public static final int getMaxRights() {
        int maxValue = 0;
        for (ModIcon m3 : ModIcon.values()) {
            if (m3.getRights() <= maxValue) continue;
            maxValue = m3.getRights();
        }
        return ++maxValue;
    }
}

