/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client;

import org.necrotic.client.cache.Archive;
import org.necrotic.client.graphics.Background;
import org.necrotic.client.world.Rasterizer;
import org.necrotic.client.world.Texture;

public class OnDemandTextureLoader {
    private final Archive archive;
    private final int MAX_FAILED_ATTEMPTS = 10;
    private final boolean[] failedToLoad = new boolean[98];
    private final int[] failedAttempts = new int[98];

    public OnDemandTextureLoader(Archive archive) {
        this.archive = archive;
    }

    public void loadTexture(int id) {
        block5: {
            if (this.failedToLoad[id]) {
                System.out.println("Failed to load " + id + " after " + 10 + " failed attempts");
                return;
            }
            Rasterizer.textureCount = Math.max(Rasterizer.textureCount, id + 1);
            try {
                Rasterizer.textures[id] = new Background(this.archive, String.valueOf(id), 0);
                if (Rasterizer.lowDetail && Rasterizer.textures[id].maxWidth == 128) {
                    Rasterizer.textures[id].method356();
                } else {
                    Rasterizer.textures[id].method357();
                }
                Rasterizer.adjustBrightnessForTexture(id, Texture.getBrightness());
                System.out.println("Loaded texture " + id);
            }
            catch (Exception _ex) {
                System.out.println("Failed to load texture " + id);
                int n = id;
                this.failedAttempts[n] = this.failedAttempts[n] + 1;
                if (this.failedAttempts[id] < 10) break block5;
                this.failedToLoad[id] = true;
            }
        }
    }
}

