/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.necrotic.client.ItemRarity;

public enum RarityColor {
    NONE(0, 0, ItemRarity.NONE),
    COMMON(3319890, 1, ItemRarity.COMMON),
    UNCOMMON(515854, 2, ItemRarity.UNCOMMON),
    RARE(8900331, 3, ItemRarity.RARE),
    LEGENDARY(15611401, 4, ItemRarity.LEGENDARY),
    MYTHIC(0xEE82EE, 5, ItemRarity.MYTHIC),
    GODLY(16716947, 6, ItemRarity.GODLY);

    private final int color;
    private final int id;
    private final ItemRarity itemRarity;
    private static final List<RarityColor> RARITY_COLOR_LIST;

    private RarityColor(int color, int id, ItemRarity itemRarity) {
        this.color = color;
        this.id = id;
        this.itemRarity = itemRarity;
    }

    public int getColor() {
        return this.color;
    }

    public int getId() {
        return this.id;
    }

    public ItemRarity getItemRarity() {
        return this.itemRarity;
    }

    public static RarityColor getColorTypeForEffect(int effect) {
        return RARITY_COLOR_LIST.stream().filter(eff -> eff.getId() == effect).findFirst().orElse(null);
    }

    static {
        RARITY_COLOR_LIST = new ArrayList<RarityColor>(Arrays.asList(RarityColor.values()));
    }
}

