/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client;

import java.util.concurrent.ThreadLocalRandom;
import org.necrotic.client.Client;
import org.necrotic.client.cache.definition.ItemDefinition;
import org.necrotic.client.graphics.DrawingArea;
import org.necrotic.client.graphics.Sprite;

public class WheelOfFortune {
    private int width;
    private int height;
    private int strokeWidth;
    private int color;
    private int alpha;
    private int closure;
    private boolean fill;
    private int segments;
    private Sprite icon;
    private double arcLength;
    private double drag = 0.97;
    private double angleVel = 0.0;
    private double angle = 0.0;
    private int index = -1;
    private int currentIndex = -1;
    private final double INITIAL_DRAG = 0.993;
    private final double LATER_DRAG = 0.988;
    private final double DRAG_CHANGE_CUTOFF = 3.5;
    private final double END_SPIN_CUTOFF = 0.4;
    private int[] items = new int[]{22121, 15004, 15002, 15003, 10942, 10943, 10942, 15002, 15003, 10942};
    private int[] items1 = new int[]{10942, 22121, 15004, 15002, 15003, 10942, 10943, 10942, 15002, 15003, 10942};
    private boolean active;

    public WheelOfFortune(int width, int height, int strokeWidth, int color, int alpha, int closure, boolean fill, int segments, Sprite icon) {
        this.width = width;
        this.height = height;
        this.strokeWidth = strokeWidth;
        this.color = color;
        this.alpha = alpha;
        this.closure = closure;
        this.fill = fill;
        this.segments = segments;
        this.icon = icon;
        this.arcLength = 360.0 / (double)segments;
    }

    public void render(int x, int y) {
        Sprite itemSprite;
        int idx = 0;
        this.update();
        for (double theta = 0.0; theta < 360.0; theta += this.arcLength) {
            DrawingArea.drawArc(x, y, this.width, this.height, this.strokeWidth, -(this.angle + theta), this.arcLength, this.getColor(this.items1[idx]), this.alpha, this.closure, this.fill);
            ++idx;
        }
        for (int i = 0; i < this.items.length && (itemSprite = ItemDefinition.getSprite(this.items[i], 1, 0)) != null; ++i) {
            double theta = (double)i * this.arcLength;
            double newPhi = this.angle + theta + this.arcLength / 2.0;
            double newRadius = (double)this.width / 3.0;
            double wheelCenterX = (double)x + (double)this.width / 2.0;
            double wheelCenterY = (double)y + (double)this.height / 2.0;
            double arcCenterX = Math.cos(Math.toRadians(newPhi)) * newRadius + wheelCenterX;
            double arcCenterY = Math.sin(Math.toRadians(newPhi)) * newRadius + wheelCenterY;
            itemSprite.drawSprite((int)(arcCenterX + 2.0) - itemSprite.myWidth / 2, (int)(arcCenterY + 2.0) - itemSprite.myHeight / 2);
        }
        this.icon.drawAdvancedSprite(x + this.width / 2 - this.icon.myWidth / 2, y - this.height / 12, 255);
    }

    private void update() {
        if (!this.active) {
            return;
        }
        if (this.angleVel < 0.4) {
            this.angleVel = 0.0;
            this.notifyServer();
            this.active = false;
            return;
        }
        if (this.angleVel < 3.5) {
            this.drag = 0.988;
        }
        this.angle += this.angleVel;
        this.angleVel *= this.drag;
        this.currentIndex = (int)((double)Math.floorMod((int)(-this.angle + (double)this.segments * 0.75 * this.arcLength), 360) / this.arcLength);
    }

    private int getColor(int itemId) {
        int color = 4142892;
        if (itemId == 10943) {
            color = 6434688;
        } else if (itemId == 22121) {
            color = 12427296;
        } else if (itemId == 15004) {
            color = 6939090;
        }
        return color;
    }

    public void init() {
        this.drag = 0.993;
        this.angle = 0.0;
        double spinDurationAfterCutoff = Math.log(0.1142857142857143) / Math.log(0.988);
        double angleAfterDragChange = 3.5 * (1.0 - Math.pow(0.988, spinDurationAfterCutoff)) / 0.01200000000000001;
        double endAngle = (double)(ThreadLocalRandom.current().nextInt(3, 7) * 360) - angleAfterDragChange;
        endAngle -= 90.0 + this.arcLength / 2.0;
        endAngle -= (double)this.index * this.arcLength;
        double offset = ThreadLocalRandom.current().nextDouble(-this.arcLength / 2.0 + 5.0, this.arcLength / 2.0 - 5.0);
        double tToCutoff = Math.log(3.5 / (3.5 + (endAngle -= offset) * (1.0 - this.drag))) / Math.log(this.drag);
        this.angleVel = 3.5 / Math.pow(this.drag, tToCutoff);
        this.active = true;
    }

    public void setItems(int[] items) {
        this.items = items;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    private void notifyServer() {
        Client.getOut().putOpcode(225);
        Client.getOut().putByte(this.index);
    }
}

