/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.accounts;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.necrotic.client.RSInterface;
import org.necrotic.client.Signlink;
import org.necrotic.client.accounts.Account;

public class AccountManager {
    private final String FILE_NAME = "accounts.dat";
    private Account[] accounts = new Account[5];
    private int totalAccounts;

    public AccountManager() {
        if (this.saveExists()) {
            this.load();
        }
    }

    public void addAccount(Account account, boolean save) {
        int box = this.getEmptyBox();
        if (box == -1) {
            return;
        }
        account.setBox(box);
        this.accounts[account.getBox()] = account;
        ++this.totalAccounts;
        this.updateInterface();
        if (save) {
            this.save();
        }
    }

    public void removeAccount(Account account, boolean save) {
        this.accounts[account.getBox()] = null;
        --this.totalAccounts;
        this.updateInterface();
        if (save) {
            this.save();
        }
    }

    public void updateInterface() {
        ArrayList<Account> accountList = new ArrayList<Account>();
        for (Account acc : this.accounts) {
            if (acc == null) continue;
            accountList.add(acc);
        }
        RSInterface.getCustomInterfaces().buildPlayerMenu(accountList);
    }

    private boolean saveExists() {
        File file = new File(Signlink.getSettingsDirectory() + "/accounts.dat");
        return file.exists();
    }

    private void load() {
        try {
            FileInputStream fin = new FileInputStream(Signlink.getSettingsDirectory() + "/" + "accounts.dat");
            ObjectInputStream oin = new ObjectInputStream(fin);
            this.totalAccounts = (Integer)oin.readObject();
            this.accounts = (Account[])oin.readObject();
            fin.close();
            oin.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            FileOutputStream fout = new FileOutputStream(Signlink.getSettingsDirectory() + "/" + "accounts.dat");
            ObjectOutputStream oout = new ObjectOutputStream(fout);
            oout.writeObject(this.totalAccounts);
            oout.writeObject(this.accounts);
            oout.close();
            fout.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Account getAccount(String username) {
        for (Account acc : this.accounts) {
            if (acc == null || !acc.getUsername().equals(username)) continue;
            return acc;
        }
        return null;
    }

    public int getEmptyBox() {
        int index = -1;
        for (int i = 0; i < this.accounts.length; ++i) {
            if (this.accounts[i] != null) continue;
            index = i;
            break;
        }
        return index;
    }

    public Account[] getAccounts() {
        return this.accounts;
    }
}

