/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.cache.definition;

import org.necrotic.client.List;
import org.necrotic.client.cache.Archive;
import org.necrotic.client.cache.definition.Animation;
import org.necrotic.client.io.ByteBuffer;
import org.necrotic.client.world.Model;

public final class SpotAnimDefinition {
    public static List list = new List(30);
    public static SpotAnimDefinition[] cache;
    SpotAnimDefinition[] cachenew = new SpotAnimDefinition[cache.length + 100];
    public Animation animation;
    private int id;
    public int modelId;
    private int animationId = -1;
    public int sizeXY = 128;
    public int sizeZ = 128;
    public int rotation;
    public int shadow;
    public int lightness;
    private int[] originalColours = new int[6];
    private int[] destColours = new int[6];

    public static void load(Archive archive) {
        ByteBuffer stream = new ByteBuffer(archive.get("spotanim.dat"));
        int length = stream.getUnsignedShort();
        if (cache == null) {
            cache = new SpotAnimDefinition[length + 1];
        }
        for (int j = 0; j < length; ++j) {
            if (cache[j] == null) {
                SpotAnimDefinition.cache[j] = new SpotAnimDefinition();
            }
            SpotAnimDefinition.cache[j].id = j;
            cache[j].readValues(stream);
            switch (j) {
                case 2959: {
                    SpotAnimDefinition.cache[2959].modelId = SpotAnimDefinition.cache[2114].modelId;
                    SpotAnimDefinition.cache[2959].animationId = SpotAnimDefinition.cache[2114].animationId;
                    SpotAnimDefinition.cache[2959].animation = SpotAnimDefinition.cache[2114].animation;
                    SpotAnimDefinition.cache[2959].originalColours = new int[]{127, 49874, -1, -1, -1, -1};
                    SpotAnimDefinition.cache[2959].destColours = new int[]{0, 100, -1, -1, -1, -1};
                }
            }
        }
        SpotAnimDefinition.custom();
        SpotAnimDefinition.c();
    }

    private static void custom() {
        SpotAnimDefinition.cache[2274].modelId = SpotAnimDefinition.cache[2281].modelId;
        SpotAnimDefinition.cache[2274].animationId = SpotAnimDefinition.cache[2281].animationId;
        SpotAnimDefinition.cache[2274].rotation = 90;
        SpotAnimDefinition.cache[2274].animation = SpotAnimDefinition.cache[2281].animation;
    }

    private static void c() {
        int size;
        int gfxID = 2964;
        SpotAnimDefinition.cache[gfxID] = new SpotAnimDefinition();
        SpotAnimDefinition.cache[gfxID].lightness = SpotAnimDefinition.cache[2213].lightness;
        SpotAnimDefinition.cache[gfxID].shadow = SpotAnimDefinition.cache[2213].shadow;
        SpotAnimDefinition.cache[gfxID].modelId = SpotAnimDefinition.cache[2213].modelId;
        SpotAnimDefinition.cache[gfxID].animation = SpotAnimDefinition.cache[2213].animation;
        SpotAnimDefinition.cache[gfxID].originalColours = SpotAnimDefinition.cache[2213].originalColours;
        SpotAnimDefinition.cache[gfxID].destColours = SpotAnimDefinition.cache[2213].destColours;
        SpotAnimDefinition.cache[gfxID].sizeXY = size = 300;
        SpotAnimDefinition.cache[gfxID].sizeZ = size;
    }

    private SpotAnimDefinition() {
    }

    public Model getModel() {
        Model model = (Model)list.insertFromCache(this.id);
        if (model != null) {
            return model;
        }
        model = Model.get(this.modelId);
        if (model == null) {
            return null;
        }
        for (int i = 0; i < 6; ++i) {
            if (this.originalColours[0] == 0) continue;
            model.method476(this.originalColours[i], this.destColours[i]);
        }
        list.removeFromCache(model, this.id);
        return model;
    }

    private void readValues(ByteBuffer stream) {
        int i;
        block0: while ((i = stream.getUnsignedByte()) != 0) {
            if (i == 1) {
                this.modelId = stream.getUnsignedShort();
                continue;
            }
            if (i == 2) {
                this.animationId = stream.getUnsignedShort();
                if (Animation.cache == null) continue;
                this.animation = Animation.cache[this.animationId];
                continue;
            }
            if (i == 4) {
                this.sizeXY = stream.getUnsignedShort();
                continue;
            }
            if (i == 5) {
                this.sizeZ = stream.getUnsignedShort();
                continue;
            }
            if (i == 6) {
                this.rotation = stream.getUnsignedShort();
                continue;
            }
            if (i == 7) {
                this.shadow = stream.getUnsignedByte();
                continue;
            }
            if (i == 8) {
                this.lightness = stream.getUnsignedByte();
                continue;
            }
            if (i == 40) {
                int j = stream.getUnsignedByte();
                int k = 0;
                while (true) {
                    if (k >= j) continue block0;
                    this.originalColours[k] = stream.getUnsignedShort();
                    this.destColours[k] = stream.getUnsignedShort();
                    ++k;
                }
            }
            System.out.println("Error unrecognised spotanim config code: " + i);
        }
        return;
    }
}

