/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.cache.node;

import org.necrotic.client.cache.node.Node;

public final class Deque {
    public final Node head;
    private Node current;

    public Deque() {
        this.head.prev = this.head = new Node();
        this.head.next = this.head;
    }

    public Node getFirst() {
        Node node = this.head.next;
        if (node == this.head) {
            this.current = null;
            return null;
        }
        this.current = node.next;
        return node;
    }

    public Node getNext() {
        Node node = this.current;
        if (node == this.head) {
            this.current = null;
            return null;
        }
        this.current = node.next;
        return node;
    }

    public void pushHead(Node node) {
        if (node.next != null) {
            node.unlink();
        }
        node.next = this.head.next;
        node.prev = this.head;
        node.next.prev = node;
        node.prev.next = node;
    }

    public void insertTail(Node node) {
        if (node.next != null) {
            node.unlink();
        }
        node.next = this.head;
        node.prev = this.head.prev;
        node.next.prev = node;
        node.prev.next = node;
    }

    public final void method894(Node class3, Node class3_27_) {
        if (class3.prev != null) {
            class3.unlink();
        }
        class3.next = class3_27_;
        class3.prev = class3_27_.prev;
        class3.prev.next = class3;
        class3.next.prev = class3;
    }

    public Node popHead() {
        Node node = this.head.prev;
        if (node == this.head) {
            return null;
        }
        node.unlink();
        return node;
    }

    public void removeAll() {
        if (this.head.prev == this.head) {
            return;
        }
        Node node;
        while ((node = this.head.prev) != this.head) {
            node.unlink();
        }
        return;
    }

    public Node reverseGetFirst() {
        Node node = this.head.prev;
        if (node == this.head) {
            this.current = null;
            return null;
        }
        this.current = node.prev;
        return node;
    }

    public Node reverseGetNext() {
        Node node = this.current;
        if (node == this.head) {
            this.current = null;
            return null;
        }
        this.current = node.prev;
        return node;
    }
}

