/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.cache.ondemand;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import org.necrotic.client.Client;
import org.necrotic.client.Signlink;
import org.necrotic.client.cache.Archive;
import org.necrotic.client.cache.node.Deque;
import org.necrotic.client.cache.node.NodeSubList;
import org.necrotic.client.cache.ondemand.OnDemandFetcherParent;
import org.necrotic.client.cache.ondemand.OnDemandRequest;
import org.necrotic.client.io.ByteBuffer;

public final class OnDemandFetcher
extends OnDemandFetcherParent
implements Runnable {
    private int totalFiles;
    private final Deque requested;
    private int anInt1332;
    public String statusString = "";
    private int writeLoopCycle;
    private long openSocketTime;
    private int[] mapIndices3;
    private final CRC32 crc32;
    private final byte[] ioBuffer;
    private final byte[][] fileStatus;
    private Client clientInstance;
    private final Deque extraFilesList;
    private int completedSize;
    private int expectedSize;
    private int[] anIntArray1348;
    private int[] mapIndices2;
    private int filesLoaded;
    private boolean running = true;
    private OutputStream outputStream;
    private int[] mapIndices4;
    private boolean waiting = false;
    private final Deque incompleteList;
    private final byte[] gzipInputBuffer;
    private final NodeSubList queue;
    private InputStream inputStream;
    private Socket socket;
    private final int[][] crcs;
    private int uncompletedCount;
    private int completedCount;
    private final Deque next;
    private OnDemandRequest current;
    private final Deque loadRequestList;
    private int[] mapIndices1;
    private int loopCycle;
    private byte[] modelIndices;
    public int anInt1349;
    int[] cheapHaxValues = new int[]{3627, 3628, 3655, 3656, 3625, 3626, 3629, 3630, 4071, 4072, 5253, 1816, 1817, 3653, 3654, 4067, 4068, 3639, 3640, 1976, 1977, 3571, 3572, 5129, 5130, 2066, 2067, 3545, 3546, 3559, 3560, 3569, 3570, 3551, 3552, 3579, 3580, 3575, 3576, 1766, 1767, 3547, 3548, 3682, 3683, 3696, 3697, 3692, 3693, 4013, 4079, 4080, 4082, 3996, 4083, 4084, 4075, 4076, 3664, 3993, 3994, 3995, 4077, 4078, 4073, 4074, 4011, 4012, 3998, 3999, 4081};

    public int getChecksum(int type, int id) {
        int crc = 0;
        byte[] data = this.clientInstance.decompressors[type + 1].decompress(id);
        if (data != null) {
            int length = data.length - 2;
            this.crc32.reset();
            this.crc32.update(data, 0, length);
            crc = (int)this.crc32.getValue();
        }
        return crc;
    }

    public void dump() {
        FileOutputStream fos;
        File map;
        byte[] abyte;
        int exceptions = 0;
        for (int element : this.mapIndices2) {
            try {
                abyte = this.clientInstance.decompressors[4].decompress(element);
                map = new File(Signlink.getCacheDirectory() + "/mapdata/" + element + ".gz");
                fos = new FileOutputStream(map);
                fos.write(abyte);
                fos.close();
            }
            catch (Exception e) {
                ++exceptions;
            }
        }
        for (int element : this.mapIndices3) {
            try {
                abyte = this.clientInstance.decompressors[4].decompress(element);
                map = new File(Signlink.getCacheDirectory() + "/mapdata/" + element + ".gz");
                fos = new FileOutputStream(map);
                fos.write(abyte);
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                ++exceptions;
            }
        }
    }

    public int getVersion(int type, int id) {
        int version = 1;
        byte[] data = this.clientInstance.decompressors[type + 1].decompress(id);
        if (data != null) {
            int length = data.length - 2;
            version = ((data[length] & 0xFF) << 8) + (data[length + 1] & 0xFF);
        }
        return version;
    }

    public void writeChecksumList(int type) {
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(new File(Signlink.getCacheDirectory(), type + "_crc.dat")));
            int index = 0;
            while ((long)index < this.clientInstance.decompressors[type + 1].getFileCount()) {
                out.writeInt(this.getChecksum(type, index));
                ++index;
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeVersionList(int type) {
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(new File(Signlink.getCacheDirectory(), type + "_version.dat")));
            int index = 0;
            while ((long)index < this.clientInstance.decompressors[type + 1].getFileCount()) {
                out.writeShort(this.getVersion(type, index));
                ++index;
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OnDemandFetcher() {
        this.requested = new Deque();
        this.crc32 = new CRC32();
        this.ioBuffer = new byte[500];
        this.fileStatus = new byte[5][];
        this.extraFilesList = new Deque();
        this.incompleteList = new Deque();
        this.gzipInputBuffer = new byte[3000000];
        this.queue = new NodeSubList();
        this.crcs = new int[5][];
        this.next = new Deque();
        this.loadRequestList = new Deque();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReceived() {
        OnDemandRequest onDemandData;
        Deque deque = this.loadRequestList;
        synchronized (deque) {
            onDemandData = (OnDemandRequest)this.loadRequestList.popHead();
        }
        while (onDemandData != null) {
            this.waiting = true;
            byte[] abyte0 = null;
            if (this.clientInstance.decompressors[0] != null) {
                abyte0 = this.clientInstance.decompressors[onDemandData.getDataType() + 1].decompress(onDemandData.getId());
            }
            Deque deque2 = this.loadRequestList;
            synchronized (deque2) {
                if (abyte0 == null) {
                    this.next.pushHead(onDemandData);
                } else {
                    onDemandData.setBuffer(abyte0);
                    Deque deque3 = this.incompleteList;
                    synchronized (deque3) {
                        this.incompleteList.pushHead(onDemandData);
                    }
                }
                onDemandData = (OnDemandRequest)this.loadRequestList.popHead();
            }
        }
    }

    private void closeRequest(OnDemandRequest onDemandRequest) {
        try {
            if (this.socket == null) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.openSocketTime < 4000L) {
                    return;
                }
                this.openSocketTime = currentTime;
                this.socket = this.clientInstance.createFileServerSocket(9420 + Client.portOff);
                this.inputStream = this.socket.getInputStream();
                this.outputStream = this.socket.getOutputStream();
                this.outputStream.write(15);
                for (int j = 0; j < 8; ++j) {
                    this.inputStream.read();
                }
                this.loopCycle = 0;
            }
            this.ioBuffer[0] = (byte)onDemandRequest.getDataType();
            this.ioBuffer[1] = (byte)(onDemandRequest.getId() >> 8);
            this.ioBuffer[2] = (byte)onDemandRequest.getId();
            this.ioBuffer[3] = onDemandRequest.incomplete ? 2 : (!Client.loggedIn ? 1 : 0);
            this.outputStream.write(this.ioBuffer, 0, 4);
            this.writeLoopCycle = 0;
            this.anInt1349 = -10000;
            return;
        }
        catch (IOException ioexception) {
            ++this.anInt1349;
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
            this.inputStream = null;
            this.outputStream = null;
            this.expectedSize = 0;
            ++this.anInt1349;
            return;
        }
    }

    private boolean crcMatches(int j, byte[] abyte0) {
        if (abyte0 == null || abyte0.length < 2) {
            return false;
        }
        int k = abyte0.length - 2;
        this.crc32.reset();
        this.crc32.update(abyte0, 0, k);
        int i1 = (int)this.crc32.getValue();
        return i1 == j;
    }

    public void dispose() {
        this.running = false;
    }

    @Override
    public void get(int i) {
        this.requestFileData(0, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getExtras() {
        while (this.uncompletedCount == 0 && this.completedCount < 10 && this.anInt1332 != 0) {
            OnDemandRequest onDemandData;
            Deque deque = this.extraFilesList;
            synchronized (deque) {
                onDemandData = (OnDemandRequest)this.extraFilesList.popHead();
            }
            while (onDemandData != null) {
                if (this.fileStatus[onDemandData.getDataType()][onDemandData.getId()] != 0) {
                    this.fileStatus[onDemandData.getDataType()][onDemandData.getId()] = 0;
                    this.requested.pushHead(onDemandData);
                    this.closeRequest(onDemandData);
                    this.waiting = true;
                    if (this.filesLoaded < this.totalFiles) {
                        ++this.filesLoaded;
                    }
                    this.statusString = "Loading extra files - " + this.filesLoaded * 100 / this.totalFiles + "%";
                    ++this.completedCount;
                    if (this.completedCount == 10) {
                        return;
                    }
                }
                deque = this.extraFilesList;
                synchronized (deque) {
                    onDemandData = (OnDemandRequest)this.extraFilesList.popHead();
                }
            }
            for (int j = 0; j < 4; ++j) {
                byte[] abyte0 = this.fileStatus[j];
                int k = abyte0.length;
                for (int l = 0; l < k; ++l) {
                    if (abyte0[l] != this.anInt1332) continue;
                    abyte0[l] = 0;
                    OnDemandRequest extras = new OnDemandRequest();
                    extras.setDataType(j);
                    extras.setId(l);
                    extras.incomplete = false;
                    this.requested.pushHead(extras);
                    this.closeRequest(extras);
                    this.waiting = true;
                    if (this.filesLoaded < this.totalFiles) {
                        ++this.filesLoaded;
                    }
                    this.statusString = "Downloading Extra files - " + this.filesLoaded * 100 / this.totalFiles + "% Compelete";
                    ++this.completedCount;
                    if (this.completedCount != 10) continue;
                    return;
                }
            }
            --this.anInt1332;
        }
    }

    public int getFileCount(int j) {
        return this.crcs[j].length;
    }

    public final int getMapCount(int landscapeOrObject, int regionY, int regionX) {
        int regionId = (regionX << 8) + regionY;
        for (int j1 = 0; j1 < this.mapIndices1.length; ++j1) {
            if (this.mapIndices1[j1] != regionId) continue;
            if (landscapeOrObject == 0) {
                if (this.mapIndices2[j1] >= 3700 && this.mapIndices2[j1] <= 3840) {
                    return this.mapIndices2[j1];
                }
                for (int cheapHax : this.cheapHaxValues) {
                    if (this.mapIndices2[j1] != cheapHax) continue;
                    return this.mapIndices2[j1];
                }
                int mapCount2 = this.mapIndices2[j1] > 3535 ? -1 : this.mapIndices2[j1];
                return mapCount2;
            }
            if (this.mapIndices3[j1] >= 3700 && this.mapIndices3[j1] <= 3840) {
                return this.mapIndices3[j1];
            }
            for (int cheapHax : this.cheapHaxValues) {
                if (this.mapIndices3[j1] != cheapHax) continue;
                return this.mapIndices3[j1];
            }
            int mapCount3 = this.mapIndices3[j1] > 3535 ? -1 : this.mapIndices3[j1];
            return mapCount3;
        }
        return -1;
    }

    public void setExtraPriority(byte byte0, int i, int j) {
        try {
            if (this.clientInstance.decompressors[0] == null) {
                return;
            }
            byte[] abyte0 = this.clientInstance.decompressors[i + 1].decompress(j);
            if (this.crcMatches(this.crcs[i][j], abyte0)) {
                // empty if block
            }
            this.fileStatus[i][j] = byte0;
            if (byte0 > this.anInt1332) {
                this.anInt1332 = byte0;
            }
            ++this.totalFiles;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadRegions(boolean members) {
        try {
            int total = this.mapIndices1.length;
            for (int k = 0; k < total; ++k) {
                if (!members && this.mapIndices4[k] == 0) continue;
                this.setExtraPriority((byte)2, 3, this.mapIndices3[k]);
                this.setExtraPriority((byte)2, 3, this.mapIndices2[k]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnDemandRequest getNextNode() {
        OnDemandRequest onDemandData;
        Object object = this.incompleteList;
        synchronized (object) {
            onDemandData = (OnDemandRequest)this.incompleteList.popHead();
        }
        if (onDemandData == null) {
            return null;
        }
        object = this.queue;
        synchronized (object) {
            onDemandData.unlinkSub();
        }
        if (onDemandData.getBuffer() == null) {
            return onDemandData;
        }
        int i = 0;
        try {
            GZIPInputStream gzipinputstream = new GZIPInputStream(new ByteArrayInputStream(onDemandData.getBuffer()));
            while (true) {
                if (i == this.gzipInputBuffer.length) {
                    throw new RuntimeException("buffer overflow!");
                }
                int k = gzipinputstream.read(this.gzipInputBuffer, i, this.gzipInputBuffer.length - i);
                if (k != -1) {
                    i += k;
                    continue;
                }
                break;
            }
        }
        catch (IOException _ex) {
            System.out.println("Failed to unzip - Data type: " + onDemandData.getDataType() + ". File id: " + onDemandData.getId());
            return null;
        }
        onDemandData.setBuffer(new byte[i]);
        System.arraycopy(this.gzipInputBuffer, 0, onDemandData.getBuffer(), 0, i);
        return onDemandData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemaining() {
        NodeSubList nodeSubList = this.queue;
        synchronized (nodeSubList) {
            return this.queue.getSize();
        }
    }

    private void handleFailed() {
        OnDemandRequest onDemandData_1;
        this.uncompletedCount = 0;
        this.completedCount = 0;
        OnDemandRequest onDemandData = (OnDemandRequest)this.requested.reverseGetFirst();
        while (onDemandData != null) {
            if (onDemandData.incomplete) {
                ++this.uncompletedCount;
            } else {
                ++this.completedCount;
            }
            onDemandData = (OnDemandRequest)this.requested.reverseGetNext();
        }
        while (this.uncompletedCount < 10 && (onDemandData_1 = (OnDemandRequest)this.next.popHead()) != null) {
            try {
                if (this.fileStatus[onDemandData_1.getDataType()][onDemandData_1.getId()] != 0) {
                    ++this.filesLoaded;
                }
                this.fileStatus[onDemandData_1.getDataType()][onDemandData_1.getId()] = 0;
                this.requested.pushHead(onDemandData_1);
                ++this.uncompletedCount;
                this.closeRequest(onDemandData_1);
                this.waiting = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadExtra(int file, int cache) {
        if (this.clientInstance.decompressors[0] == null) {
            return;
        }
        if (this.fileStatus[cache][file] == 0) {
            return;
        }
        if (this.anInt1332 == 0) {
            return;
        }
        OnDemandRequest onDemandData = new OnDemandRequest();
        onDemandData.setDataType(cache);
        onDemandData.setId(file);
        onDemandData.incomplete = false;
        Deque deque = this.extraFilesList;
        synchronized (deque) {
            this.extraFilesList.pushHead(onDemandData);
        }
    }

    public boolean method564(int i) {
        for (int k = 0; k < this.mapIndices1.length; ++k) {
            if (this.mapIndices3[k] != i) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExtras() {
        Deque deque = this.extraFilesList;
        synchronized (deque) {
            this.extraFilesList.removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readData() {
        try {
            int available = this.inputStream.available();
            if (this.expectedSize == 0 && available >= 7) {
                this.waiting = true;
                for (int k = 0; k < 7; k += this.inputStream.read(this.ioBuffer, k, 7 - k)) {
                }
                int dataType = this.ioBuffer[0] & 0xFF;
                int fileID = ((this.ioBuffer[1] & 0xFF) << 8) + (this.ioBuffer[2] & 0xFF);
                int fileLength = ((this.ioBuffer[3] & 0xFF) << 16) + ((this.ioBuffer[4] & 0xFF) << 8) + (this.ioBuffer[5] & 0xFF);
                int chunk = this.ioBuffer[6] & 0xFF;
                this.current = null;
                OnDemandRequest onDemandData = (OnDemandRequest)this.requested.reverseGetFirst();
                while (onDemandData != null) {
                    if (onDemandData.getDataType() == dataType && onDemandData.getId() == fileID) {
                        this.current = onDemandData;
                    }
                    if (this.current != null) {
                        onDemandData.loopCycle = 0;
                    }
                    onDemandData = (OnDemandRequest)this.requested.reverseGetNext();
                }
                if (this.current != null) {
                    this.loopCycle = 0;
                    if (fileLength == 0) {
                        Signlink.reportError("Rej: " + dataType + "," + fileID);
                        this.current.setBuffer(null);
                        if (this.current.incomplete) {
                            Deque deque = this.incompleteList;
                            synchronized (deque) {
                                this.incompleteList.pushHead(this.current);
                            }
                        } else {
                            this.current.unlink();
                        }
                        this.current = null;
                    } else {
                        if (this.current.getBuffer() == null && chunk == 0) {
                            this.current.setBuffer(new byte[fileLength]);
                        }
                        if (this.current.getBuffer() == null && chunk != 0) {
                            throw new IOException("missing start of file");
                        }
                    }
                }
                this.completedSize = chunk * 500;
                this.expectedSize = 500;
                if (this.expectedSize > fileLength - chunk * 500) {
                    this.expectedSize = fileLength - chunk * 500;
                }
            }
            if (this.expectedSize > 0 && available >= this.expectedSize) {
                this.waiting = true;
                byte[] buf = this.ioBuffer;
                int i1 = 0;
                if (this.current != null) {
                    buf = this.current.getBuffer();
                    i1 = this.completedSize;
                }
                for (int k1 = 0; k1 < this.expectedSize; k1 += this.inputStream.read(buf, k1 + i1, this.expectedSize - k1)) {
                }
                if (this.expectedSize + this.completedSize >= buf.length && this.current != null) {
                    if (this.clientInstance.decompressors[0] != null) {
                        this.clientInstance.decompressors[this.current.getDataType() + 1].method234(buf.length, buf, this.current.getId());
                    }
                    if (!this.current.incomplete && this.current.getDataType() == 3) {
                        this.current.incomplete = true;
                        this.current.setDataType(93);
                    }
                    if (this.current.incomplete) {
                        Deque deque = this.incompleteList;
                        synchronized (deque) {
                            this.incompleteList.pushHead(this.current);
                        }
                    } else {
                        this.current.unlink();
                    }
                }
                this.expectedSize = 0;
            }
        }
        catch (IOException ioexception) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
            this.inputStream = null;
            this.outputStream = null;
            this.expectedSize = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFileData(int dataType, int fileID) {
        if (dataType < 0 || fileID < 0) {
            return;
        }
        NodeSubList nodeSubList = this.queue;
        synchronized (nodeSubList) {
            OnDemandRequest onDemandData = (OnDemandRequest)this.queue.reverseGetFirst();
            while (onDemandData != null) {
                if (onDemandData.getDataType() == dataType && onDemandData.getId() == fileID) {
                    return;
                }
                onDemandData = (OnDemandRequest)this.queue.reverseGetNext();
            }
            OnDemandRequest onDemandData_1 = new OnDemandRequest();
            onDemandData_1.setDataType(dataType);
            onDemandData_1.setId(fileID);
            onDemandData_1.incomplete = true;
            Deque deque = this.loadRequestList;
            synchronized (deque) {
                this.loadRequestList.pushHead(onDemandData_1);
            }
            this.queue.insertHead(onDemandData_1);
        }
    }

    @Override
    public void run() {
        block8: while (true) {
            try {
                while (this.running) {
                    int i = 20;
                    if (this.anInt1332 == 0 && this.clientInstance.decompressors[0] != null) {
                        i = 50;
                    }
                    try {
                        Thread.sleep(i);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.waiting = true;
                    for (int j = 0; j < 100 && this.waiting; ++j) {
                        this.waiting = false;
                        this.checkReceived();
                        this.handleFailed();
                        if (this.uncompletedCount == 0 && j >= 5) break;
                        this.getExtras();
                        if (this.inputStream == null) continue;
                        this.readData();
                    }
                    boolean flag = false;
                    OnDemandRequest onDemandData = (OnDemandRequest)this.requested.reverseGetFirst();
                    while (onDemandData != null) {
                        if (onDemandData.incomplete) {
                            flag = true;
                            ++onDemandData.loopCycle;
                            if (onDemandData.loopCycle > 50) {
                                onDemandData.loopCycle = 0;
                                this.closeRequest(onDemandData);
                            }
                        }
                        onDemandData = (OnDemandRequest)this.requested.reverseGetNext();
                    }
                    if (!flag) {
                        OnDemandRequest onDemandData_1 = (OnDemandRequest)this.requested.reverseGetFirst();
                        while (onDemandData_1 != null) {
                            flag = true;
                            ++onDemandData_1.loopCycle;
                            if (onDemandData_1.loopCycle > 50) {
                                onDemandData_1.loopCycle = 0;
                                this.closeRequest(onDemandData_1);
                            }
                            onDemandData_1 = (OnDemandRequest)this.requested.reverseGetNext();
                        }
                    }
                    if (flag) {
                        ++this.loopCycle;
                        if (this.loopCycle > 750) {
                            try {
                                this.socket.close();
                            }
                            catch (Exception onDemandData_1) {
                                // empty catch block
                            }
                            this.socket = null;
                            this.inputStream = null;
                            this.outputStream = null;
                            this.expectedSize = 0;
                        }
                    } else {
                        this.loopCycle = 0;
                        this.statusString = "";
                    }
                    if (!Client.loggedIn || this.socket == null || this.outputStream == null || this.anInt1332 <= 0 && this.clientInstance.decompressors[0] != null) continue;
                    ++this.writeLoopCycle;
                    if (this.writeLoopCycle <= 500) continue;
                    this.writeLoopCycle = 0;
                    this.ioBuffer[0] = 0;
                    this.ioBuffer[1] = 0;
                    this.ioBuffer[2] = 0;
                    this.ioBuffer[3] = 10;
                    try {
                        this.outputStream.write(this.ioBuffer, 0, 4);
                        continue block8;
                    }
                    catch (IOException _ex) {
                        this.loopCycle = 5000;
                    }
                }
                break;
            }
            catch (Exception exception) {
                Signlink.reportError("od_ex " + exception.getMessage());
                break;
            }
        }
    }

    public int getModelIndex(int i) {
        return this.modelIndices[i] & 0xFF;
    }

    public void start(Archive streamLoader, Client client1) {
        byte[] abyte2 = null;
        int j1 = 0;
        String[] as1 = new String[]{"model_crc", "anim_crc", "midi_crc", "map_crc", "textures_crc"};
        for (int index = 0; index < 4; ++index) {
            byte[] abyte1 = streamLoader.get(as1[index]);
            int fileAmount = abyte1.length / 4;
            ByteBuffer stream_1 = new ByteBuffer(abyte1);
            this.crcs[index] = new int[fileAmount];
            this.fileStatus[index] = new byte[fileAmount];
            for (int fileId = 0; fileId < fileAmount; ++fileId) {
                this.crcs[index][fileId] = stream_1.getIntLittleEndian();
            }
        }
        abyte2 = streamLoader.get("model_index");
        j1 = this.crcs[0].length;
        this.modelIndices = new byte[j1];
        for (int k1 = 0; k1 < j1; ++k1) {
            this.modelIndices[k1] = k1 < abyte2.length ? abyte2[k1] : (byte)0;
        }
        abyte2 = streamLoader.get("map_index");
        ByteBuffer stream2 = new ByteBuffer(abyte2);
        int mapCount = stream2.getUnsignedShort();
        this.mapIndices1 = new int[mapCount];
        this.mapIndices2 = new int[mapCount];
        this.mapIndices3 = new int[mapCount];
        this.mapIndices4 = new int[mapCount];
        int[] dntUse = new int[]{5181, 5182, 5183, 5184, 5180, 5179, 5175, 5176, 4014, 3997, 5314, 5315, 5172};
        for (int i2 = 0; i2 < mapCount; ++i2) {
            this.mapIndices1[i2] = stream2.getUnsignedShort();
            this.mapIndices2[i2] = stream2.getUnsignedShort();
            this.mapIndices3[i2] = stream2.getUnsignedShort();
            for (int i : dntUse) {
                if (this.mapIndices2[i2] == i) {
                    this.mapIndices2[i2] = -1;
                }
                if (this.mapIndices3[i2] != i) continue;
                this.mapIndices3[i2] = -1;
            }
        }
        abyte2 = streamLoader.get("midi_index");
        stream2 = new ByteBuffer(abyte2);
        j1 = abyte2.length;
        this.anIntArray1348 = new int[j1];
        for (int k2 = 0; k2 < j1; ++k2) {
            this.anIntArray1348[k2] = stream2.getUnsignedByte();
        }
        this.clientInstance = client1;
        this.running = true;
        this.clientInstance.startRunnable(this, 2);
    }

    public boolean method569(int i) {
        return this.anIntArray1348[i] == 1;
    }

    public final int getAnimCount() {
        return 33568;
    }

    private void dumpMapIndex(int j1) throws IOException {
        try {
            File file = new File("mapIndexDumpTest.txt");
            if (file.exists()) {
                file.delete();
            } else {
                file.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            for (int id = 0; id < j1; ++id) {
                try {
                    writer.append("mapIndices1[").append(String.valueOf(id)).append("] = ").append(String.valueOf(this.mapIndices1[id]));
                    writer.newLine();
                    writer.append("mapIndices2[").append(String.valueOf(id)).append("] = ").append(String.valueOf(this.mapIndices2[id]));
                    writer.newLine();
                    writer.append("mapIndices3[").append(String.valueOf(id)).append("] = ").append(String.valueOf(this.mapIndices3[id]));
                    writer.newLine();
                    writer.newLine();
                    writer.flush();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Finished dumping Map index");
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

