/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.entity.player;

import org.necrotic.client.Client;

public class ClanMember {
    private String playerName;
    private Rank rank;

    public ClanMember(String playerName, int rankId) {
        this.playerName = playerName;
        this.rank = Rank.forId(rankId);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public Rank getRank() {
        return this.rank;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public void setRank(int rankId) {
        this.rank = Rank.forId(rankId);
    }

    public static enum Rank {
        NOT_RANKED,
        FRIEND,
        RECRUIT,
        CORPORAL,
        SERGEANT,
        LIEUTENANT,
        CAPTAIN,
        GENERAL,
        OWNER,
        BANNED,
        KICKED;


        public String getPermissionString() {
            String permission = this.toStr();
            if (this == NOT_RANKED) {
                permission = "Anyone";
            } else if (this == FRIEND) {
                permission = "Only friends";
            } else if (this == OWNER) {
                permission = "Only me";
            }
            return permission;
        }

        public String toStr() {
            return Client.capitalize(this.toString().toLowerCase().replaceAll("_", " "));
        }

        public static Rank forId(int id) {
            for (Rank rank : Rank.values()) {
                if (rank.ordinal() != id) continue;
                return rank;
            }
            return null;
        }
    }
}

