/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.graphics;

import org.necrotic.client.cache.Archive;
import org.necrotic.client.graphics.DrawingArea;
import org.necrotic.client.io.ByteBuffer;

public final class Background
extends DrawingArea {
    public byte[] imgPixels;
    public final int[] palette;
    public int imgWidth;
    public int imgHeight;
    private int xOffset;
    private int yOffset;
    public int maxWidth;
    private int maxHeight;

    public Background(Archive streamLoader, String s2, int i) {
        ByteBuffer stream = new ByteBuffer(streamLoader.get(s2 + ".dat"));
        ByteBuffer stream_1 = new ByteBuffer(streamLoader.get("index.dat"));
        stream_1.position = stream.getUnsignedShort();
        this.maxWidth = stream_1.getUnsignedShort();
        this.maxHeight = stream_1.getUnsignedShort();
        int j = stream_1.getUnsignedByte();
        this.palette = new int[j];
        for (int k = 0; k < j - 1; ++k) {
            this.palette[k + 1] = stream_1.getTribyte();
        }
        for (int l = 0; l < i; ++l) {
            stream_1.position += 2;
            stream.position += stream_1.getUnsignedShort() * stream_1.getUnsignedShort();
            ++stream_1.position;
        }
        this.xOffset = stream_1.getUnsignedByte();
        this.yOffset = stream_1.getUnsignedByte();
        this.imgWidth = stream_1.getUnsignedShort();
        this.imgHeight = stream_1.getUnsignedShort();
        int i1 = stream_1.getUnsignedByte();
        int j1 = this.imgWidth * this.imgHeight;
        this.imgPixels = new byte[j1];
        if (i1 == 0) {
            for (int k1 = 0; k1 < j1; ++k1) {
                this.imgPixels[k1] = stream.getSignedByte();
            }
            return;
        }
        if (i1 == 1) {
            for (int l1 = 0; l1 < this.imgWidth; ++l1) {
                for (int i2 = 0; i2 < this.imgHeight; ++i2) {
                    this.imgPixels[l1 + i2 * this.imgWidth] = stream.getSignedByte();
                }
            }
        }
    }

    public void method356() {
        this.maxWidth /= 2;
        this.maxHeight /= 2;
        byte[] abyte0 = new byte[this.maxWidth * this.maxHeight];
        int i = 0;
        for (int j = 0; j < this.imgHeight; ++j) {
            for (int k = 0; k < this.imgWidth; ++k) {
                abyte0[(k + this.xOffset >> 1) + (j + this.yOffset >> 1) * this.maxWidth] = this.imgPixels[i++];
            }
        }
        this.imgPixels = abyte0;
        this.imgWidth = this.maxWidth;
        this.imgHeight = this.maxHeight;
        this.xOffset = 0;
        this.yOffset = 0;
    }

    public void method357() {
        if (this.imgWidth == this.maxWidth && this.imgHeight == this.maxHeight) {
            return;
        }
        byte[] abyte0 = new byte[this.maxWidth * this.maxHeight];
        int i = 0;
        for (int j = 0; j < this.imgHeight; ++j) {
            for (int k = 0; k < this.imgWidth; ++k) {
                abyte0[k + this.xOffset + (j + this.yOffset) * this.maxWidth] = this.imgPixels[i++];
            }
        }
        this.imgPixels = abyte0;
        this.imgWidth = this.maxWidth;
        this.imgHeight = this.maxHeight;
        this.xOffset = 0;
        this.yOffset = 0;
    }

    public void method360(int i, int j, int k) {
        for (int i1 = 0; i1 < this.palette.length; ++i1) {
            int j1 = this.palette[i1] >> 16 & 0xFF;
            if ((j1 += i) < 0) {
                j1 = 0;
            } else if (j1 > 255) {
                j1 = 255;
            }
            int k1 = this.palette[i1] >> 8 & 0xFF;
            if ((k1 += j) < 0) {
                k1 = 0;
            } else if (k1 > 255) {
                k1 = 255;
            }
            int l1 = this.palette[i1] & 0xFF;
            if ((l1 += k) < 0) {
                l1 = 0;
            } else if (l1 > 255) {
                l1 = 255;
            }
            this.palette[i1] = (j1 << 16) + (k1 << 8) + l1;
        }
    }

    public void method361(int i, int k) {
        int l = (i += this.xOffset) + (k += this.yOffset) * DrawingArea.width;
        int i1 = 0;
        int j1 = this.imgHeight;
        int k1 = this.imgWidth;
        int l1 = DrawingArea.width - k1;
        int i2 = 0;
        if (k < DrawingArea.clipTop) {
            int j2 = DrawingArea.clipTop - k;
            j1 -= j2;
            k = DrawingArea.clipTop;
            i1 += j2 * k1;
            l += j2 * DrawingArea.width;
        }
        if (k + j1 > DrawingArea.clipBottom) {
            j1 -= k + j1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int k2 = DrawingArea.clipLeft - i;
            k1 -= k2;
            i = DrawingArea.clipLeft;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (i + k1 > DrawingArea.clipRight) {
            int l2 = i + k1 - DrawingArea.clipRight;
            k1 -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (k1 > 0 && j1 > 0) {
            this.method362(j1, DrawingArea.raster, this.imgPixels, l1, l, k1, i1, this.palette, i2);
        }
    }

    private void method362(int i, int[] ai, byte[] abyte0, int j, int k, int l, int i1, int[] ai1, int j1) {
        int k1 = -(l >> 2);
        l = -(l & 3);
        for (int l1 = -i; l1 < 0; ++l1) {
            for (int i2 = k1; i2 < 0; ++i2) {
                byte byte1;
                if ((byte1 = abyte0[i1++]) != 0) {
                    ai[k++] = ai1[byte1 & 0xFF];
                } else {
                    ++k;
                }
                byte1 = abyte0[i1++];
                if (byte1 != 0) {
                    ai[k++] = ai1[byte1 & 0xFF];
                } else {
                    ++k;
                }
                byte1 = abyte0[i1++];
                if (byte1 != 0) {
                    ai[k++] = ai1[byte1 & 0xFF];
                } else {
                    ++k;
                }
                byte1 = abyte0[i1++];
                if (byte1 != 0) {
                    ai[k++] = ai1[byte1 & 0xFF];
                    continue;
                }
                ++k;
            }
            for (int j2 = l; j2 < 0; ++j2) {
                byte byte2;
                if ((byte2 = abyte0[i1++]) != 0) {
                    ai[k++] = ai1[byte2 & 0xFF];
                    continue;
                }
                ++k;
            }
            k += j;
            i1 += j1;
        }
    }
}

