/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.graphics;

import org.necrotic.client.MathUtils;
import org.necrotic.client.graphics.DrawingArea;

public class ColorChooser {
    private final int width;
    private final int height;
    private final int hueWidth;
    private final int pCircleRadius;
    private final int hCircleRadius;
    private float currentHue;
    private float currentSaturation;
    private float currentBrightness;
    private int pickedColor;
    private int lastColorX;
    private int lastColorY;
    private int lastHueY;
    private final int halfCR;
    private final int halfHR;

    public ColorChooser(int width, int height, int hueWidth, int pickedCircleRadius, int hueCircleRadius) {
        this.width = width;
        this.height = height;
        this.hueWidth = hueWidth;
        this.pCircleRadius = pickedCircleRadius;
        this.hCircleRadius = hueCircleRadius;
        this.pickedColor = 0;
        this.halfCR = this.pCircleRadius / 2;
        this.halfHR = this.hCircleRadius / 2;
    }

    public void render(int x, int y) {
        DrawingArea.drawColorPicker(x, y, this.width, this.height, this.hueWidth, this.currentHue);
        this.handleBounds();
        DrawingArea.drawCircle((float)(x + this.lastColorX) - (float)this.pCircleRadius / 2.0f, (float)(y + this.lastColorY) - (float)this.pCircleRadius / 2.0f, this.pCircleRadius, this.pCircleRadius, 0xFFFFFF, 255, false);
        DrawingArea.drawCircle((float)(x + this.width) + (float)this.hueWidth / 2.0f - (float)this.halfHR, (float)(y + this.lastHueY) - (float)this.hCircleRadius / 2.0f, this.hCircleRadius, this.hCircleRadius, 0xFFFFFF, 255, false);
    }

    public void handlePick(int x, int y) {
        if (x <= this.width) {
            this.currentSaturation = MathUtils.map(x, 0.0f, this.width, 0.0f, 1.0f);
            this.currentBrightness = MathUtils.map(y, 0.0f, this.height, 1.0f, 0.0f);
            this.lastColorX = x;
            this.lastColorY = y;
        } else {
            this.currentHue = MathUtils.map(y, 0.0f, this.height, 1.0f, 0.0f);
            this.lastHueY = y;
        }
        this.pickedColor = DrawingArea.HSBtoRGB(this.currentHue, this.currentSaturation, this.currentBrightness);
    }

    private void handleBounds() {
        if (this.lastColorX >= this.width - this.halfCR) {
            this.lastColorX = this.width - this.halfCR - 1;
        }
        if (this.lastColorX <= this.halfCR) {
            this.lastColorX = this.halfCR + 1;
        }
        if (this.lastColorY >= this.height - this.halfCR) {
            this.lastColorY = this.height - this.halfCR - 1;
        }
        if (this.lastColorY <= this.halfCR) {
            this.lastColorY = this.halfCR + 1;
        }
        if (this.lastHueY >= this.height - this.halfHR) {
            this.lastHueY = this.height - this.halfHR - 1;
        }
        if (this.lastHueY <= this.halfHR) {
            this.lastHueY = this.halfHR + 1;
        }
    }

    public int getPickedColor() {
        return this.pickedColor;
    }

    public void setPickedColor(int pickedColor) {
        this.pickedColor = pickedColor;
    }
}

