/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.graphics;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.necrotic.client.graphics.DrawingArea;

public class RSImageProducer {
    public float[] depthPixels;
    public final int[] pixels;
    public final int width;
    public final int height;
    public final BufferedImage image;

    public RSImageProducer(int width, int height) {
        this.width = width;
        this.height = height;
        this.image = new BufferedImage(this.width, this.height, 1);
        this.pixels = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
        this.depthPixels = new float[width * height];
        this.initDrawingArea();
    }

    public void initDrawingArea() {
        DrawingArea.initDrawingArea(this.height, this.width, this.pixels, this.depthPixels);
    }

    public void drawGraphics(Graphics g2, int x, int y) {
        g2.drawImage(this.image, x, y, null);
    }
}

