/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.graphics;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.necrotic.client.graphics.Sprite;

public class SpritesMap
implements Closeable {
    private static final int[] requiredData = new int[]{348, 397, 3350, 3392, 3438, 3426};
    private Map<Integer, Sprite> map = new HashMap<Integer, Sprite>();
    private Map<Integer, byte[]> data = new HashMap<Integer, byte[]>();
    private FileChannel dat;
    private FileChannel idx;
    private int id;

    public SpritesMap(int id) {
        this.id = id;
    }

    public void init(String directory) throws IOException {
        this.dat = FileChannel.open(new File(directory + "main_file_sprites.dat").toPath(), StandardOpenOption.READ);
        this.idx = FileChannel.open(new File(directory + "main_file_sprites.idx").toPath(), StandardOpenOption.READ);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sprite get(int id) {
        if (id < 0) {
            return new Sprite();
        }
        Map<Integer, Sprite> map = this.map;
        if (map.containsKey(id)) {
            return map.get(id);
        }
        FileChannel dat = this.dat;
        FileChannel idx = this.idx;
        try {
            int entries = Math.toIntExact(idx.size() / 10L);
            if (id > entries) {
                return null;
            }
            idx.position(id * 10);
            ByteBuffer idxBuffer = ByteBuffer.allocate(10);
            idx.read(idxBuffer);
            idxBuffer.flip();
            int pos = (idxBuffer.get() & 0xFF) << 16 | (idxBuffer.get() & 0xFF) << 8 | idxBuffer.get() & 0xFF;
            int len = (idxBuffer.get() & 0xFF) << 16 | (idxBuffer.get() & 0xFF) << 8 | idxBuffer.get() & 0xFF;
            int offsetX = idxBuffer.getShort() & 0xFF;
            int offsetY = idxBuffer.getShort() & 0xFF;
            ByteBuffer datBuffer = ByteBuffer.allocate(len);
            dat.position(pos);
            dat.read(datBuffer);
            datBuffer.flip();
            try (ByteArrayInputStream input = new ByteArrayInputStream(datBuffer.array());){
                BufferedImage image = ImageIO.read(input);
                if (image == null) {
                    Sprite sprite2 = null;
                    return sprite2;
                }
                if (image.getType() != 2) {
                    image = this.convert(image, 2);
                }
                int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                Sprite sprite3 = new Sprite(image.getWidth(), image.getHeight(), offsetX, offsetY, pixels);
                if (Arrays.stream(requiredData).anyMatch(it -> it == id)) {
                    this.data.put(id, datBuffer.array());
                }
                map.put(id, sprite3);
                Sprite sprite = sprite3;
                return sprite;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getData(int id) {
        byte[] bytes = this.data.get(id);
        if (bytes != null) {
            return bytes;
        }
        this.get(id);
        return this.data.get(id);
    }

    BufferedImage convert(BufferedImage bimage, int type) {
        BufferedImage converted = new BufferedImage(bimage.getWidth(), bimage.getHeight(), type);
        converted.getGraphics().drawImage(bimage, 0, 0, null);
        return converted;
    }

    public void clear() {
        this.data.clear();
        this.map.clear();
    }

    @Override
    public void close() throws IOException {
        this.clear();
        this.data = null;
        this.map = null;
        this.dat.close();
        this.idx.close();
    }
}

