/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.graphics.fonts;

import java.util.Random;
import org.necrotic.client.cache.Archive;
import org.necrotic.client.graphics.DrawingArea;
import org.necrotic.client.io.ByteBuffer;

public final class TextDrawingArea
extends DrawingArea {
    public byte[][] aByteArrayArray1491;
    public int[] anIntArray1492;
    public int[] anIntArray1493;
    public int[] anIntArray1494;
    public int[] anIntArray1495;
    public int[] rsb;
    public int anInt1497;
    public Random aRandom1498;
    public boolean aBoolean1499;

    public TextDrawingArea(boolean flag, String s2, Archive streamLoader) {
        try {
            int length = s2.equals("hit_full") || s2.equals("critical_full") ? 58 : 256;
            this.aByteArrayArray1491 = new byte[length][];
            this.anIntArray1492 = new int[length];
            this.anIntArray1493 = new int[length];
            this.anIntArray1494 = new int[length];
            this.anIntArray1495 = new int[length];
            this.rsb = new int[length];
            this.aRandom1498 = new Random();
            this.aBoolean1499 = false;
            ByteBuffer stream = new ByteBuffer(streamLoader.get(s2 + ".dat"));
            ByteBuffer stream_1 = new ByteBuffer(streamLoader.get("index.dat"));
            stream_1.position = stream.getUnsignedShort() + 4;
            int k = stream_1.getUnsignedByte();
            if (k > 0) {
                stream_1.position += 3 * (k - 1);
            }
            for (int l = 0; l < length; ++l) {
                this.anIntArray1494[l] = stream_1.getUnsignedByte();
                this.anIntArray1495[l] = stream_1.getUnsignedByte();
                int i1 = this.anIntArray1492[l] = stream_1.getUnsignedShort();
                int j1 = this.anIntArray1493[l] = stream_1.getUnsignedShort();
                int k1 = stream_1.getUnsignedByte();
                int l1 = i1 * j1;
                this.aByteArrayArray1491[l] = new byte[l1];
                if (k1 == 0) {
                    for (int i2 = 0; i2 < l1; ++i2) {
                        this.aByteArrayArray1491[l][i2] = stream.getSignedByte();
                    }
                } else if (k1 == 1) {
                    for (int j2 = 0; j2 < i1; ++j2) {
                        for (int l2 = 0; l2 < j1; ++l2) {
                            this.aByteArrayArray1491[l][j2 + l2 * i1] = stream.getSignedByte();
                        }
                    }
                }
                if (j1 > this.anInt1497 && l < 128) {
                    this.anInt1497 = j1;
                }
                this.anIntArray1494[l] = 1;
                this.rsb[l] = i1 + 2;
                int k2 = 0;
                for (int i3 = j1 / 7; i3 < j1; ++i3) {
                    k2 += this.aByteArrayArray1491[l][i3 * i1];
                }
                if (k2 <= j1 / 7) {
                    int n = l;
                    this.rsb[n] = this.rsb[n] - 1;
                    this.anIntArray1494[l] = 0;
                }
                k2 = 0;
                for (int j3 = j1 / 7; j3 < j1; ++j3) {
                    k2 += this.aByteArrayArray1491[l][i1 - 1 + j3 * i1];
                }
                if (k2 > j1 / 7) continue;
                int n = l;
                this.rsb[n] = this.rsb[n] - 1;
            }
            if (flag) {
                if (this.rsb.length > 73) {
                    this.rsb[32] = this.rsb[73];
                }
            } else if (this.rsb.length > 105) {
                this.rsb[32] = this.rsb[105];
            }
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
        }
    }

    public static void drawAlphaFilledPixels(int xPos, int yPos, int pixelWidth, int pixelHeight, int color, int alpha) {
        if (xPos < clipLeft) {
            pixelWidth -= clipLeft - xPos;
            xPos = clipLeft;
        }
        if (yPos < clipTop) {
            pixelHeight -= clipTop - yPos;
            yPos = clipTop;
        }
        if (xPos + pixelWidth > clipRight) {
            pixelWidth = clipRight - xPos;
        }
        if (yPos + pixelHeight > clipBottom) {
            pixelHeight = clipBottom - yPos;
        }
        color = ((color & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((color & 0xFF00) * alpha >> 8 & 0xFF00);
        int k1 = 256 - alpha;
        int l1 = width - pixelWidth;
        int i2 = xPos + yPos * width;
        for (int j2 = 0; j2 < pixelHeight; ++j2) {
            for (int k2 = -pixelWidth; k2 < 0; ++k2) {
                int l2 = raster[i2];
                l2 = ((l2 & 0xFF00FF) * k1 >> 8 & 0xFF00FF) + ((l2 & 0xFF00) * k1 >> 8 & 0xFF00);
                TextDrawingArea.raster[i2++] = color + l2;
            }
            i2 += l1;
        }
    }

    public void method38(String s2, int i, int j, int colour, boolean flag) {
        int l = this.getTextWidth(s2) / 2;
        int i1 = this.method44();
        if (i - l > DrawingArea.clipBottom) {
            return;
        }
        if (i + l < DrawingArea.clipLeft) {
            return;
        }
        if (j - i1 > DrawingArea.clipRight) {
            return;
        }
        if (j < 0) {
            return;
        }
        this.drawText(colour, s2, i - l, j);
    }

    public int method40() {
        return this.rsb[8] - 1;
    }

    public int method44() {
        return this.rsb[6];
    }

    public void method380(String s2, int i, int j, int k) {
        this.method385(j, s2, k, i - this.method384(s2));
    }

    public void drawText(int colour, String txt, int x, int y) {
        this.method385(colour, txt, x, y - this.method384(txt) / 2);
    }

    public void drawText1(int i, String s2, int k, int l) {
        this.method385(i, s2, k, l - this.method384(s2) / 2);
    }

    public void method591(String s2, int i, int j, int k) {
        this.method385(j, s2, k, i);
    }

    public void method592(int i, int j, String s2, int l, boolean flag) {
        this.drawRegularText(flag, j, i, s2, l);
    }

    public void setPixelsInfo(int width, int height, int transparancy, int[] newPixels, byte[] oldPixels, int newOffset, int oldOffset, int place1, int place2, int color) {
        color = ((color & 0xFF00FF) * transparancy & 0xFF00FF00) + ((color & 0xFF00) * transparancy & 0xFF0000) >> 8;
        transparancy = 256 - transparancy;
        for (int j2 = -height; j2 < 0; ++j2) {
            for (int k2 = -width; k2 < 0; ++k2) {
                if (oldPixels[oldOffset++] != 0) {
                    int l2 = newPixels[newOffset];
                    newPixels[newOffset++] = (((l2 & 0xFF00FF) * transparancy & 0xFF00FF00) + ((l2 & 0xFF00) * transparancy & 0xFF0000) >> 8) + color;
                    continue;
                }
                ++newOffset;
            }
            newOffset += place1;
            oldOffset += place2;
        }
    }

    private void drawChar(byte[] text, int x, int y, int width, int height, int color, int opacity) {
        int newOffset = x + y * DrawingArea.width;
        int place1 = DrawingArea.width - width;
        int place2 = 0;
        int oldOffset = 0;
        if (y < DrawingArea.clipTop) {
            int Height2 = DrawingArea.clipTop - y;
            height -= Height2;
            y = DrawingArea.clipTop;
            oldOffset += Height2 * width;
            newOffset += Height2 * DrawingArea.width;
        }
        if (y + height >= DrawingArea.clipBottom) {
            height -= y + height - DrawingArea.clipBottom;
        }
        if (x < DrawingArea.clipLeft) {
            int toLeft = DrawingArea.clipLeft - x;
            width -= toLeft;
            x = DrawingArea.clipLeft;
            oldOffset += toLeft;
            newOffset += toLeft;
            place2 += toLeft;
            place1 += toLeft;
        }
        if (x + width >= DrawingArea.clipRight) {
            int toRight = x + width - DrawingArea.clipRight;
            width -= toRight;
            place2 += toRight;
            place1 += toRight;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        this.setPixelsInfo(width, height, opacity, DrawingArea.raster, text, newOffset, oldOffset, place1, place2, color);
    }

    public void drawTransparentText(int i, String s2, int j, int k, int l, int opacity) {
        if (s2 == null) {
            return;
        }
        j -= this.anInt1497;
        for (int i1 = 0; i1 < s2.length(); ++i1) {
            char c = s2.charAt(i1);
            if (c != ' ') {
                this.drawChar(this.aByteArrayArray1491[c], l + this.anIntArray1494[c], j + this.anIntArray1495[c], this.anIntArray1492[c], this.anIntArray1493[c], i, opacity);
            }
            l += this.rsb[c];
        }
        k = 50 / k;
    }

    public void drawOpacityText(int color, String text, int yCoord, int xCoord, int alpha) {
        this.drawTransparentText(color, text, yCoord, 822, xCoord - this.method384(text) / 2, alpha);
    }

    public void drawCenteredText(int colour, int x, String text, int y, boolean center) {
        this.drawRegularText(center, x - this.getTextWidth(text) / 2, colour, text, y);
    }

    public void drawChatInput(int i, int j, String s2, int l, boolean flag) {
        this.drawRegularText(flag, j, i, s2, l);
    }

    public int getTextWidth(String s2) {
        if (s2 == null) {
            return 0;
        }
        int j = 0;
        for (int k = 0; k < s2.length(); ++k) {
            if (s2.charAt(k) == '@' && k + 4 < s2.length() && s2.charAt(k + 4) == '@') {
                k += 4;
                continue;
            }
            j += this.rsb[s2.charAt(k)];
        }
        return j;
    }

    public int charFor(int i, String s2) {
        int j = 0;
        for (int k = 0; k < s2.length(); ++k) {
            if (s2.charAt(k) == '@' && k + 4 < s2.length() && s2.charAt(k + 4) == '@') {
                k += 4;
            } else {
                j += this.rsb[s2.charAt(k)];
            }
            if (j < i - 4 || j > i + 4) continue;
            return j;
        }
        return j;
    }

    public int method384(String s2) {
        if (s2 == null) {
            return 0;
        }
        int j = 0;
        for (int k = 0; k < s2.length(); ++k) {
            j += this.rsb[s2.charAt(k)];
        }
        return j;
    }

    public void method385(int i, String text, int j, int l) {
        if (text == null) {
            return;
        }
        j -= this.anInt1497;
        for (int i1 = 0; i1 < text.length(); ++i1) {
            char c = text.charAt(i1);
            if (c != ' ') {
                this.method392(this.aByteArrayArray1491[c], l + this.anIntArray1494[c], j + this.anIntArray1495[c], this.anIntArray1492[c], this.anIntArray1493[c], i);
            }
            l += this.rsb[c];
        }
    }

    public void method386(int i, String s2, int j, int k, int l) {
        if (s2 == null) {
            return;
        }
        j -= this.method384(s2) / 2;
        l -= this.anInt1497;
        for (int i1 = 0; i1 < s2.length(); ++i1) {
            char c = s2.charAt(i1);
            if (c != ' ') {
                this.method392(this.aByteArrayArray1491[c], j + this.anIntArray1494[c], l + this.anIntArray1495[c] + (int)(Math.sin((double)i1 / 2.0 + (double)k / 5.0) * 5.0), this.anIntArray1492[c], this.anIntArray1493[c], i);
            }
            j += this.rsb[c];
        }
    }

    public void method387(int i, String s2, int j, int k, int l) {
        if (s2 == null) {
            return;
        }
        i -= this.method384(s2) / 2;
        k -= this.anInt1497;
        for (int i1 = 0; i1 < s2.length(); ++i1) {
            char c = s2.charAt(i1);
            if (c != ' ') {
                this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c] + (int)(Math.sin((double)i1 / 5.0 + (double)j / 5.0) * 5.0), k + this.anIntArray1495[c] + (int)(Math.sin((double)i1 / 3.0 + (double)j / 5.0) * 5.0), this.anIntArray1492[c], this.anIntArray1493[c], l);
            }
            i += this.rsb[c];
        }
    }

    public void method388(int i, String s2, int j, int k, int l, int i1) {
        if (s2 == null) {
            return;
        }
        double d = 7.0 - (double)i / 8.0;
        if (d < 0.0) {
            d = 0.0;
        }
        l -= this.method384(s2) / 2;
        k -= this.anInt1497;
        for (int k1 = 0; k1 < s2.length(); ++k1) {
            char c = s2.charAt(k1);
            if (c != ' ') {
                this.method392(this.aByteArrayArray1491[c], l + this.anIntArray1494[c], k + this.anIntArray1495[c] + (int)(Math.sin((double)k1 / 1.5 + (double)j) * d), this.anIntArray1492[c], this.anIntArray1493[c], i1);
            }
            l += this.rsb[c];
        }
    }

    public void drawRegularText(boolean flag1, int i, int j, String s2, int k) {
        this.aBoolean1499 = false;
        int l = i;
        if (s2 == null) {
            return;
        }
        k -= this.anInt1497;
        for (int i1 = 0; i1 < s2.length(); ++i1) {
            if (s2.charAt(i1) == '@' && i1 + 4 < s2.length() && s2.charAt(i1 + 4) == '@') {
                int j1 = this.getColorByName(s2.substring(i1 + 1, i1 + 4));
                if (j1 != -1) {
                    j = j1;
                }
                i1 += 4;
                continue;
            }
            char c = s2.charAt(i1);
            if (c != ' ') {
                if (flag1) {
                    this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c] + 1, k + this.anIntArray1495[c] + 1, this.anIntArray1492[c], this.anIntArray1493[c], 0);
                }
                this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c], k + this.anIntArray1495[c], this.anIntArray1492[c], this.anIntArray1493[c], j);
            }
            i += this.rsb[c];
        }
        if (this.aBoolean1499) {
            DrawingArea.drawHorizontalLine(k + (int)((double)this.anInt1497 * 0.7) - 1, 0x800000, i - l, l);
        }
    }

    public void method390(int i, int j, String s2, int k, int i1) {
        if (s2 == null) {
            return;
        }
        this.aRandom1498.setSeed(k);
        int j1 = 192 + (this.aRandom1498.nextInt() & 0x1F);
        i1 -= this.anInt1497;
        for (int k1 = 0; k1 < s2.length(); ++k1) {
            if (s2.charAt(k1) == '@' && k1 + 4 < s2.length() && s2.charAt(k1 + 4) == '@') {
                int l1 = this.getColorByName(s2.substring(k1 + 1, k1 + 4));
                if (l1 != -1) {
                    j = l1;
                }
                k1 += 4;
                continue;
            }
            char c = s2.charAt(k1);
            if (c != ' ') {
                this.method394(192, i + this.anIntArray1494[c] + 1, this.aByteArrayArray1491[c], this.anIntArray1492[c], i1 + this.anIntArray1495[c] + 1, this.anIntArray1493[c], 0);
                this.method394(j1, i + this.anIntArray1494[c], this.aByteArrayArray1491[c], this.anIntArray1492[c], i1 + this.anIntArray1495[c], this.anIntArray1493[c], j);
            }
            i += this.rsb[c];
            if ((this.aRandom1498.nextInt() & 3) != 0) continue;
            ++i;
        }
    }

    private int getColorByName(String s2) {
        if (s2.equals("369")) {
            return 0x336699;
        }
        if (s2.equals("mon")) {
            return 65408;
        }
        if (s2.equals("red")) {
            return 0xFF0000;
        }
        if (s2.equals("gre")) {
            return 65280;
        }
        if (s2.equals("blu")) {
            return 255;
        }
        if (s2.equals("yel")) {
            return 0xFFFF00;
        }
        if (s2.equals("cya")) {
            return 65535;
        }
        if (s2.equals("mag")) {
            return 0xFF00FF;
        }
        if (s2.equals("whi")) {
            return 0xFFFFFF;
        }
        if (s2.equals("bla")) {
            return 0;
        }
        if (s2.equals("lre")) {
            return 16748608;
        }
        if (s2.equals("dre")) {
            return 0x800000;
        }
        if (s2.equals("dbl")) {
            return 128;
        }
        if (s2.equals("or1")) {
            return 0xFFB000;
        }
        if (s2.equals("or2")) {
            return 0xFF7000;
        }
        if (s2.equals("or3")) {
            return 0xFF3000;
        }
        if (s2.equals("gr1")) {
            return 0xC0FF00;
        }
        if (s2.equals("gr2")) {
            return 0x80FF00;
        }
        if (s2.equals("gr3")) {
            return 0x40FF00;
        }
        if (s2.equals("str")) {
            this.aBoolean1499 = true;
        }
        if (s2.equals("end")) {
            this.aBoolean1499 = false;
        }
        return -1;
    }

    private void method392(byte[] abyte0, int i, int j, int k, int l, int i1) {
        int j1 = i + j * DrawingArea.width;
        int k1 = DrawingArea.width - k;
        int l1 = 0;
        int i2 = 0;
        if (j < DrawingArea.clipTop) {
            int j2 = DrawingArea.clipTop - j;
            l -= j2;
            j = DrawingArea.clipTop;
            i2 += j2 * k;
            j1 += j2 * DrawingArea.width;
        }
        if (j + l >= DrawingArea.clipBottom) {
            l -= j + l - DrawingArea.clipBottom + 1;
        }
        if (i < DrawingArea.clipLeft) {
            int k2 = DrawingArea.clipLeft - i;
            k -= k2;
            i = DrawingArea.clipLeft;
            i2 += k2;
            j1 += k2;
            l1 += k2;
            k1 += k2;
        }
        if (i + k >= DrawingArea.clipRight) {
            int l2 = i + k - DrawingArea.clipRight + 1;
            k -= l2;
            l1 += l2;
            k1 += l2;
        }
        if (k > 0 && l > 0) {
            this.method393(DrawingArea.raster, abyte0, i1, i2, j1, k, l, k1, l1);
        }
    }

    private void method393(int[] ai, byte[] abyte0, int i, int j, int k, int l, int i1, int j1, int k1) {
        int l1 = -(l >> 2);
        l = -(l & 3);
        for (int i2 = -i1; i2 < 0; ++i2) {
            for (int j2 = l1; j2 < 0; ++j2) {
                if (abyte0[j++] != 0) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                if (abyte0[j++] != 0) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                if (abyte0[j++] != 0) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                if (abyte0[j++] != 0) {
                    ai[k++] = i;
                    continue;
                }
                ++k;
            }
            for (int k2 = l; k2 < 0; ++k2) {
                if (abyte0[j++] != 0) {
                    ai[k++] = i;
                    continue;
                }
                ++k;
            }
            k += j1;
            j += k1;
        }
    }

    private void method394(int i, int j, byte[] abyte0, int k, int l, int i1, int j1) {
        int k1 = j + l * DrawingArea.width;
        int l1 = DrawingArea.width - k;
        int i2 = 0;
        int j2 = 0;
        if (l < DrawingArea.clipTop) {
            int k2 = DrawingArea.clipTop - l;
            i1 -= k2;
            l = DrawingArea.clipTop;
            j2 += k2 * k;
            k1 += k2 * DrawingArea.width;
        }
        if (l + i1 >= DrawingArea.clipBottom) {
            i1 -= l + i1 - DrawingArea.clipBottom + 1;
        }
        if (j < DrawingArea.clipLeft) {
            int l2 = DrawingArea.clipLeft - j;
            k -= l2;
            j = DrawingArea.clipLeft;
            j2 += l2;
            k1 += l2;
            i2 += l2;
            l1 += l2;
        }
        if (j + k >= DrawingArea.clipRight) {
            int i3 = j + k - DrawingArea.clipRight + 1;
            k -= i3;
            i2 += i3;
            l1 += i3;
        }
        if (k <= 0 || i1 <= 0) {
            return;
        }
        this.method395(abyte0, i1, k1, DrawingArea.raster, j2, k, i2, l1, j1, i);
    }

    private void method395(byte[] abyte0, int i, int j, int[] ai, int l, int i1, int j1, int k1, int l1, int i2) {
        l1 = ((l1 & 0xFF00FF) * i2 & 0xFF00FF00) + ((l1 & 0xFF00) * i2 & 0xFF0000) >> 8;
        i2 = 256 - i2;
        for (int j2 = -i; j2 < 0; ++j2) {
            for (int k2 = -i1; k2 < 0; ++k2) {
                if (abyte0[l++] != 0) {
                    int l2 = ai[j];
                    ai[j++] = (((l2 & 0xFF00FF) * i2 & 0xFF00FF00) + ((l2 & 0xFF00) * i2 & 0xFF0000) >> 8) + l1;
                    continue;
                }
                ++j;
            }
            j += k1;
            l += j1;
        }
    }

    public void drawRightAlignedString(String s2, int x, int y, int color) {
        this.drawRegularText(false, x - this.method384(s2), color, s2, y);
    }
}

