/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.graphics.gameframe;

import org.necrotic.client.Client;
import org.necrotic.client.GameRenderer;

public abstract class GameFrame {
    private static ScreenMode screenMode = ScreenMode.FIXED;
    private int width;
    private int height;
    private int xPos;
    private int yPos;
    private boolean visible;
    private boolean hideComponent;

    public static ScreenMode getScreenMode() {
        return screenMode;
    }

    public static void setScreenMode(ScreenMode screenMode) {
        GameFrame.screenMode = screenMode;
        if (screenMode == ScreenMode.FIXED) {
            GameRenderer.set_max_display(765, 503);
        } else {
            GameRenderer.set_max_display(7680, 2160);
        }
    }

    private GameFrame(boolean visible, boolean hideComponent, int posX, int posY, int width, int height) {
        this.visible = visible;
        this.hideComponent = hideComponent;
        this.xPos = posX;
        this.yPos = posY;
        this.width = width;
        this.height = height;
    }

    public GameFrame(int posX, int posY, int width, int height) {
        this(true, false, posX, posY, width, height);
    }

    public boolean componentHidden() {
        return this.hideComponent;
    }

    public int getHeight() {
        return this.height;
    }

    public int getOffSetX() {
        return GameFrame.getScreenMode() == ScreenMode.FIXED ? 0 : this.getxPos();
    }

    public int getOffSetY() {
        return GameFrame.getScreenMode() == ScreenMode.FIXED ? 0 : this.getyPos();
    }

    public int getWidth() {
        return this.width;
    }

    public int getxPos() {
        return this.xPos;
    }

    public int getyPos() {
        return this.yPos;
    }

    public abstract boolean isHovering(Client var1, ScreenMode var2);

    public boolean isVisible() {
        return this.visible;
    }

    public void render(Client client) {
        this.render(client, GameFrame.getScreenMode());
    }

    protected abstract void render(Client var1, ScreenMode var2);

    public void setHeight(int height) {
        this.height = height;
    }

    public void setHideComponent(boolean hideComponent) {
        this.hideComponent = hideComponent;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setxPos(int posX) {
        this.xPos = posX;
    }

    public void setyPos(int posY) {
        this.yPos = posY;
    }

    public static boolean isFixed() {
        return screenMode == ScreenMode.FIXED;
    }

    public static enum ScreenMode {
        FIXED,
        RESIZABLE,
        FULLSCREEN;

    }
}

