/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.graphics.gameframe.impl;

import java.awt.AWTException;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import org.necrotic.client.AnimatedSprite;
import org.necrotic.client.Client;
import org.necrotic.client.RSInterface;
import org.necrotic.client.Settings.Save;
import org.necrotic.client.Signlink;
import org.necrotic.client.graphics.AnimatedPlayerName;
import org.necrotic.client.graphics.AnimatedRankName;
import org.necrotic.client.graphics.DrawingArea;
import org.necrotic.client.graphics.fonts.RSFontSystem;
import org.necrotic.client.graphics.gameframe.GameFrame;
import org.necrotic.client.graphics.rsinterface.TradingPost;
import org.necrotic.client.world.Rasterizer;

public class ChatArea
extends GameFrame {
    private static final ExecutorService SERVICE = Executors.newSingleThreadExecutor();
    public ChannelButtons channel = new ChannelButtons();
    public static final int[] SPLIT_CHAT_COLORS = new int[]{65535, 16758784, 2861308, 14942335, 12458710, 0xFFFFFF, 0, 51456, 0xFF0000, 0xFFFF00, 0xBEBEBD};
    public static final String[] CLAN_CHAT_COLORS = new String[]{"<col=26FEFD>", "<col=FDB432>", "<col=32A8F7>", "<col=E10F7C>", "<col=BA2DD0>", "<col=FFFFFF>", "<col=000000>", "<col=20C531>", "<col=FC001A>", "<col=FEFC42>", "<col=BCBCBB>"};

    public ChatArea(int posX, int posY, int width, int height) {
        super(posX, posY, width, height);
    }

    @Override
    public boolean isHovering(Client client, GameFrame.ScreenMode screenMode) {
        if (!this.isVisible()) {
            return false;
        }
        if (client.cButtonHPos != -1) {
            return true;
        }
        if (screenMode != GameFrame.ScreenMode.FIXED && client.mouseX > this.getxPos() + 478 && client.mouseX < this.getxPos() + 512 && client.mouseY > this.getyPos() + 4 && client.mouseY < this.getyPos() + 121) {
            return true;
        }
        if (screenMode != GameFrame.ScreenMode.FIXED && client.inSprite(false, Client.spritesMap.get(3), this.getxPos(), this.getyPos()) && (client.messagePromptRaised || client.aString844 != null || client.backDialogID != -1 || client.dialogID != -1 | client.inputDialogState != 0)) {
            return true;
        }
        if (client.inSprite(false, Client.spritesMap.get(17), this.getxPos() + 404, this.getyPos() + 143)) {
            return true;
        }
        return screenMode == GameFrame.ScreenMode.FIXED && client.inSprite(false, Client.spritesMap.get(3), this.getOffSetX(), this.getOffSetY());
    }

    @Override
    protected void render(Client client, GameFrame.ScreenMode screenMode) {
        if (this.isVisible()) {
            if (client.chatAreaIP == null) {
                return;
            }
            if (screenMode == GameFrame.ScreenMode.FIXED && Client.loggedIn) {
                client.chatAreaIP.initDrawingArea();
            }
            Rasterizer.lineOffsets = client.anIntArray1180;
            if (screenMode == GameFrame.ScreenMode.FIXED) {
                Client.spritesMap.get(3).drawSprite(this.getOffSetX(), this.getOffSetY());
            } else if (!this.componentHidden()) {
                if (!client.messagePromptRaised && client.aString844 == null && client.backDialogID == -1 && client.dialogID == -1 && client.inputDialogState == 0) {
                    float rate = 50.0f / (float)this.getHeight();
                    for (int i = 0; i < this.getHeight() - 35; ++i) {
                        int opacity = (int)((float)i * rate);
                        DrawingArea.fillRect(this.getOffSetX() + 5, this.getOffSetY() + 121 - i, this.getWidth() - 10, 1, 0, opacity);
                    }
                    DrawingArea.drawAlphaGradient(this.getOffSetX() + 5, this.getOffSetY() + 5, this.getWidth() - 10, 1, 11841185, 0, 250);
                } else {
                    Client.spritesMap.get(3).drawTransparentSprite(this.getOffSetX(), this.getOffSetY(), 255);
                }
            }
            this.channel.drawChannelButtons(client, screenMode);
            if (client.messagePromptRaised) {
                client.newBoldFont.drawCenteredString(client.promptMessage, 259 + this.getOffSetX(), 60 + this.getOffSetY(), 0, -1);
                client.newBoldFont.drawCenteredString(client.promptInput + "*", 259 + this.getOffSetX(), 80 + this.getOffSetY(), 128, -1);
            } else if (client.inputDialogState == 1 || client.inputDialogState == 2 || client.inputDialogState == 4) {
                client.newBoldFont.drawCenteredString(client.inputTitle != null ? client.inputTitle : "Enter amount:", this.getOffSetX() + 259, this.getOffSetY() + 60, 0, -1);
                client.newBoldFont.drawCenteredString(client.amountOrNameInput + "*", 259 + this.getOffSetX(), 80 + this.getOffSetY(), 128, -1);
            } else if (client.inputDialogState == 3) {
                client.getGrandExchange().displayItemSearch();
            } else if (client.inputDialogState == 5) {
                TradingPost.drawSearchBox();
            } else if (client.aString844 != null) {
                client.newBoldFont.drawCenteredString(client.aString844, 259 + this.getOffSetX(), 60 + this.getOffSetY(), 0, -1);
                client.newBoldFont.drawCenteredString("Click to continue", 259 + this.getOffSetX(), 80 + this.getOffSetY(), 128, -1);
            } else if (client.backDialogID != -1) {
                client.drawInterface(this.getOffSetX(), 0, RSInterface.interfaceCache[client.backDialogID], this.getOffSetY() + 20);
            } else if (client.dialogID != -1) {
                client.drawInterface(this.getOffSetX(), 0, RSInterface.interfaceCache[client.dialogID], this.getOffSetY() + 20);
            } else if (!this.componentHidden()) {
                RSFontSystem textDrawingArea = client.newRegularFont;
                int messageY = -3;
                int scrollPosition = 0;
                DrawingArea.setBounds(this.getOffSetX() + 8, this.getOffSetY() + 7, this.getOffSetX() + this.getWidth() - 22, this.getOffSetY() + this.getHeight() - 28);
                int color = 0;
                for (int i = 0; i < 500; ++i) {
                    AnimatedSprite as;
                    int xPos;
                    int substringLength;
                    if (client.chatMessages[i] == null) continue;
                    int chatType = client.chatTypes[i];
                    int positionY = 70 - messageY * 14 + Client.anInt1089 + 6;
                    String name = client.chatNames[i];
                    int playerRights = 0;
                    int ironman = 0;
                    int donorRights = 0;
                    List<Integer> chatRights = client.chatRights[i];
                    if (!chatRights.isEmpty()) {
                        playerRights = chatRights.get(0);
                        donorRights = chatRights.get(1);
                        ironman = chatRights.get(2) - 11;
                    }
                    if (name != null && name.indexOf("@") == 0) {
                        substringLength = Client.getClient().getPrefixSubstringLength(name);
                        name = name.substring(substringLength);
                    }
                    if (name != null && name.indexOf("@") == 0) {
                        substringLength = Client.getClient().getPrefixSubstringLength(name);
                        name = name.substring(substringLength);
                    }
                    color = playerRights > 0 ? AnimatedRankName.getCurrentColorByRank(playerRights) : AnimatedPlayerName.getCurrentColorByRank(donorRights);
                    if (client.chatTypeView == 0 && chatType >= 5 && chatType <= 7 && chatType != 22 && client.splitPrivateChat == 1 || client.chatTypeView == 2 && chatType != 3 && chatType != 6 && chatType != 7 || client.chatTypeView == 5 && chatType != 0 || client.chatTypeView == 3 && chatType != 4 && chatType != 22 || client.chatTypeView == 4 && chatType != 8 || client.chatTypeView == 11 && chatType != 16) continue;
                    if (chatType == 0 && (client.chatTypeView == 5 || client.chatTypeView == 0)) {
                        if (positionY > 0 && positionY < 210) {
                            xPos = 11;
                            textDrawingArea.drawBasicString(client.chatMessages[i], xPos + this.getOffSetX(), positionY + this.getOffSetY(), screenMode == GameFrame.ScreenMode.FIXED ? 0 : 0xFFFFFF, screenMode == GameFrame.ScreenMode.FIXED ? -1 : 0, true);
                        }
                        ++scrollPosition;
                        ++messageY;
                    }
                    if (!(chatType != 1 && chatType != 2 || chatType != 1 && client.publicChatMode != 0 && (client.publicChatMode != 1 || !client.isFriendOrSelf(name)) || client.chatTypeView != 1 && client.chatTypeView != 0)) {
                        if (positionY > 0 && positionY < 210) {
                            xPos = 6;
                            if (playerRights > 0) {
                                as = Client.animatedSpriteForRank(playerRights);
                                if (as != null) {
                                    if (playerRights >= 4) {
                                        xPos += 2;
                                    }
                                    as.getInstance(as.myWidth, as.myHeight).drawAdvancedSprite(xPos + 1 + this.getOffSetX(), positionY - 13 + this.getOffSetY());
                                    xPos += 15;
                                } else {
                                    client.modIcons[playerRights == 1 ? 10 : playerRights].drawTransparentSprite(xPos + 1 + this.getOffSetX(), positionY - 13 + this.getOffSetY(), 255);
                                    xPos += 14;
                                }
                            } else {
                                as = Client.animatedSpriteForDonation(donorRights);
                                if (as == null) {
                                    if (donorRights >= 1) {
                                        client.modIcons[donorRights + 5].drawTransparentSprite(xPos + 1 + this.getOffSetX(), positionY - 13 + this.getOffSetY(), 255);
                                        xPos += 15;
                                    }
                                } else {
                                    as.getInstance(as.myWidth, as.myHeight).drawAdvancedSprite(xPos + 1 + this.getOffSetX(), positionY - 11 + this.getOffSetY());
                                    xPos += 14;
                                }
                            }
                            if (ironman > 0) {
                                client.modIcons[ironman + 8].drawTransparentSprite(xPos + 4 + this.getOffSetX(), positionY - 11 + this.getOffSetY(), 255);
                                xPos += 15;
                            }
                            String title = client.chatTitles[i] == null || client.chatTitles[i].isEmpty() ? "" : client.chatTitles[i];
                            title = title.trim();
                            boolean position = false;
                            textDrawingArea.drawBasicString(name + ":", xPos + this.getOffSetX(), positionY + this.getOffSetY(), color == 0 ? (screenMode == GameFrame.ScreenMode.FIXED ? 0 : 0xFFFFFF) : color, screenMode == GameFrame.ScreenMode.FIXED ? -1 : 0, true);
                            textDrawingArea.drawBasicString(client.chatMessages[i], (xPos += textDrawingArea.getTextWidth(name + ":") + 2) + this.getOffSetX(), positionY + this.getOffSetY(), screenMode == GameFrame.ScreenMode.FIXED ? 255 : 8366591, screenMode == GameFrame.ScreenMode.FIXED ? -1 : 0, true);
                        }
                        ++scrollPosition;
                        ++messageY;
                    }
                    if ((chatType == 3 || chatType == 7) && (chatType == 7 || client.privateChatMode == 0 || client.privateChatMode == 1 && client.isFriendOrSelf(name)) && (client.chatTypeView == 2 || client.chatTypeView == 0 && client.splitPrivateChat == 0)) {
                        if (positionY > 0 && positionY < 210) {
                            xPos = 11;
                            textDrawingArea.drawBasicString("From", xPos + this.getOffSetX(), positionY + this.getOffSetY(), screenMode == GameFrame.ScreenMode.FIXED ? 0 : 0xFFFFFF, screenMode == GameFrame.ScreenMode.FIXED ? -1 : 0, true);
                            xPos += textDrawingArea.getTextWidth("From ");
                            if (playerRights > 0) {
                                as = Client.animatedSpriteForRank(playerRights);
                                if (as == null) {
                                    client.modIcons[playerRights].drawTransparentSprite(xPos + 1 + this.getOffSetX(), positionY - 11 + this.getOffSetY(), 255);
                                } else {
                                    as.getInstance(as.myWidth, as.myHeight).drawAdvancedSprite(xPos + 1 + this.getOffSetX(), positionY - 11 + this.getOffSetY());
                                    xPos += 14;
                                }
                                xPos += 14;
                            }
                            if (ironman > 0) {
                                client.modIcons[ironman].drawTransparentSprite(xPos + 1 + this.getOffSetX(), positionY - 11 + this.getOffSetY(), 255);
                                xPos += 14;
                            }
                            textDrawingArea.drawBasicString(name + ":", xPos + this.getOffSetX(), positionY + this.getOffSetY(), color == 0 ? (screenMode == GameFrame.ScreenMode.FIXED ? 0 : 0xFFFFFF) : color, screenMode == GameFrame.ScreenMode.FIXED ? -1 : 0, true);
                            textDrawingArea.drawBasicString(client.chatMessages[i], (xPos += textDrawingArea.getTextWidth(name) + 8) + this.getOffSetX(), positionY + this.getOffSetY(), screenMode == GameFrame.ScreenMode.FIXED ? 0x800000 : 16732758, screenMode == GameFrame.ScreenMode.FIXED ? -1 : 0, true);
                        }
                        ++scrollPosition;
                        ++messageY;
                    }
                    if (chatType == 4 && (client.tradeMode == 0 || client.tradeMode == 1 && client.isFriendOrSelf(name)) && (client.chatTypeView == 3 || client.chatTypeView == 0)) {
                        if (positionY > 0 && positionY < 210) {
                            textDrawingArea.drawBasicString(name + " " + client.chatMessages[i], 11 + this.getOffSetX(), positionY + this.getOffSetY(), screenMode == GameFrame.ScreenMode.FIXED ? 0x800080 : 16711892, screenMode == GameFrame.ScreenMode.FIXED ? -1 : 0, false);
                        }
                        ++scrollPosition;
                        ++messageY;
                    }
                    if (chatType == 22 && (client.tradeMode == 0 || client.tradeMode == 1 && client.isFriendOrSelf(name)) && (client.chatTypeView == 3 || client.chatTypeView == 0)) {
                        if (positionY > 0 && positionY < 210) {
                            textDrawingArea.drawBasicString(name + " " + client.chatMessages[i], 11 + this.getOffSetX(), positionY + this.getOffSetY(), screenMode == GameFrame.ScreenMode.FIXED ? 0x800080 : 16711892, screenMode == GameFrame.ScreenMode.FIXED ? -1 : 0, false);
                        }
                        ++scrollPosition;
                        ++messageY;
                    }
                    if (chatType == 5 && client.splitPrivateChat == 0 && client.privateChatMode < 2 && (client.chatTypeView == 2 || client.chatTypeView == 0)) {
                        if (positionY > 0 && positionY < 210) {
                            textDrawingArea.drawBasicString(client.chatMessages[i], 11 + this.getOffSetX(), positionY + this.getOffSetY(), screenMode == GameFrame.ScreenMode.FIXED ? 0x800000 : 16732758, screenMode == GameFrame.ScreenMode.FIXED ? -1 : 0, true);
                        }
                        ++scrollPosition;
                        ++messageY;
                    }
                    if (chatType == 6 && client.privateChatMode < 2 && (client.chatTypeView == 2 || client.chatTypeView == 0)) {
                        if (positionY > 0 && positionY < 210) {
                            textDrawingArea.drawBasicString("To " + name + ":", 11 + this.getOffSetX(), positionY + this.getOffSetY(), screenMode == GameFrame.ScreenMode.FIXED ? 0 : 0xFFFFFF, screenMode == GameFrame.ScreenMode.FIXED ? -1 : 0, true);
                            textDrawingArea.drawBasicString(client.chatMessages[i], 15 + textDrawingArea.getTextWidth("To :" + name) + this.getOffSetX(), positionY + this.getOffSetY(), screenMode == GameFrame.ScreenMode.FIXED ? 0x800000 : 16732758, screenMode == GameFrame.ScreenMode.FIXED ? -1 : 0, true);
                        }
                        ++scrollPosition;
                        ++messageY;
                    }
                    if (chatType == 8 && (client.duelStatus == 0 || client.duelStatus == 1 && client.isFriendOrSelf(name)) && (client.chatTypeView == 4 || client.chatTypeView == 0)) {
                        if (positionY > 0 && positionY < 210) {
                            textDrawingArea.drawBasicString(name + " " + client.chatMessages[i], 11 + this.getOffSetX(), positionY + this.getOffSetY(), 8270336, -1, true);
                        }
                        ++scrollPosition;
                        ++messageY;
                    }
                    if (chatType == 16 && (client.chatTypeView == 11 || client.chatTypeView == 0)) {
                        if (positionY > 0 && positionY < 210) {
                            int positionX = 11;
                            String message = (screenMode == GameFrame.ScreenMode.FIXED ? "<col=800000>" : "<col=FF5256>") + client.chatMessages[i] + "</col>";
                            textDrawingArea.drawBasicString(message, positionX, positionY + this.getOffSetY(), screenMode == GameFrame.ScreenMode.FIXED ? 0 : 0xFFFFFF, screenMode == GameFrame.ScreenMode.FIXED ? -1 : 0, true);
                        }
                        ++scrollPosition;
                        ++messageY;
                    }
                    if (chatType == 21 && (client.tradeMode == 0 || client.tradeMode == 1 && client.isFriendOrSelf(name)) && (client.chatTypeView == 3 || client.chatTypeView == 0)) {
                        if (positionY > 0 && positionY < 210) {
                            textDrawingArea.drawBasicString(name + " " + client.chatMessages[i], 11 + this.getOffSetX(), positionY + this.getOffSetX(), 15733538, -1, false);
                        }
                        ++scrollPosition;
                        ++messageY;
                    }
                    if (chatType != 22 || client.tradeMode != 0 && (client.tradeMode != 1 || !client.isFriendOrSelf(name)) || client.chatTypeView != 3 && client.chatTypeView != 0) continue;
                    if (positionY > 0 && positionY < 210) {
                        textDrawingArea.drawBasicString(name + " " + client.chatMessages[i], 11 + this.getOffSetX(), positionY + this.getOffSetX(), 15733538, -1, false);
                    }
                    ++scrollPosition;
                    ++messageY;
                }
                DrawingArea.defaultDrawingAreaSize();
                Client.anInt1211 = scrollPosition * 14 + 7 + 5;
                if (Client.anInt1211 < 111) {
                    Client.anInt1211 = 111;
                }
                client.drawScrollbar(114, Client.anInt1211 - Client.anInt1089 - 113, this.getOffSetY() + 7, this.getOffSetX() + 495, Client.anInt1211, false, screenMode != GameFrame.ScreenMode.FIXED);
                if (Client.myPlayer != null && Client.myPlayer.name != null) {
                    int drawOffsetX = this.getOffSetX() + this.getOffSetX() + 8;
                    int drawOffsetY = this.getOffSetY() + 133;
                    if (client.gameMode == 3) {
                        Client.spritesMap.get(838).drawAdvancedSprite(drawOffsetX + 1, this.getOffSetY() + 133 - 11);
                        drawOffsetX += 12;
                    }
                    if (client.myVip > 0) {
                        AnimatedSprite as;
                        int donor = client.myVip;
                        int crowns = 0;
                        switch (donor) {
                            case 1: {
                                crowns = 6;
                                break;
                            }
                            case 2: {
                                crowns = 7;
                                break;
                            }
                            case 3: {
                                crowns = 8;
                                break;
                            }
                            case 4: {
                                crowns = 9;
                                break;
                            }
                            case 5: {
                                crowns = 4;
                                break;
                            }
                            case 6: {
                                crowns = 16;
                            }
                        }
                        int yOffset = 0;
                        if (crowns == 4) {
                            yOffset = 1;
                        }
                        if ((as = Client.animatedSpriteForDonation(client.myVip)) == null) {
                            client.modIcons[crowns].drawTransparentSprite(drawOffsetX + 1, this.getOffSetY() + 133 - 11 + yOffset, 255);
                        } else {
                            as.getInstance(as.myWidth, as.myHeight).drawAdvancedSprite(drawOffsetX + 1, this.getOffSetY() + 133 - 11 + yOffset);
                        }
                        drawOffsetX += 15;
                    }
                    if (client.myRights > 0) {
                        AnimatedSprite as;
                        int crown = client.myRights;
                        int yOffset = 0;
                        if (crown == 4 || crown == 5) {
                            yOffset = 1;
                        }
                        if (crown == 7 || crown == 8) {
                            --yOffset;
                        }
                        if ((as = Client.animatedSpriteForRank(client.myRights)) == null) {
                            client.modIcons[crown].drawTransparentSprite(drawOffsetX + 1, this.getOffSetY() + 133 - 11 + yOffset, 255);
                        } else {
                            as.getInstance(as.myWidth, as.myHeight).drawAdvancedSprite(drawOffsetX + 1, this.getOffSetY() + 133 - 11 + yOffset);
                        }
                        drawOffsetX += 15;
                    }
                    if (client.gameMode > 0 && client.gameMode != 3) {
                        client.modIcons[8 + client.gameMode].drawTransparentSprite(drawOffsetX + 4, this.getOffSetY() + 133 - 11, 255);
                        drawOffsetX += 15;
                    }
                    if (Client.myPlayer.loyaltyTitle != null && !Client.myPlayer.loyaltyTitle.isEmpty()) {
                        drawOffsetX += 3;
                    }
                    color = AnimatedPlayerName.getCurrentColorByRank(Client.myPlayer.playerRights);
                    textDrawingArea.drawBasicString(Client.myPlayer.loyaltyTitle + "<col=000000> </col>", drawOffsetX, drawOffsetY, Client.myPlayer.loyaltyColor, -1, true);
                    textDrawingArea.drawBasicString(Client.myPlayer.name + ":", drawOffsetX += textDrawingArea.getTextWidth(Client.myPlayer.loyaltyTitle) + 3, drawOffsetY, color == 0 ? (screenMode == GameFrame.ScreenMode.FIXED ? 0 : 0xFFFFFF) : color, -1, true);
                    textDrawingArea.drawBasicString(" " + RSFontSystem.handleOldSyntax(Client.inputString) + "*", drawOffsetX += textDrawingArea.getTextWidth(Client.myPlayer.name) + 2, drawOffsetY, ChatArea.getScreenMode() == GameFrame.ScreenMode.FIXED ? 255 : 8366591, -1, false);
                }
                this.drawSplitChatSelectionBox(client);
                this.drawClanChatSelectionBox(client);
                DrawingArea.fillRect(this.getOffSetX() + 7, this.getOffSetY() + 121, this.getWidth() - 13, 1, screenMode == GameFrame.ScreenMode.FIXED ? 8418912 : 11446169, 150);
            }
            if (client.menuOpen && client.menuScreenArea == 2) {
                client.drawMenu();
            }
            if (screenMode == GameFrame.ScreenMode.FIXED) {
                client.chatAreaIP.drawGraphics(Client.canvas.getGraphics(), this.getxPos(), this.getyPos());
            }
            client.gameScreenIP.initDrawingArea();
            Rasterizer.lineOffsets = client.anIntArray1182;
        }
    }

    private boolean clickSplitChatSelectionBox(Client client) {
        int splitBoxX = 480;
        int splitBoxY = 122 + (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 0 : 2);
        if (client.getClickMode2() == 1 && client.mouseX >= splitBoxX && client.mouseX <= splitBoxX + 16 && client.mouseY >= this.getyPos() + splitBoxY && client.mouseY <= this.getyPos() + splitBoxY + 13) {
            client.setClickMode2(0);
            client.splitChatColor = client.splitChatColor + 1 == SPLIT_CHAT_COLORS.length ? 0 : client.splitChatColor + 1;
            Save.settings(Client.getClient());
            client.pushMessage("You've changed your private split-chat color.", 0, "");
            return true;
        }
        return false;
    }

    private void drawSplitChatSelectionBox(Client client) {
        try {
            int splitBoxX = 480;
            int splitBoxY = 122 + (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 0 : 2);
            DrawingArea.fillRect(splitBoxX + 1, this.getOffSetY() + splitBoxY + 1, 15, 12, SPLIT_CHAT_COLORS[client.splitChatColor], 255);
            DrawingArea.fillPixels(splitBoxX, 16, 13, 0, this.getOffSetY() + splitBoxY);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            client.splitChatColor = 0;
        }
    }

    private boolean clickClanChatSelectionBox(Client client) {
        int splitBoxX = 495;
        int splitBoxY = 122 + (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 0 : 2);
        if (client.getClickMode2() == 1 && client.mouseX >= splitBoxX && client.mouseX <= splitBoxX + 16 && client.mouseY >= this.getyPos() + splitBoxY && client.mouseY <= this.getyPos() + splitBoxY + 13) {
            client.setClickMode2(0);
            client.clanChatColor = client.clanChatColor + 1 == SPLIT_CHAT_COLORS.length ? 0 : client.clanChatColor + 1;
            Save.settings(Client.getClient());
            client.pushMessage("You've changed your clan chat color.", 0, "");
            return true;
        }
        return false;
    }

    private void drawClanChatSelectionBox(Client client) {
        try {
            if (client.clanChatColor > SPLIT_CHAT_COLORS.length + 1) {
                client.clanChatColor = 0;
            }
            int splitBoxX = 495;
            int splitBoxY = 122 + (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 0 : 2);
            DrawingArea.fillRect(splitBoxX + 1, this.getOffSetY() + splitBoxY + 1, 15, 12, SPLIT_CHAT_COLORS[client.clanChatColor], 255);
            DrawingArea.fillPixels(splitBoxX, 16, 13, 0, this.getOffSetY() + splitBoxY);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            client.splitChatColor = 0;
        }
    }

    public void toggleButton(Client client, int button) {
        if (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED) {
            return;
        }
        if (client.cButtonCPos == button) {
            this.setHideComponent(!this.componentHidden());
        } else {
            this.setHideComponent(false);
        }
    }

    public class ChannelButtons {
        private final String[] channelText = new String[]{"All", "Game", "Public", "Private", "Clan", "Trade", "Duel", "Screenshot"};
        private final int[] channelXCoords = new int[]{5, 62, 119, 176, 233, 290, 347, 430};
        private final String[] chatStatus = new String[]{"On", "Friends", "Off", "Hide", "All"};
        private final int[] chatTextColor = new int[]{65280, 0xFFFF00, 0xFF0000, 65535, 0xFFFF00, 65280};
        private final String[][] chatMenuText = new String[][]{{"View All"}, {"View Game"}, {"Hide Public", "Off Public", "Friends Public", "On Public", "View Public"}, {"Off Private", "Friends Private", "On Private", "View Private"}, {"Off Clan chat", "Friends Clan chat", "On Clan chat", "View Clan chat"}, {"Off Trade", "Friends Trade", "On Trade", "View Trade"}, {"Off Duel", "Friends Duel", "On Duel", "View Duel"}};
        private final int[][] actions = new int[][]{{999}, {998}, {997, 996, 995, 994, 993}, {992, 991, 990, 989}, {1003, 1002, 1001, 1000}, {987, 986, 985, 984}, {983, 982, 981, 980}};

        public void drawChannelButtons(Client client, GameFrame.ScreenMode screenMode) {
            int i;
            if (screenMode != GameFrame.ScreenMode.FIXED) {
                Client.spritesMap.get(4).drawSprite(ChatArea.this.getOffSetX() + 5, ChatArea.this.getOffSetY() + 143);
            }
            switch (client.cButtonCPos) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    Client.spritesMap.get(1).drawSprite(ChatArea.this.getOffSetX() + this.channelXCoords[client.cButtonCPos], ChatArea.this.getOffSetY() + 143);
                }
            }
            if (client.cButtonHPos == client.cButtonCPos) {
                switch (client.cButtonHPos) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        Client.spritesMap.get(2).drawSprite(ChatArea.this.getOffSetX() + this.channelXCoords[client.cButtonHPos], ChatArea.this.getOffSetY() + 143);
                        break;
                    }
                }
            } else {
                switch (client.cButtonHPos) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        Client.spritesMap.get(0).drawSprite(ChatArea.this.getOffSetX() + this.channelXCoords[client.cButtonHPos], ChatArea.this.getOffSetY() + 143);
                        break;
                    }
                }
            }
            if (client.inSprite(false, Client.spritesMap.get(17), ChatArea.this.getxPos() + 404, ChatArea.this.getyPos() + 143)) {
                Client.spritesMap.get(17).drawSprite(ChatArea.this.getOffSetX() + 404, ChatArea.this.getOffSetY() + 143);
            }
            for (i = 0; i < this.channelText.length; ++i) {
                client.smallText.drawCenteredText(0xFFFFFF, ChatArea.this.getOffSetX() + this.channelXCoords[i] + 28, this.channelText[i], ChatArea.this.getOffSetY() + (i < 2 || i == 7 ? 157 : 154), true);
            }
            for (i = 0; i < this.chatStatus.length; ++i) {
                client.smallText.drawCenteredText(this.chatTextColor[this.getChatStatus(i, client)], ChatArea.this.getOffSetX() + 142 + this.channelXCoords[i], this.chatStatus[this.getChatStatus(i, client)], ChatArea.this.getOffSetY() + 164, true);
            }
        }

        private final int getChatStatus(int i, Client client) {
            return i == 0 ? client.publicChatMode : (i == 1 ? client.privateChatMode : (i == 2 ? 0 : (i == 3 ? client.tradeMode : client.duelStatus)));
        }

        public void processChatModeActions(Client client, GameFrame.ScreenMode screenMode) {
            if (ChatArea.this.isVisible()) {
                int i;
                for (i = 0; i < this.channelXCoords.length - 1; ++i) {
                    if (client.inSprite(false, Client.spritesMap.get(0), ChatArea.this.getxPos() + this.channelXCoords[i], ChatArea.this.getyPos() + 143)) {
                        client.cButtonHPos = i;
                        client.setInputTaken(true);
                        break;
                    }
                    client.cButtonHPos = -1;
                    client.setInputTaken(true);
                }
                if (ChatArea.this.clickClanChatSelectionBox(client)) {
                    return;
                }
                if (ChatArea.this.clickSplitChatSelectionBox(client)) {
                    return;
                }
                if (client.inSprite(true, Client.spritesMap.get(17), ChatArea.this.getxPos() + 404, ChatArea.this.getyPos() + 143)) {
                    SERVICE.execute(() -> {
                        try {
                            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                            Point point = window.getLocationOnScreen();
                            Robot robot = new Robot(window.getGraphicsConfiguration().getDevice());
                            Rectangle rectangle = new Rectangle((int)point.getX(), (int)point.getY(), window.getWidth(), window.getHeight());
                            BufferedImage img = robot.createScreenCapture(rectangle);
                            Path path = Paths.get(Signlink.getCacheDirectory().toString(), "screenshots");
                            if (!Files.exists(path, new LinkOption[0])) {
                                Files.createDirectories(path, new FileAttribute[0]);
                            }
                            SimpleDateFormat format = new SimpleDateFormat("MM-dd-yyyy hh-mm-ss a");
                            File file = new File(path.toFile(), format.format(new Date()) + ".png");
                            ImageIO.write((RenderedImage)img, "png", file);
                            client.pushMessage("A screenshot has been taken and placed in your data folder.", 0, "");
                        }
                        catch (AWTException | IOException reason) {
                            client.pushMessage("An error occured whilst capturing your screenshot.", 0, "");
                            throw new RuntimeException("Fatal error whilst capturing screenshot", reason);
                        }
                    });
                }
                for (i = 0; i < this.chatMenuText.length; ++i) {
                    if (!client.inSprite(false, Client.spritesMap.get(0), ChatArea.this.getxPos() + this.channelXCoords[i], ChatArea.this.getyPos() + 143)) continue;
                    for (int id = 0; id < this.chatMenuText[i].length; ++id) {
                        client.menuActionName[client.menuActionRow] = this.chatMenuText[i][id];
                        client.menuActionID[client.menuActionRow] = this.actions[i][id];
                        ++client.menuActionRow;
                    }
                }
            }
        }
    }
}

